/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPotion
extends Item {
    public ItemPotion() {
        this.setMaxStackSize(1);
        this.setCreativeTab(CreativeTabs.BREWING);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getDefaultInstance() {
        return PotionUtils.addPotionToItemStack(super.getDefaultInstance(), PotionTypes.WATER);
    }

    @Override
    public ItemStack onItemUseFinish(ItemStack p_onItemUseFinish_1_, World p_onItemUseFinish_2_, EntityLivingBase p_onItemUseFinish_3_) {
        EntityPlayer lvt_4_1_;
        EntityPlayer entityPlayer = lvt_4_1_ = p_onItemUseFinish_3_ instanceof EntityPlayer ? (EntityPlayer)p_onItemUseFinish_3_ : null;
        if (lvt_4_1_ == null || !lvt_4_1_.capabilities.isCreativeMode) {
            p_onItemUseFinish_1_.shrink(1);
        }
        if (!p_onItemUseFinish_2_.isRemote) {
            List<PotionEffect> lvt_5_1_ = PotionUtils.getEffectsFromStack(p_onItemUseFinish_1_);
            for (PotionEffect lvt_7_1_ : lvt_5_1_) {
                if (lvt_7_1_.getPotion().isInstant()) {
                    lvt_7_1_.getPotion().affectEntity(lvt_4_1_, lvt_4_1_, p_onItemUseFinish_3_, lvt_7_1_.getAmplifier(), 1.0);
                    continue;
                }
                p_onItemUseFinish_3_.addPotionEffect(new PotionEffect(lvt_7_1_));
            }
        }
        if (lvt_4_1_ != null) {
            lvt_4_1_.addStat(StatList.getObjectUseStats(this));
        }
        if (lvt_4_1_ == null || !lvt_4_1_.capabilities.isCreativeMode) {
            if (p_onItemUseFinish_1_.isEmpty()) {
                return new ItemStack(Items.GLASS_BOTTLE);
            }
            if (lvt_4_1_ != null) {
                lvt_4_1_.inventory.addItemStackToInventory(new ItemStack(Items.GLASS_BOTTLE));
            }
        }
        return p_onItemUseFinish_1_;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack p_getMaxItemUseDuration_1_) {
        return 32;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack p_getItemUseAction_1_) {
        return EnumAction.DRINK;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        p_onItemRightClick_2_.setActiveHand(p_onItemRightClick_3_);
        return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_));
    }

    @Override
    public String getItemStackDisplayName(ItemStack p_getItemStackDisplayName_1_) {
        return I18n.translateToLocal(PotionUtils.getPotionFromItem(p_getItemStackDisplayName_1_).getNamePrefixed("potion.effect."));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack p_addInformation_1_, EntityPlayer p_addInformation_2_, List<String> p_addInformation_3_, boolean p_addInformation_4_) {
        PotionUtils.addPotionTooltip(p_addInformation_1_, p_addInformation_3_, 1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack p_hasEffect_1_) {
        return super.hasEffect(p_hasEffect_1_) || !PotionUtils.getEffectsFromStack(p_hasEffect_1_).isEmpty();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item p_getSubItems_1_, CreativeTabs p_getSubItems_2_, NonNullList<ItemStack> p_getSubItems_3_) {
        for (PotionType lvt_5_1_ : PotionType.REGISTRY) {
            if (lvt_5_1_ == PotionTypes.EMPTY) continue;
            p_getSubItems_3_.add(PotionUtils.addPotionToItemStack(new ItemStack(p_getSubItems_1_), lvt_5_1_));
        }
    }
}

