/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRecord
extends Item {
    private static final Map<SoundEvent, ItemRecord> RECORDS = Maps.newHashMap();
    private final SoundEvent sound;
    private final String displayName;

    protected ItemRecord(String p_i46742_1_, SoundEvent p_i46742_2_) {
        this.displayName = "item.record." + p_i46742_1_ + ".desc";
        this.sound = p_i46742_2_;
        this.maxStackSize = 1;
        this.setCreativeTab(CreativeTabs.MISC);
        RECORDS.put(this.sound, this);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        IBlockState iblockstate = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        if (iblockstate.getBlock() == Blocks.JUKEBOX && !iblockstate.getValue(BlockJukebox.HAS_RECORD).booleanValue()) {
            if (!p_onItemUse_2_.isRemote) {
                ItemStack itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
                ((BlockJukebox)Blocks.JUKEBOX).insertRecord(p_onItemUse_2_, p_onItemUse_3_, iblockstate, itemstack);
                p_onItemUse_2_.playEvent(null, 1010, p_onItemUse_3_, Item.getIdFromItem(this));
                itemstack.shrink(1);
                p_onItemUse_1_.addStat(StatList.RECORD_PLAYED);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack p_addInformation_1_, EntityPlayer p_addInformation_2_, List<String> p_addInformation_3_, boolean p_addInformation_4_) {
        p_addInformation_3_.add(this.getRecordNameLocal());
    }

    public ResourceLocation getRecordResource(String p_getRecordResource_1_) {
        return new ResourceLocation(p_getRecordResource_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public String getRecordNameLocal() {
        return I18n.translateToLocal(this.displayName);
    }

    @Override
    public EnumRarity getRarity(ItemStack p_getRarity_1_) {
        return EnumRarity.RARE;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static ItemRecord getBySound(SoundEvent p_getBySound_0_) {
        return RECORDS.get(p_getBySound_0_);
    }

    @SideOnly(value=Side.CLIENT)
    public SoundEvent getSound() {
        return this.sound;
    }
}

