/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class ItemSeeds
extends Item
implements IPlantable {
    private final Block crops;
    private final Block soilBlockID;

    public ItemSeeds(Block p_i45352_1_, Block p_i45352_2_) {
        this.crops = p_i45352_1_;
        this.soilBlockID = p_i45352_2_;
        this.setCreativeTab(CreativeTabs.MATERIALS);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        ItemStack itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        IBlockState state = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        if (p_onItemUse_5_ == EnumFacing.UP && p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_.offset(p_onItemUse_5_), p_onItemUse_5_, itemstack) && state.getBlock().canSustainPlant(state, p_onItemUse_2_, p_onItemUse_3_, EnumFacing.UP, this) && p_onItemUse_2_.isAirBlock(p_onItemUse_3_.up())) {
            p_onItemUse_2_.setBlockState(p_onItemUse_3_.up(), this.crops.getDefaultState());
            itemstack.shrink(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public EnumPlantType getPlantType(IBlockAccess p_getPlantType_1_, BlockPos p_getPlantType_2_) {
        return this.crops == Blocks.NETHER_WART ? EnumPlantType.Nether : EnumPlantType.Crop;
    }

    @Override
    public IBlockState getPlant(IBlockAccess p_getPlant_1_, BlockPos p_getPlant_2_) {
        return this.crops.getDefaultState();
    }
}

