/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class ItemShears
extends Item {
    public ItemShears() {
        this.setMaxStackSize(1);
        this.setMaxDamage(238);
        this.setCreativeTab(CreativeTabs.TOOLS);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack p_onBlockDestroyed_1_, World p_onBlockDestroyed_2_, IBlockState p_onBlockDestroyed_3_, BlockPos p_onBlockDestroyed_4_, EntityLivingBase p_onBlockDestroyed_5_) {
        if (!p_onBlockDestroyed_2_.isRemote) {
            p_onBlockDestroyed_1_.damageItem(1, p_onBlockDestroyed_5_);
        }
        Block block = p_onBlockDestroyed_3_.getBlock();
        return p_onBlockDestroyed_3_.getMaterial() != Material.LEAVES && block != Blocks.WEB && block != Blocks.TALLGRASS && block != Blocks.VINE && block != Blocks.TRIPWIRE && block != Blocks.WOOL && !(p_onBlockDestroyed_3_ instanceof IShearable) ? super.onBlockDestroyed(p_onBlockDestroyed_1_, p_onBlockDestroyed_2_, p_onBlockDestroyed_3_, p_onBlockDestroyed_4_, p_onBlockDestroyed_5_) : true;
    }

    @Override
    public boolean canHarvestBlock(IBlockState p_canHarvestBlock_1_) {
        Block block = p_canHarvestBlock_1_.getBlock();
        return block == Blocks.WEB || block == Blocks.REDSTONE_WIRE || block == Blocks.TRIPWIRE;
    }

    @Override
    public float getStrVsBlock(ItemStack p_getStrVsBlock_1_, IBlockState p_getStrVsBlock_2_) {
        Block block = p_getStrVsBlock_2_.getBlock();
        return block != Blocks.WEB && p_getStrVsBlock_2_.getMaterial() != Material.LEAVES ? (block == Blocks.WOOL ? 5.0f : super.getStrVsBlock(p_getStrVsBlock_1_, p_getStrVsBlock_2_)) : 15.0f;
    }

    @Override
    public boolean itemInteractionForEntity(ItemStack p_itemInteractionForEntity_1_, EntityPlayer p_itemInteractionForEntity_2_, EntityLivingBase p_itemInteractionForEntity_3_, EnumHand p_itemInteractionForEntity_4_) {
        if (p_itemInteractionForEntity_3_.world.isRemote) {
            return false;
        }
        if (p_itemInteractionForEntity_3_ instanceof IShearable) {
            IShearable target = (IShearable)((Object)p_itemInteractionForEntity_3_);
            BlockPos pos = new BlockPos(p_itemInteractionForEntity_3_.posX, p_itemInteractionForEntity_3_.posY, p_itemInteractionForEntity_3_.posZ);
            if (target.isShearable(p_itemInteractionForEntity_1_, p_itemInteractionForEntity_3_.world, pos)) {
                List<ItemStack> drops = target.onSheared(p_itemInteractionForEntity_1_, p_itemInteractionForEntity_3_.world, pos, EnchantmentHelper.getEnchantmentLevel(Enchantments.FORTUNE, p_itemInteractionForEntity_1_));
                Random rand = new Random();
                for (ItemStack stack : drops) {
                    EntityItem ent = p_itemInteractionForEntity_3_.entityDropItem(stack, 1.0f);
                    ent.motionY += (double)(rand.nextFloat() * 0.05f);
                    ent.motionX += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.motionZ += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
                p_itemInteractionForEntity_1_.damageItem(1, p_itemInteractionForEntity_3_);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack p_onBlockStartBreak_1_, BlockPos p_onBlockStartBreak_2_, EntityPlayer p_onBlockStartBreak_3_) {
        IShearable target;
        if (p_onBlockStartBreak_3_.world.isRemote || p_onBlockStartBreak_3_.capabilities.isCreativeMode) {
            return false;
        }
        Block block = p_onBlockStartBreak_3_.world.getBlockState(p_onBlockStartBreak_2_).getBlock();
        if (block instanceof IShearable && (target = (IShearable)((Object)block)).isShearable(p_onBlockStartBreak_1_, p_onBlockStartBreak_3_.world, p_onBlockStartBreak_2_)) {
            List<ItemStack> drops = target.onSheared(p_onBlockStartBreak_1_, p_onBlockStartBreak_3_.world, p_onBlockStartBreak_2_, EnchantmentHelper.getEnchantmentLevel(Enchantments.FORTUNE, p_onBlockStartBreak_1_));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(p_onBlockStartBreak_3_.world, (double)p_onBlockStartBreak_2_.getX() + d, (double)p_onBlockStartBreak_2_.getY() + d1, (double)p_onBlockStartBreak_2_.getZ() + d2, stack);
                entityitem.setDefaultPickupDelay();
                p_onBlockStartBreak_3_.world.spawnEntity(entityitem);
            }
            p_onBlockStartBreak_1_.damageItem(1, p_onBlockStartBreak_3_);
            p_onBlockStartBreak_3_.addStat(StatList.getBlockStats(block));
        }
        return false;
    }
}

