/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class ItemSkull
extends Item {
    private static final String[] SKULL_TYPES = new String[]{"skeleton", "wither", "zombie", "char", "creeper", "dragon"};

    public ItemSkull() {
        this.setCreativeTab(CreativeTabs.DECORATIONS);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        ItemStack itemstack;
        IBlockState iblockstate;
        Block block;
        boolean flag;
        if (p_onItemUse_5_ == EnumFacing.DOWN) {
            return EnumActionResult.FAIL;
        }
        if (p_onItemUse_2_.getBlockState(p_onItemUse_3_).getBlock().isReplaceable(p_onItemUse_2_, p_onItemUse_3_)) {
            p_onItemUse_5_ = EnumFacing.UP;
            p_onItemUse_3_ = p_onItemUse_3_.down();
        }
        if (!(flag = (block = (iblockstate = p_onItemUse_2_.getBlockState(p_onItemUse_3_)).getBlock()).isReplaceable(p_onItemUse_2_, p_onItemUse_3_))) {
            if (!p_onItemUse_2_.getBlockState(p_onItemUse_3_).getMaterial().isSolid() && !p_onItemUse_2_.isSideSolid(p_onItemUse_3_, p_onItemUse_5_, true)) {
                return EnumActionResult.FAIL;
            }
            p_onItemUse_3_ = p_onItemUse_3_.offset(p_onItemUse_5_);
        }
        if (p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_, p_onItemUse_5_, itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_)) && Blocks.SKULL.canPlaceBlockAt(p_onItemUse_2_, p_onItemUse_3_)) {
            TileEntity tileentity;
            if (p_onItemUse_2_.isRemote) {
                return EnumActionResult.SUCCESS;
            }
            p_onItemUse_2_.setBlockState(p_onItemUse_3_, Blocks.SKULL.getDefaultState().withProperty(BlockSkull.FACING, p_onItemUse_5_), 11);
            int i = 0;
            if (p_onItemUse_5_ == EnumFacing.UP) {
                i = MathHelper.floor((double)(p_onItemUse_1_.rotationYaw * 16.0f / 360.0f) + 0.5) & 0xF;
            }
            if ((tileentity = p_onItemUse_2_.getTileEntity(p_onItemUse_3_)) instanceof TileEntitySkull) {
                TileEntitySkull tileentityskull = (TileEntitySkull)tileentity;
                if (itemstack.getMetadata() == 3) {
                    GameProfile gameprofile = null;
                    if (itemstack.hasTagCompound()) {
                        NBTTagCompound nbttagcompound = itemstack.getTagCompound();
                        if (nbttagcompound.hasKey("SkullOwner", 10)) {
                            gameprofile = NBTUtil.readGameProfileFromNBT(nbttagcompound.getCompoundTag("SkullOwner"));
                        } else if (nbttagcompound.hasKey("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)nbttagcompound.getString("SkullOwner"))) {
                            gameprofile = new GameProfile((UUID)null, nbttagcompound.getString("SkullOwner"));
                        }
                    }
                    tileentityskull.setPlayerProfile(gameprofile);
                } else {
                    tileentityskull.setType(itemstack.getMetadata());
                }
                tileentityskull.setSkullRotation(i);
                Blocks.SKULL.checkWitherSpawn(p_onItemUse_2_, p_onItemUse_3_, tileentityskull);
            }
            itemstack.shrink(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item p_getSubItems_1_, CreativeTabs p_getSubItems_2_, NonNullList<ItemStack> p_getSubItems_3_) {
        for (int i = 0; i < SKULL_TYPES.length; ++i) {
            p_getSubItems_3_.add(new ItemStack(p_getSubItems_1_, 1, i));
        }
    }

    @Override
    public int getMetadata(int p_getMetadata_1_) {
        return p_getMetadata_1_;
    }

    @Override
    public String getUnlocalizedName(ItemStack p_getUnlocalizedName_1_) {
        int i = p_getUnlocalizedName_1_.getMetadata();
        if (i < 0 || i >= SKULL_TYPES.length) {
            i = 0;
        }
        return super.getUnlocalizedName() + "." + SKULL_TYPES[i];
    }

    @Override
    public String getItemStackDisplayName(ItemStack p_getItemStackDisplayName_1_) {
        if (p_getItemStackDisplayName_1_.getMetadata() == 3 && p_getItemStackDisplayName_1_.hasTagCompound()) {
            NBTTagCompound nbttagcompound;
            if (p_getItemStackDisplayName_1_.getTagCompound().hasKey("SkullOwner", 8)) {
                return I18n.translateToLocalFormatted("item.skull.player.name", p_getItemStackDisplayName_1_.getTagCompound().getString("SkullOwner"));
            }
            if (p_getItemStackDisplayName_1_.getTagCompound().hasKey("SkullOwner", 10) && (nbttagcompound = p_getItemStackDisplayName_1_.getTagCompound().getCompoundTag("SkullOwner")).hasKey("Name", 8)) {
                return I18n.translateToLocalFormatted("item.skull.player.name", nbttagcompound.getString("Name"));
            }
        }
        return super.getItemStackDisplayName(p_getItemStackDisplayName_1_);
    }

    @Override
    public boolean updateItemStackNBT(NBTTagCompound p_updateItemStackNBT_1_) {
        super.updateItemStackNBT(p_updateItemStackNBT_1_);
        if (p_updateItemStackNBT_1_.hasKey("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)p_updateItemStackNBT_1_.getString("SkullOwner"))) {
            GameProfile gameprofile = new GameProfile((UUID)null, p_updateItemStackNBT_1_.getString("SkullOwner"));
            gameprofile = TileEntitySkull.updateGameprofile(gameprofile);
            p_updateItemStackNBT_1_.setTag("SkullOwner", NBTUtil.writeGameProfile(new NBTTagCompound(), gameprofile));
            return true;
        }
        return false;
    }
}

