/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSlab
extends ItemBlock {
    private final BlockSlab singleSlab;
    private final BlockSlab doubleSlab;

    public ItemSlab(Block p_i45782_1_, BlockSlab p_i45782_2_, BlockSlab p_i45782_3_) {
        super(p_i45782_1_);
        this.singleSlab = p_i45782_2_;
        this.doubleSlab = p_i45782_3_;
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @Override
    public int getMetadata(int p_getMetadata_1_) {
        return p_getMetadata_1_;
    }

    @Override
    public String getUnlocalizedName(ItemStack p_getUnlocalizedName_1_) {
        return this.singleSlab.getUnlocalizedName(p_getUnlocalizedName_1_.getMetadata());
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        ItemStack itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        if (!itemstack.isEmpty() && p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_.offset(p_onItemUse_5_), p_onItemUse_5_, itemstack)) {
            Comparable<?> comparable = this.singleSlab.getTypeForItem(itemstack);
            IBlockState iblockstate = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
            if (iblockstate.getBlock() == this.singleSlab) {
                IProperty<?> iproperty = this.singleSlab.getVariantProperty();
                Object comparable1 = iblockstate.getValue(iproperty);
                BlockSlab.EnumBlockHalf blockslab$enumblockhalf = iblockstate.getValue(BlockSlab.HALF);
                if ((p_onItemUse_5_ == EnumFacing.UP && blockslab$enumblockhalf == BlockSlab.EnumBlockHalf.BOTTOM || p_onItemUse_5_ == EnumFacing.DOWN && blockslab$enumblockhalf == BlockSlab.EnumBlockHalf.TOP) && comparable1 == comparable) {
                    IBlockState iblockstate1 = this.makeState(iproperty, (Comparable<?>)comparable1);
                    AxisAlignedBB axisalignedbb = iblockstate1.getCollisionBoundingBox(p_onItemUse_2_, p_onItemUse_3_);
                    if (axisalignedbb != Block.NULL_AABB && p_onItemUse_2_.checkNoEntityCollision(axisalignedbb.offset(p_onItemUse_3_)) && p_onItemUse_2_.setBlockState(p_onItemUse_3_, iblockstate1, 11)) {
                        SoundType soundtype = this.doubleSlab.getSoundType(iblockstate1, p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_1_);
                        p_onItemUse_2_.playSound(p_onItemUse_1_, p_onItemUse_3_, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                        itemstack.shrink(1);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
            return this.tryPlace(p_onItemUse_1_, itemstack, p_onItemUse_2_, p_onItemUse_3_.offset(p_onItemUse_5_), comparable) ? EnumActionResult.SUCCESS : super.onItemUse(p_onItemUse_1_, p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_4_, p_onItemUse_5_, p_onItemUse_6_, p_onItemUse_7_, p_onItemUse_8_);
        }
        return EnumActionResult.FAIL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canPlaceBlockOnSide(World p_canPlaceBlockOnSide_1_, BlockPos p_canPlaceBlockOnSide_2_, EnumFacing p_canPlaceBlockOnSide_3_, EntityPlayer p_canPlaceBlockOnSide_4_, ItemStack p_canPlaceBlockOnSide_5_) {
        IBlockState iblockstate1;
        BlockPos blockpos = p_canPlaceBlockOnSide_2_;
        IProperty<?> iproperty = this.singleSlab.getVariantProperty();
        Comparable<?> comparable = this.singleSlab.getTypeForItem(p_canPlaceBlockOnSide_5_);
        IBlockState iblockstate = p_canPlaceBlockOnSide_1_.getBlockState(p_canPlaceBlockOnSide_2_);
        if (iblockstate.getBlock() == this.singleSlab) {
            boolean flag;
            boolean bl = flag = iblockstate.getValue(BlockSlab.HALF) == BlockSlab.EnumBlockHalf.TOP;
            if ((p_canPlaceBlockOnSide_3_ == EnumFacing.UP && !flag || p_canPlaceBlockOnSide_3_ == EnumFacing.DOWN && flag) && comparable == iblockstate.getValue(iproperty)) {
                return true;
            }
        }
        return (iblockstate1 = p_canPlaceBlockOnSide_1_.getBlockState(p_canPlaceBlockOnSide_2_ = p_canPlaceBlockOnSide_2_.offset(p_canPlaceBlockOnSide_3_))).getBlock() == this.singleSlab && comparable == iblockstate1.getValue(iproperty) ? true : super.canPlaceBlockOnSide(p_canPlaceBlockOnSide_1_, blockpos, p_canPlaceBlockOnSide_3_, p_canPlaceBlockOnSide_4_, p_canPlaceBlockOnSide_5_);
    }

    private boolean tryPlace(EntityPlayer p_tryPlace_1_, ItemStack p_tryPlace_2_, World p_tryPlace_3_, BlockPos p_tryPlace_4_, Object p_tryPlace_5_) {
        Object comparable;
        IBlockState iblockstate = p_tryPlace_3_.getBlockState(p_tryPlace_4_);
        if (iblockstate.getBlock() == this.singleSlab && (comparable = iblockstate.getValue(this.singleSlab.getVariantProperty())) == p_tryPlace_5_) {
            IBlockState iblockstate1 = this.makeState(this.singleSlab.getVariantProperty(), (Comparable<?>)comparable);
            AxisAlignedBB axisalignedbb = iblockstate1.getCollisionBoundingBox(p_tryPlace_3_, p_tryPlace_4_);
            if (axisalignedbb != Block.NULL_AABB && p_tryPlace_3_.checkNoEntityCollision(axisalignedbb.offset(p_tryPlace_4_)) && p_tryPlace_3_.setBlockState(p_tryPlace_4_, iblockstate1, 11)) {
                SoundType soundtype = this.doubleSlab.getSoundType(iblockstate1, p_tryPlace_3_, p_tryPlace_4_, p_tryPlace_1_);
                p_tryPlace_3_.playSound(p_tryPlace_1_, p_tryPlace_4_, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                p_tryPlace_2_.shrink(1);
            }
            return true;
        }
        return false;
    }

    protected <T extends Comparable<T>> IBlockState makeState(IProperty<T> p_makeState_1_, Comparable<?> p_makeState_2_) {
        return this.doubleSlab.getDefaultState().withProperty(p_makeState_1_, p_makeState_2_);
    }
}

