/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemSnow
extends ItemBlock {
    public ItemSnow(Block p_i45781_1_) {
        super(p_i45781_1_);
        this.setMaxDamage(0);
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        ItemStack itemstack = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        if (!itemstack.isEmpty() && p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_, p_onItemUse_5_, itemstack)) {
            IBlockState iblockstate1;
            AxisAlignedBB axisalignedbb;
            int i;
            IBlockState iblockstate = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
            Block block = iblockstate.getBlock();
            BlockPos blockpos = p_onItemUse_3_;
            if (!(p_onItemUse_5_ == EnumFacing.UP && block == this.block || block.isReplaceable(p_onItemUse_2_, p_onItemUse_3_))) {
                blockpos = p_onItemUse_3_.offset(p_onItemUse_5_);
                iblockstate = p_onItemUse_2_.getBlockState(blockpos);
                block = iblockstate.getBlock();
            }
            if (block == this.block && (i = iblockstate.getValue(BlockSnow.LAYERS).intValue()) < 8 && (axisalignedbb = (iblockstate1 = iblockstate.withProperty(BlockSnow.LAYERS, i + 1)).getCollisionBoundingBox(p_onItemUse_2_, blockpos)) != Block.NULL_AABB && p_onItemUse_2_.checkNoEntityCollision(axisalignedbb.offset(blockpos)) && p_onItemUse_2_.setBlockState(blockpos, iblockstate1, 10)) {
                SoundType soundtype = this.block.getSoundType(iblockstate1, p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_1_);
                p_onItemUse_2_.playSound(p_onItemUse_1_, blockpos, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                itemstack.shrink(1);
                return EnumActionResult.SUCCESS;
            }
            return super.onItemUse(p_onItemUse_1_, p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_4_, p_onItemUse_5_, p_onItemUse_6_, p_onItemUse_7_, p_onItemUse_8_);
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public int getMetadata(int p_getMetadata_1_) {
        return p_getMetadata_1_;
    }

    @Override
    public boolean canPlaceBlockOnSide(World p_canPlaceBlockOnSide_1_, BlockPos p_canPlaceBlockOnSide_2_, EnumFacing p_canPlaceBlockOnSide_3_, EntityPlayer p_canPlaceBlockOnSide_4_, ItemStack p_canPlaceBlockOnSide_5_) {
        IBlockState state = p_canPlaceBlockOnSide_1_.getBlockState(p_canPlaceBlockOnSide_2_);
        return state.getBlock() != Blocks.SNOW_LAYER || state.getValue(BlockSnow.LAYERS) > 7 ? super.canPlaceBlockOnSide(p_canPlaceBlockOnSide_1_, p_canPlaceBlockOnSide_2_, p_canPlaceBlockOnSide_3_, p_canPlaceBlockOnSide_4_, p_canPlaceBlockOnSide_5_) : true;
    }
}

