/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemSpade
extends ItemTool {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.CLAY, Blocks.DIRT, Blocks.FARMLAND, Blocks.GRASS, Blocks.GRAVEL, Blocks.MYCELIUM, Blocks.SAND, Blocks.SNOW, Blocks.SNOW_LAYER, Blocks.SOUL_SAND, Blocks.GRASS_PATH});

    public ItemSpade(Item.ToolMaterial p_i45353_1_) {
        super(1.5f, -3.0f, p_i45353_1_, EFFECTIVE_ON);
    }

    @Override
    public boolean canHarvestBlock(IBlockState p_canHarvestBlock_1_) {
        Block lvt_2_1_ = p_canHarvestBlock_1_.getBlock();
        if (lvt_2_1_ == Blocks.SNOW_LAYER) {
            return true;
        }
        return lvt_2_1_ == Blocks.SNOW;
    }

    @Override
    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        ItemStack lvt_9_1_ = p_onItemUse_1_.getHeldItem(p_onItemUse_4_);
        if (!p_onItemUse_1_.canPlayerEdit(p_onItemUse_3_.offset(p_onItemUse_5_), p_onItemUse_5_, lvt_9_1_)) {
            return EnumActionResult.FAIL;
        }
        IBlockState lvt_10_1_ = p_onItemUse_2_.getBlockState(p_onItemUse_3_);
        Block lvt_11_1_ = lvt_10_1_.getBlock();
        if (p_onItemUse_5_ == EnumFacing.DOWN || p_onItemUse_2_.getBlockState(p_onItemUse_3_.up()).getMaterial() != Material.AIR || lvt_11_1_ != Blocks.GRASS) {
            return EnumActionResult.PASS;
        }
        IBlockState lvt_12_1_ = Blocks.GRASS_PATH.getDefaultState();
        p_onItemUse_2_.playSound(p_onItemUse_1_, p_onItemUse_3_, SoundEvents.ITEM_SHOVEL_FLATTEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!p_onItemUse_2_.isRemote) {
            p_onItemUse_2_.setBlockState(p_onItemUse_3_, lvt_12_1_, 11);
            lvt_9_1_.damageItem(1, p_onItemUse_1_);
        }
        return EnumActionResult.SUCCESS;
    }
}

