/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.BlockEntityTag;
import net.minecraft.util.datafix.walkers.EntityTag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemStack
implements ICapabilitySerializable<NBTTagCompound> {
    public static final ItemStack EMPTY = new ItemStack((Item)null);
    public static final DecimalFormat DECIMALFORMAT = new DecimalFormat("#.##");
    private int stackSize;
    private int animationsToGo;
    private final Item item;
    private NBTTagCompound stackTagCompound;
    private boolean isEmpty;
    int itemDamage;
    private EntityItemFrame itemFrame;
    private Block canDestroyCacheBlock;
    private boolean canDestroyCacheResult;
    private Block canPlaceOnCacheBlock;
    private boolean canPlaceOnCacheResult;
    private RegistryDelegate<Item> delegate;
    private CapabilityDispatcher capabilities;
    private NBTTagCompound capNBT;

    public ItemStack(Block p_i1876_1_) {
        this(p_i1876_1_, 1);
    }

    public ItemStack(Block p_i1877_1_, int p_i1877_2_) {
        this(p_i1877_1_, p_i1877_2_, 0);
    }

    public ItemStack(Block p_i1878_1_, int p_i1878_2_, int p_i1878_3_) {
        this(Item.getItemFromBlock(p_i1878_1_), p_i1878_2_, p_i1878_3_);
    }

    public ItemStack(Item p_i1879_1_) {
        this(p_i1879_1_, 1);
    }

    public ItemStack(Item p_i1880_1_, int p_i1880_2_) {
        this(p_i1880_1_, p_i1880_2_, 0);
    }

    public ItemStack(Item p_i1881_1_, int p_i1881_2_, int p_i1881_3_) {
        this(p_i1881_1_, p_i1881_2_, p_i1881_3_, null);
    }

    public ItemStack(Item p_i6_1_, int p_i6_2_, int p_i6_3_, NBTTagCompound p_i6_4_) {
        this.capNBT = p_i6_4_;
        this.item = p_i6_1_;
        this.itemDamage = p_i6_3_;
        this.stackSize = p_i6_2_;
        if (this.itemDamage < 0) {
            this.itemDamage = 0;
        }
        this.updateEmptyState();
        this.forgeInit();
    }

    private void updateEmptyState() {
        this.isEmpty = this.isEmpty();
    }

    public ItemStack(NBTTagCompound p_i47263_1_) {
        this.capNBT = p_i47263_1_.hasKey("ForgeCaps") ? p_i47263_1_.getCompoundTag("ForgeCaps") : null;
        this.item = Item.getByNameOrId(p_i47263_1_.getString("id"));
        this.stackSize = p_i47263_1_.getByte("Count");
        this.itemDamage = Math.max(0, p_i47263_1_.getShort("Damage"));
        if (p_i47263_1_.hasKey("tag", 10)) {
            this.stackTagCompound = p_i47263_1_.getCompoundTag("tag");
            if (this.item != null) {
                this.item.updateItemStackNBT(p_i47263_1_);
            }
        }
        this.updateEmptyState();
        this.forgeInit();
    }

    public boolean isEmpty() {
        return this == EMPTY ? true : (this.getItemRaw() != null && this.getItemRaw() != Item.getItemFromBlock(Blocks.AIR) ? (this.stackSize <= 0 ? true : this.itemDamage < Short.MIN_VALUE || this.itemDamage > 65535) : true);
    }

    public static void registerFixes(DataFixer p_registerFixes_0_) {
        p_registerFixes_0_.registerWalker(FixTypes.ITEM_INSTANCE, new BlockEntityTag());
        p_registerFixes_0_.registerWalker(FixTypes.ITEM_INSTANCE, new EntityTag());
    }

    public ItemStack splitStack(int p_splitStack_1_) {
        int i = Math.min(p_splitStack_1_, this.stackSize);
        ItemStack itemstack = this.copy();
        itemstack.setCount(i);
        this.shrink(i);
        return itemstack;
    }

    public Item getItem() {
        return this.isEmpty || this.delegate == null ? Item.getItemFromBlock(Blocks.AIR) : this.delegate.get();
    }

    public EnumActionResult onItemUse(EntityPlayer p_onItemUse_1_, World p_onItemUse_2_, BlockPos p_onItemUse_3_, EnumHand p_onItemUse_4_, EnumFacing p_onItemUse_5_, float p_onItemUse_6_, float p_onItemUse_7_, float p_onItemUse_8_) {
        if (!p_onItemUse_2_.isRemote) {
            return ForgeHooks.onPlaceItemIntoWorld(this, p_onItemUse_1_, p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_5_, p_onItemUse_6_, p_onItemUse_7_, p_onItemUse_8_, p_onItemUse_4_);
        }
        EnumActionResult enumactionresult = this.getItem().onItemUse(p_onItemUse_1_, p_onItemUse_2_, p_onItemUse_3_, p_onItemUse_4_, p_onItemUse_5_, p_onItemUse_6_, p_onItemUse_7_, p_onItemUse_8_);
        if (enumactionresult == EnumActionResult.SUCCESS) {
            p_onItemUse_1_.addStat(StatList.getObjectUseStats(this.item));
        }
        return enumactionresult;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer p_onItemUseFirst_1_, World p_onItemUseFirst_2_, BlockPos p_onItemUseFirst_3_, EnumHand p_onItemUseFirst_4_, EnumFacing p_onItemUseFirst_5_, float p_onItemUseFirst_6_, float p_onItemUseFirst_7_, float p_onItemUseFirst_8_) {
        EnumActionResult enumactionresult = this.getItem().onItemUseFirst(p_onItemUseFirst_1_, p_onItemUseFirst_2_, p_onItemUseFirst_3_, p_onItemUseFirst_5_, p_onItemUseFirst_6_, p_onItemUseFirst_7_, p_onItemUseFirst_8_, p_onItemUseFirst_4_);
        if (enumactionresult == EnumActionResult.SUCCESS) {
            p_onItemUseFirst_1_.addStat(StatList.getObjectUseStats(this.item));
        }
        return enumactionresult;
    }

    public float getStrVsBlock(IBlockState p_getStrVsBlock_1_) {
        return this.getItem().getStrVsBlock(this, p_getStrVsBlock_1_);
    }

    public ActionResult<ItemStack> useItemRightClick(World p_useItemRightClick_1_, EntityPlayer p_useItemRightClick_2_, EnumHand p_useItemRightClick_3_) {
        return this.getItem().onItemRightClick(p_useItemRightClick_1_, p_useItemRightClick_2_, p_useItemRightClick_3_);
    }

    public ItemStack onItemUseFinish(World p_onItemUseFinish_1_, EntityLivingBase p_onItemUseFinish_2_) {
        return this.getItem().onItemUseFinish(this, p_onItemUseFinish_1_, p_onItemUseFinish_2_);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        NBTTagCompound cnbt;
        ResourceLocation resourcelocation = Item.REGISTRY.getNameForObject(this.item);
        p_writeToNBT_1_.setString("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        p_writeToNBT_1_.setByte("Count", (byte)this.stackSize);
        p_writeToNBT_1_.setShort("Damage", (short)this.itemDamage);
        if (this.stackTagCompound != null) {
            p_writeToNBT_1_.setTag("tag", this.stackTagCompound);
        }
        if (this.capabilities != null && !(cnbt = this.capabilities.serializeNBT()).hasNoTags()) {
            p_writeToNBT_1_.setTag("ForgeCaps", cnbt);
        }
        return p_writeToNBT_1_;
    }

    public int getMaxStackSize() {
        return this.getItem().getItemStackLimit(this);
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isItemStackDamageable() || !this.isItemDamaged());
    }

    public boolean isItemStackDamageable() {
        return this.isEmpty ? false : (this.item.getMaxDamage(this) <= 0 ? false : !this.hasTagCompound() || !this.getTagCompound().getBoolean("Unbreakable"));
    }

    public boolean getHasSubtypes() {
        return this.getItem().getHasSubtypes();
    }

    public boolean isItemDamaged() {
        return this.isItemStackDamageable() && this.getItem().isDamaged(this);
    }

    public int getItemDamage() {
        return this.getItem().getDamage(this);
    }

    public int getMetadata() {
        return this.getItem().getMetadata(this);
    }

    public void setItemDamage(int p_setItemDamage_1_) {
        this.getItem().setDamage(this, p_setItemDamage_1_);
    }

    public int getMaxDamage() {
        return this.getItem().getMaxDamage(this);
    }

    public boolean attemptDamageItem(int p_attemptDamageItem_1_, Random p_attemptDamageItem_2_) {
        if (!this.isItemStackDamageable()) {
            return false;
        }
        if (p_attemptDamageItem_1_ > 0) {
            int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.UNBREAKING, this);
            int j = 0;
            for (int k = 0; i > 0 && k < p_attemptDamageItem_1_; ++k) {
                if (!EnchantmentDurability.negateDamage(this, i, p_attemptDamageItem_2_)) continue;
                ++j;
            }
            if ((p_attemptDamageItem_1_ -= j) <= 0) {
                return false;
            }
        }
        this.setItemDamage(this.getItemDamage() + p_attemptDamageItem_1_);
        return this.getItemDamage() > this.getMaxDamage();
    }

    public void damageItem(int p_damageItem_1_, EntityLivingBase p_damageItem_2_) {
        if ((!(p_damageItem_2_ instanceof EntityPlayer) || !((EntityPlayer)p_damageItem_2_).capabilities.isCreativeMode) && this.isItemStackDamageable() && this.attemptDamageItem(p_damageItem_1_, p_damageItem_2_.getRNG())) {
            p_damageItem_2_.renderBrokenItemStack(this);
            this.shrink(1);
            if (p_damageItem_2_ instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)p_damageItem_2_;
                entityplayer.addStat(StatList.getObjectBreakStats(this.item));
            }
            this.itemDamage = 0;
        }
    }

    public void hitEntity(EntityLivingBase p_hitEntity_1_, EntityPlayer p_hitEntity_2_) {
        boolean flag = this.item.hitEntity(this, p_hitEntity_1_, p_hitEntity_2_);
        if (flag) {
            p_hitEntity_2_.addStat(StatList.getObjectUseStats(this.item));
        }
    }

    public void onBlockDestroyed(World p_onBlockDestroyed_1_, IBlockState p_onBlockDestroyed_2_, BlockPos p_onBlockDestroyed_3_, EntityPlayer p_onBlockDestroyed_4_) {
        boolean flag = this.getItem().onBlockDestroyed(this, p_onBlockDestroyed_1_, p_onBlockDestroyed_2_, p_onBlockDestroyed_3_, p_onBlockDestroyed_4_);
        if (flag) {
            p_onBlockDestroyed_4_.addStat(StatList.getObjectUseStats(this.item));
        }
    }

    public boolean canHarvestBlock(IBlockState p_canHarvestBlock_1_) {
        return this.getItem().canHarvestBlock(p_canHarvestBlock_1_, this);
    }

    public boolean interactWithEntity(EntityPlayer p_interactWithEntity_1_, EntityLivingBase p_interactWithEntity_2_, EnumHand p_interactWithEntity_3_) {
        return this.getItem().itemInteractionForEntity(this, p_interactWithEntity_1_, p_interactWithEntity_2_, p_interactWithEntity_3_);
    }

    public ItemStack copy() {
        ItemStack itemstack = new ItemStack(this.item, this.stackSize, this.itemDamage, this.capabilities != null ? this.capabilities.serializeNBT() : null);
        if (this.stackTagCompound != null) {
            itemstack.stackTagCompound = this.stackTagCompound.copy();
        }
        return itemstack;
    }

    public static boolean areItemStackTagsEqual(ItemStack p_areItemStackTagsEqual_0_, ItemStack p_areItemStackTagsEqual_1_) {
        return p_areItemStackTagsEqual_0_.isEmpty() && p_areItemStackTagsEqual_1_.isEmpty() ? true : (!p_areItemStackTagsEqual_0_.isEmpty() && !p_areItemStackTagsEqual_1_.isEmpty() ? (p_areItemStackTagsEqual_0_.stackTagCompound == null && p_areItemStackTagsEqual_1_.stackTagCompound != null ? false : (p_areItemStackTagsEqual_0_.stackTagCompound == null || p_areItemStackTagsEqual_0_.stackTagCompound.equals(p_areItemStackTagsEqual_1_.stackTagCompound)) && p_areItemStackTagsEqual_0_.areCapsCompatible(p_areItemStackTagsEqual_1_)) : false);
    }

    public static boolean areItemStacksEqual(ItemStack p_areItemStacksEqual_0_, ItemStack p_areItemStacksEqual_1_) {
        return p_areItemStacksEqual_0_.isEmpty() && p_areItemStacksEqual_1_.isEmpty() ? true : (!p_areItemStacksEqual_0_.isEmpty() && !p_areItemStacksEqual_1_.isEmpty() ? p_areItemStacksEqual_0_.isItemStackEqual(p_areItemStacksEqual_1_) : false);
    }

    private boolean isItemStackEqual(ItemStack p_isItemStackEqual_1_) {
        return this.stackSize != p_isItemStackEqual_1_.stackSize ? false : (this.getItem() != p_isItemStackEqual_1_.getItem() ? false : (this.itemDamage != p_isItemStackEqual_1_.itemDamage ? false : (this.stackTagCompound == null && p_isItemStackEqual_1_.stackTagCompound != null ? false : (this.stackTagCompound == null || this.stackTagCompound.equals(p_isItemStackEqual_1_.stackTagCompound)) && this.areCapsCompatible(p_isItemStackEqual_1_))));
    }

    public static boolean areItemsEqual(ItemStack p_areItemsEqual_0_, ItemStack p_areItemsEqual_1_) {
        return p_areItemsEqual_0_ == p_areItemsEqual_1_ ? true : (!p_areItemsEqual_0_.isEmpty() && !p_areItemsEqual_1_.isEmpty() ? p_areItemsEqual_0_.isItemEqual(p_areItemsEqual_1_) : false);
    }

    public static boolean areItemsEqualIgnoreDurability(ItemStack p_areItemsEqualIgnoreDurability_0_, ItemStack p_areItemsEqualIgnoreDurability_1_) {
        return p_areItemsEqualIgnoreDurability_0_ == p_areItemsEqualIgnoreDurability_1_ ? true : (!p_areItemsEqualIgnoreDurability_0_.isEmpty() && !p_areItemsEqualIgnoreDurability_1_.isEmpty() ? p_areItemsEqualIgnoreDurability_0_.isItemEqualIgnoreDurability(p_areItemsEqualIgnoreDurability_1_) : false);
    }

    public boolean isItemEqual(ItemStack p_isItemEqual_1_) {
        return !p_isItemEqual_1_.isEmpty() && this.item == p_isItemEqual_1_.item && this.itemDamage == p_isItemEqual_1_.itemDamage;
    }

    public boolean isItemEqualIgnoreDurability(ItemStack p_isItemEqualIgnoreDurability_1_) {
        return !this.isItemStackDamageable() ? this.isItemEqual(p_isItemEqualIgnoreDurability_1_) : !p_isItemEqualIgnoreDurability_1_.isEmpty() && this.item == p_isItemEqualIgnoreDurability_1_.item;
    }

    public String getUnlocalizedName() {
        return this.getItem().getUnlocalizedName(this);
    }

    public String toString() {
        return this.stackSize + "x" + this.getItem().getUnlocalizedName() + "@" + this.itemDamage;
    }

    public void updateAnimation(World p_updateAnimation_1_, Entity p_updateAnimation_2_, int p_updateAnimation_3_, boolean p_updateAnimation_4_) {
        if (this.animationsToGo > 0) {
            --this.animationsToGo;
        }
        if (this.item != null) {
            this.item.onUpdate(this, p_updateAnimation_1_, p_updateAnimation_2_, p_updateAnimation_3_, p_updateAnimation_4_);
        }
    }

    public void onCrafting(World p_onCrafting_1_, EntityPlayer p_onCrafting_2_, int p_onCrafting_3_) {
        p_onCrafting_2_.addStat(StatList.getCraftStats(this.item), p_onCrafting_3_);
        this.getItem().onCreated(this, p_onCrafting_1_, p_onCrafting_2_);
    }

    public int getMaxItemUseDuration() {
        return this.getItem().getMaxItemUseDuration(this);
    }

    public EnumAction getItemUseAction() {
        return this.getItem().getItemUseAction(this);
    }

    public void onPlayerStoppedUsing(World p_onPlayerStoppedUsing_1_, EntityLivingBase p_onPlayerStoppedUsing_2_, int p_onPlayerStoppedUsing_3_) {
        this.getItem().onPlayerStoppedUsing(this, p_onPlayerStoppedUsing_1_, p_onPlayerStoppedUsing_2_, p_onPlayerStoppedUsing_3_);
    }

    public boolean hasTagCompound() {
        return !this.isEmpty && this.stackTagCompound != null;
    }

    @Nullable
    public NBTTagCompound getTagCompound() {
        return this.stackTagCompound;
    }

    public NBTTagCompound getOrCreateSubCompound(String p_getOrCreateSubCompound_1_) {
        if (this.stackTagCompound != null && this.stackTagCompound.hasKey(p_getOrCreateSubCompound_1_, 10)) {
            return this.stackTagCompound.getCompoundTag(p_getOrCreateSubCompound_1_);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.setTagInfo(p_getOrCreateSubCompound_1_, nbttagcompound);
        return nbttagcompound;
    }

    @Nullable
    public NBTTagCompound getSubCompound(String p_getSubCompound_1_) {
        return this.stackTagCompound != null && this.stackTagCompound.hasKey(p_getSubCompound_1_, 10) ? this.stackTagCompound.getCompoundTag(p_getSubCompound_1_) : null;
    }

    public void removeSubCompound(String p_removeSubCompound_1_) {
        if (this.stackTagCompound != null && this.stackTagCompound.hasKey(p_removeSubCompound_1_, 10)) {
            this.stackTagCompound.removeTag(p_removeSubCompound_1_);
        }
    }

    @Nullable
    public NBTTagList getEnchantmentTagList() {
        return this.stackTagCompound == null ? null : this.stackTagCompound.getTagList("ench", 10);
    }

    public void setTagCompound(NBTTagCompound p_setTagCompound_1_) {
        this.stackTagCompound = p_setTagCompound_1_;
    }

    public String getDisplayName() {
        NBTTagCompound nbttagcompound = this.getSubCompound("display");
        if (nbttagcompound != null) {
            if (nbttagcompound.hasKey("Name", 8)) {
                return nbttagcompound.getString("Name");
            }
            if (nbttagcompound.hasKey("LocName", 8)) {
                return I18n.translateToLocal(nbttagcompound.getString("LocName"));
            }
        }
        return this.getItem().getItemStackDisplayName(this);
    }

    public ItemStack setTranslatableName(String p_setTranslatableName_1_) {
        this.getOrCreateSubCompound("display").setString("LocName", p_setTranslatableName_1_);
        return this;
    }

    public ItemStack setStackDisplayName(String p_setStackDisplayName_1_) {
        this.getOrCreateSubCompound("display").setString("Name", p_setStackDisplayName_1_);
        return this;
    }

    public void clearCustomName() {
        NBTTagCompound nbttagcompound = this.getSubCompound("display");
        if (nbttagcompound != null) {
            nbttagcompound.removeTag("Name");
            if (nbttagcompound.hasNoTags()) {
                this.removeSubCompound("display");
            }
        }
        if (this.stackTagCompound != null && this.stackTagCompound.hasNoTags()) {
            this.stackTagCompound = null;
        }
    }

    public boolean hasDisplayName() {
        NBTTagCompound nbttagcompound = this.getSubCompound("display");
        return nbttagcompound != null && nbttagcompound.hasKey("Name", 8);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltip(EntityPlayer p_getTooltip_1_, boolean p_getTooltip_2_) {
        NBTTagList nbttaglist2;
        NBTTagList nbttaglist1;
        ArrayList list = Lists.newArrayList();
        String s = this.getDisplayName();
        if (this.hasDisplayName()) {
            s = (Object)((Object)TextFormatting.ITALIC) + s;
        }
        s = s + (Object)((Object)TextFormatting.RESET);
        if (p_getTooltip_2_) {
            String s1 = "";
            if (!s.isEmpty()) {
                s = s + " (";
                s1 = ")";
            }
            int i = Item.getIdFromItem(this.item);
            s = this.getHasSubtypes() ? s + String.format("#%04d/%d%s", i, this.itemDamage, s1) : s + String.format("#%04d%s", i, s1);
        } else if (!this.hasDisplayName() && this.item == Items.FILLED_MAP) {
            s = s + " #" + this.itemDamage;
        }
        list.add(s);
        int i1 = 0;
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("HideFlags", 99)) {
            i1 = this.stackTagCompound.getInteger("HideFlags");
        }
        if ((i1 & 0x20) == 0) {
            this.getItem().addInformation(this, p_getTooltip_1_, list, p_getTooltip_2_);
        }
        if (this.hasTagCompound()) {
            NBTTagList nbttaglist;
            if ((i1 & 1) == 0 && (nbttaglist = this.getEnchantmentTagList()) != null && !nbttaglist.hasNoTags()) {
                for (int j = 0; j < nbttaglist.tagCount(); ++j) {
                    short k = nbttaglist.getCompoundTagAt(j).getShort("id");
                    short l = nbttaglist.getCompoundTagAt(j).getShort("lvl");
                    if (Enchantment.getEnchantmentByID(k) == null) continue;
                    list.add(Enchantment.getEnchantmentByID(k).getTranslatedName(l));
                }
            }
            if (this.stackTagCompound.hasKey("display", 10)) {
                NBTTagList nbttaglist3;
                NBTTagCompound nbttagcompound = this.stackTagCompound.getCompoundTag("display");
                if (nbttagcompound.hasKey("color", 3)) {
                    if (p_getTooltip_2_) {
                        list.add(I18n.translateToLocalFormatted("item.color", String.format("#%06X", nbttagcompound.getInteger("color"))));
                    } else {
                        list.add((Object)((Object)TextFormatting.ITALIC) + I18n.translateToLocal("item.dyed"));
                    }
                }
                if (nbttagcompound.getTagId("Lore") == 9 && !(nbttaglist3 = nbttagcompound.getTagList("Lore", 8)).hasNoTags()) {
                    for (int l1 = 0; l1 < nbttaglist3.tagCount(); ++l1) {
                        list.add((Object)((Object)TextFormatting.DARK_PURPLE) + "" + (Object)((Object)TextFormatting.ITALIC) + nbttaglist3.getStringTagAt(l1));
                    }
                }
            }
        }
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            Multimap<String, AttributeModifier> multimap = this.getAttributeModifiers(entityequipmentslot);
            if (multimap.isEmpty() || (i1 & 2) != 0) continue;
            list.add("");
            list.add(I18n.translateToLocal("item.modifiers." + entityequipmentslot.getName()));
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                double d0 = attributemodifier.getAmount();
                boolean flag = false;
                if (attributemodifier.getID() == Item.ATTACK_DAMAGE_MODIFIER) {
                    d0 += p_getTooltip_1_.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getBaseValue();
                    d0 += (double)EnchantmentHelper.getModifierForCreature(this, EnumCreatureAttribute.UNDEFINED);
                    flag = true;
                } else if (attributemodifier.getID() == Item.ATTACK_SPEED_MODIFIER) {
                    d0 += p_getTooltip_1_.getEntityAttribute(SharedMonsterAttributes.ATTACK_SPEED).getBaseValue();
                    flag = true;
                }
                double d1 = attributemodifier.getOperation() != 1 && attributemodifier.getOperation() != 2 ? d0 : d0 * 100.0;
                if (flag) {
                    list.add(" " + I18n.translateToLocalFormatted("attribute.modifier.equals." + attributemodifier.getOperation(), DECIMALFORMAT.format(d1), I18n.translateToLocal("attribute.name." + (String)entry.getKey())));
                    continue;
                }
                if (d0 > 0.0) {
                    list.add((Object)((Object)TextFormatting.BLUE) + " " + I18n.translateToLocalFormatted("attribute.modifier.plus." + attributemodifier.getOperation(), DECIMALFORMAT.format(d1), I18n.translateToLocal("attribute.name." + (String)entry.getKey())));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                list.add((Object)((Object)TextFormatting.RED) + " " + I18n.translateToLocalFormatted("attribute.modifier.take." + attributemodifier.getOperation(), DECIMALFORMAT.format(d1 *= -1.0), I18n.translateToLocal("attribute.name." + (String)entry.getKey())));
            }
        }
        if (this.hasTagCompound() && this.getTagCompound().getBoolean("Unbreakable") && (i1 & 4) == 0) {
            list.add((Object)((Object)TextFormatting.BLUE) + I18n.translateToLocal("item.unbreakable"));
        }
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("CanDestroy", 9) && (i1 & 8) == 0 && !(nbttaglist1 = this.stackTagCompound.getTagList("CanDestroy", 8)).hasNoTags()) {
            list.add("");
            list.add((Object)((Object)TextFormatting.GRAY) + I18n.translateToLocal("item.canBreak"));
            for (int j1 = 0; j1 < nbttaglist1.tagCount(); ++j1) {
                Block block = Block.getBlockFromName(nbttaglist1.getStringTagAt(j1));
                if (block != null) {
                    list.add((Object)((Object)TextFormatting.DARK_GRAY) + block.getLocalizedName());
                    continue;
                }
                list.add((Object)((Object)TextFormatting.DARK_GRAY) + "missingno");
            }
        }
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("CanPlaceOn", 9) && (i1 & 0x10) == 0 && !(nbttaglist2 = this.stackTagCompound.getTagList("CanPlaceOn", 8)).hasNoTags()) {
            list.add("");
            list.add((Object)((Object)TextFormatting.GRAY) + I18n.translateToLocal("item.canPlace"));
            for (int k1 = 0; k1 < nbttaglist2.tagCount(); ++k1) {
                Block block1 = Block.getBlockFromName(nbttaglist2.getStringTagAt(k1));
                if (block1 != null) {
                    list.add((Object)((Object)TextFormatting.DARK_GRAY) + block1.getLocalizedName());
                    continue;
                }
                list.add((Object)((Object)TextFormatting.DARK_GRAY) + "missingno");
            }
        }
        if (p_getTooltip_2_) {
            if (this.isItemDamaged()) {
                list.add(I18n.translateToLocalFormatted("item.durability", this.getMaxDamage() - this.getItemDamage(), this.getMaxDamage()));
            }
            list.add((Object)((Object)TextFormatting.DARK_GRAY) + Item.REGISTRY.getNameForObject(this.item).toString());
            if (this.hasTagCompound()) {
                list.add((Object)((Object)TextFormatting.DARK_GRAY) + I18n.translateToLocalFormatted("item.nbt_tags", this.getTagCompound().getKeySet().size()));
            }
        }
        ForgeEventFactory.onItemTooltip(this, p_getTooltip_1_, list, p_getTooltip_2_);
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect() {
        return this.getItem().hasEffect(this);
    }

    public EnumRarity getRarity() {
        return this.getItem().getRarity(this);
    }

    public boolean isItemEnchantable() {
        return !this.getItem().isEnchantable(this) ? false : !this.isItemEnchanted();
    }

    public void addEnchantment(Enchantment p_addEnchantment_1_, int p_addEnchantment_2_) {
        if (this.stackTagCompound == null) {
            this.setTagCompound(new NBTTagCompound());
        }
        if (!this.stackTagCompound.hasKey("ench", 9)) {
            this.stackTagCompound.setTag("ench", new NBTTagList());
        }
        NBTTagList nbttaglist = this.stackTagCompound.getTagList("ench", 10);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setShort("id", (short)Enchantment.getEnchantmentID(p_addEnchantment_1_));
        nbttagcompound.setShort("lvl", (byte)p_addEnchantment_2_);
        nbttaglist.appendTag(nbttagcompound);
    }

    public boolean isItemEnchanted() {
        return this.stackTagCompound != null && this.stackTagCompound.hasKey("ench", 9) ? !this.stackTagCompound.getTagList("ench", 10).hasNoTags() : false;
    }

    public void setTagInfo(String p_setTagInfo_1_, NBTBase p_setTagInfo_2_) {
        if (this.stackTagCompound == null) {
            this.setTagCompound(new NBTTagCompound());
        }
        this.stackTagCompound.setTag(p_setTagInfo_1_, p_setTagInfo_2_);
    }

    public boolean canEditBlocks() {
        return this.getItem().canItemEditBlocks();
    }

    public boolean isOnItemFrame() {
        return this.itemFrame != null;
    }

    public void setItemFrame(EntityItemFrame p_setItemFrame_1_) {
        this.itemFrame = p_setItemFrame_1_;
    }

    @Nullable
    public EntityItemFrame getItemFrame() {
        return this.isEmpty ? null : this.itemFrame;
    }

    public int getRepairCost() {
        return this.hasTagCompound() && this.stackTagCompound.hasKey("RepairCost", 3) ? this.stackTagCompound.getInteger("RepairCost") : 0;
    }

    public void setRepairCost(int p_setRepairCost_1_) {
        if (!this.hasTagCompound()) {
            this.stackTagCompound = new NBTTagCompound();
        }
        this.stackTagCompound.setInteger("RepairCost", p_setRepairCost_1_);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot p_getAttributeModifiers_1_) {
        HashMultimap multimap;
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("AttributeModifiers", 9)) {
            multimap = HashMultimap.create();
            NBTTagList nbttaglist = this.stackTagCompound.getTagList("AttributeModifiers", 10);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
                AttributeModifier attributemodifier = SharedMonsterAttributes.readAttributeModifierFromNBT(nbttagcompound);
                if (attributemodifier == null || nbttagcompound.hasKey("Slot", 8) && !nbttagcompound.getString("Slot").equals(p_getAttributeModifiers_1_.getName()) || attributemodifier.getID().getLeastSignificantBits() == 0L || attributemodifier.getID().getMostSignificantBits() == 0L) continue;
                multimap.put((Object)nbttagcompound.getString("AttributeName"), (Object)attributemodifier);
            }
        } else {
            multimap = this.getItem().getAttributeModifiers(p_getAttributeModifiers_1_, this);
        }
        return multimap;
    }

    public void addAttributeModifier(String p_addAttributeModifier_1_, AttributeModifier p_addAttributeModifier_2_, EntityEquipmentSlot p_addAttributeModifier_3_) {
        if (this.stackTagCompound == null) {
            this.stackTagCompound = new NBTTagCompound();
        }
        if (!this.stackTagCompound.hasKey("AttributeModifiers", 9)) {
            this.stackTagCompound.setTag("AttributeModifiers", new NBTTagList());
        }
        NBTTagList nbttaglist = this.stackTagCompound.getTagList("AttributeModifiers", 10);
        NBTTagCompound nbttagcompound = SharedMonsterAttributes.writeAttributeModifierToNBT(p_addAttributeModifier_2_);
        nbttagcompound.setString("AttributeName", p_addAttributeModifier_1_);
        if (p_addAttributeModifier_3_ != null) {
            nbttagcompound.setString("Slot", p_addAttributeModifier_3_.getName());
        }
        nbttaglist.appendTag(nbttagcompound);
    }

    public ITextComponent getTextComponent() {
        TextComponentString textcomponentstring = new TextComponentString(this.getDisplayName());
        if (this.hasDisplayName()) {
            textcomponentstring.getStyle().setItalic(true);
        }
        ITextComponent itextcomponent = new TextComponentString("[").appendSibling(textcomponentstring).appendText("]");
        if (!this.isEmpty) {
            NBTTagCompound nbttagcompound = this.writeToNBT(new NBTTagCompound());
            itextcomponent.getStyle().setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, new TextComponentString(nbttagcompound.toString())));
            itextcomponent.getStyle().setColor(this.getRarity().rarityColor);
        }
        return itextcomponent;
    }

    public boolean canDestroy(Block p_canDestroy_1_) {
        if (p_canDestroy_1_ == this.canDestroyCacheBlock) {
            return this.canDestroyCacheResult;
        }
        this.canDestroyCacheBlock = p_canDestroy_1_;
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("CanDestroy", 9)) {
            NBTTagList nbttaglist = this.stackTagCompound.getTagList("CanDestroy", 8);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                Block block = Block.getBlockFromName(nbttaglist.getStringTagAt(i));
                if (block != p_canDestroy_1_) continue;
                this.canDestroyCacheResult = true;
                return true;
            }
        }
        this.canDestroyCacheResult = false;
        return false;
    }

    public boolean canPlaceOn(Block p_canPlaceOn_1_) {
        if (p_canPlaceOn_1_ == this.canPlaceOnCacheBlock) {
            return this.canPlaceOnCacheResult;
        }
        this.canPlaceOnCacheBlock = p_canPlaceOn_1_;
        if (this.hasTagCompound() && this.stackTagCompound.hasKey("CanPlaceOn", 9)) {
            NBTTagList nbttaglist = this.stackTagCompound.getTagList("CanPlaceOn", 8);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                Block block = Block.getBlockFromName(nbttaglist.getStringTagAt(i));
                if (block != p_canPlaceOn_1_) continue;
                this.canPlaceOnCacheResult = true;
                return true;
            }
        }
        this.canPlaceOnCacheResult = false;
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> p_hasCapability_1_, EnumFacing p_hasCapability_2_) {
        return this.isEmpty || this.capabilities == null ? false : this.capabilities.hasCapability(p_hasCapability_1_, p_hasCapability_2_);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> p_getCapability_1_, EnumFacing p_getCapability_2_) {
        return this.isEmpty || this.capabilities == null ? null : (T)this.capabilities.getCapability(p_getCapability_1_, p_getCapability_2_);
    }

    @Override
    public void deserializeNBT(NBTTagCompound p_deserializeNBT_1_) {
        ItemStack itemStack = new ItemStack(p_deserializeNBT_1_);
        this.stackTagCompound = itemStack.stackTagCompound;
        this.capNBT = itemStack.capNBT;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        this.writeToNBT(ret);
        return ret;
    }

    public boolean areCapsCompatible(ItemStack p_areCapsCompatible_1_) {
        if (this.capabilities == null) {
            if (p_areCapsCompatible_1_.capabilities == null) {
                return true;
            }
            return p_areCapsCompatible_1_.capabilities.areCompatible(null);
        }
        return this.capabilities.areCompatible(p_areCapsCompatible_1_.capabilities);
    }

    @SideOnly(value=Side.CLIENT)
    public int getAnimationsToGo() {
        return this.animationsToGo;
    }

    public void setAnimationsToGo(int p_setAnimationsToGo_1_) {
        this.animationsToGo = p_setAnimationsToGo_1_;
    }

    public int getCount() {
        return this.isEmpty ? 0 : this.stackSize;
    }

    public void setCount(int p_setCount_1_) {
        this.stackSize = p_setCount_1_;
        this.updateEmptyState();
    }

    public void grow(int p_grow_1_) {
        this.setCount(this.stackSize + p_grow_1_);
    }

    public void shrink(int p_shrink_1_) {
        this.grow(-p_shrink_1_);
    }

    private void forgeInit() {
        Item item = this.getItemRaw();
        if (item != null) {
            this.delegate = item.delegate;
            ICapabilityProvider provider = item.initCapabilities(this, this.capNBT);
            this.capabilities = ForgeEventFactory.gatherCapabilities(item, this, provider);
            if (this.capNBT != null && this.capabilities != null) {
                this.capabilities.deserializeNBT(this.capNBT);
            }
        }
    }

    private Item getItemRaw() {
        return this.item;
    }
}

