/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Multimap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemSword
extends Item {
    private final float attackDamage;
    private final Item.ToolMaterial material;

    public ItemSword(Item.ToolMaterial p_i45356_1_) {
        this.material = p_i45356_1_;
        this.maxStackSize = 1;
        this.setMaxDamage(p_i45356_1_.getMaxUses());
        this.setCreativeTab(CreativeTabs.COMBAT);
        this.attackDamage = 3.0f + p_i45356_1_.getDamageVsEntity();
    }

    public float getDamageVsEntity() {
        return this.material.getDamageVsEntity();
    }

    @Override
    public float getStrVsBlock(ItemStack p_getStrVsBlock_1_, IBlockState p_getStrVsBlock_2_) {
        Block block = p_getStrVsBlock_2_.getBlock();
        if (block == Blocks.WEB) {
            return 15.0f;
        }
        Material material = p_getStrVsBlock_2_.getMaterial();
        return material != Material.PLANTS && material != Material.VINE && material != Material.CORAL && material != Material.LEAVES && material != Material.GOURD ? 1.0f : 1.5f;
    }

    @Override
    public boolean hitEntity(ItemStack p_hitEntity_1_, EntityLivingBase p_hitEntity_2_, EntityLivingBase p_hitEntity_3_) {
        p_hitEntity_1_.damageItem(1, p_hitEntity_3_);
        return true;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack p_onBlockDestroyed_1_, World p_onBlockDestroyed_2_, IBlockState p_onBlockDestroyed_3_, BlockPos p_onBlockDestroyed_4_, EntityLivingBase p_onBlockDestroyed_5_) {
        if ((double)p_onBlockDestroyed_3_.getBlockHardness(p_onBlockDestroyed_2_, p_onBlockDestroyed_4_) != 0.0) {
            p_onBlockDestroyed_1_.damageItem(2, p_onBlockDestroyed_5_);
        }
        return true;
    }

    @Override
    public boolean canHarvestBlock(IBlockState p_canHarvestBlock_1_) {
        return p_canHarvestBlock_1_.getBlock() == Blocks.WEB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isFull3D() {
        return true;
    }

    @Override
    public int getItemEnchantability() {
        return this.material.getEnchantability();
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    @Override
    public boolean getIsRepairable(ItemStack p_getIsRepairable_1_, ItemStack p_getIsRepairable_2_) {
        ItemStack mat = this.material.getRepairItemStack();
        if (!mat.isEmpty() && OreDictionary.itemMatches(mat, p_getIsRepairable_2_, false)) {
            return true;
        }
        return super.getIsRepairable(p_getIsRepairable_1_, p_getIsRepairable_2_);
    }

    @Override
    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot p_getItemAttributeModifiers_1_) {
        Multimap<String, AttributeModifier> multimap = super.getItemAttributeModifiers(p_getItemAttributeModifiers_1_);
        if (p_getItemAttributeModifiers_1_ == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getName(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.ATTACK_SPEED.getName(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Weapon modifier", -2.4f, 0));
        }
        return multimap;
    }
}

