/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTippedArrow
extends ItemArrow {
    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getDefaultInstance() {
        return PotionUtils.addPotionToItemStack(super.getDefaultInstance(), PotionTypes.POISON);
    }

    @Override
    public EntityArrow createArrow(World p_createArrow_1_, ItemStack p_createArrow_2_, EntityLivingBase p_createArrow_3_) {
        EntityTippedArrow lvt_4_1_ = new EntityTippedArrow(p_createArrow_1_, p_createArrow_3_);
        lvt_4_1_.setPotionEffect(p_createArrow_2_);
        return lvt_4_1_;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item p_getSubItems_1_, CreativeTabs p_getSubItems_2_, NonNullList<ItemStack> p_getSubItems_3_) {
        for (PotionType lvt_5_1_ : PotionType.REGISTRY) {
            if (lvt_5_1_.getEffects().isEmpty()) continue;
            p_getSubItems_3_.add(PotionUtils.addPotionToItemStack(new ItemStack(p_getSubItems_1_), lvt_5_1_));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack p_addInformation_1_, EntityPlayer p_addInformation_2_, List<String> p_addInformation_3_, boolean p_addInformation_4_) {
        PotionUtils.addPotionTooltip(p_addInformation_1_, p_addInformation_3_, 0.125f);
    }

    @Override
    public String getItemStackDisplayName(ItemStack p_getItemStackDisplayName_1_) {
        return I18n.translateToLocal(PotionUtils.getPotionFromItem(p_getItemStackDisplayName_1_).getNamePrefixed("tipped_arrow.effect."));
    }
}

