/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemTool
extends Item {
    private final Set<Block> effectiveBlocks;
    protected float efficiencyOnProperMaterial = 4.0f;
    protected float damageVsEntity;
    protected float attackSpeed;
    protected Item.ToolMaterial toolMaterial;
    @Nullable
    private String toolClass;

    protected ItemTool(float p_i46745_1_, float p_i46745_2_, Item.ToolMaterial p_i46745_3_, Set<Block> p_i46745_4_) {
        this.toolMaterial = p_i46745_3_;
        this.effectiveBlocks = p_i46745_4_;
        this.maxStackSize = 1;
        this.setMaxDamage(p_i46745_3_.getMaxUses());
        this.efficiencyOnProperMaterial = p_i46745_3_.getEfficiencyOnProperMaterial();
        this.damageVsEntity = p_i46745_1_ + p_i46745_3_.getDamageVsEntity();
        this.attackSpeed = p_i46745_2_;
        this.setCreativeTab(CreativeTabs.TOOLS);
        if (this instanceof ItemPickaxe) {
            this.toolClass = "pickaxe";
        } else if (this instanceof ItemAxe) {
            this.toolClass = "axe";
        } else if (this instanceof ItemSpade) {
            this.toolClass = "shovel";
        }
    }

    protected ItemTool(Item.ToolMaterial p_i46746_1_, Set<Block> p_i46746_2_) {
        this(0.0f, 0.0f, p_i46746_1_, p_i46746_2_);
    }

    @Override
    public float getStrVsBlock(ItemStack p_getStrVsBlock_1_, IBlockState p_getStrVsBlock_2_) {
        for (String type : this.getToolClasses(p_getStrVsBlock_1_)) {
            if (!p_getStrVsBlock_2_.getBlock().isToolEffective(type, p_getStrVsBlock_2_)) continue;
            return this.efficiencyOnProperMaterial;
        }
        return this.effectiveBlocks.contains(p_getStrVsBlock_2_.getBlock()) ? this.efficiencyOnProperMaterial : 1.0f;
    }

    @Override
    public boolean hitEntity(ItemStack p_hitEntity_1_, EntityLivingBase p_hitEntity_2_, EntityLivingBase p_hitEntity_3_) {
        p_hitEntity_1_.damageItem(2, p_hitEntity_3_);
        return true;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack p_onBlockDestroyed_1_, World p_onBlockDestroyed_2_, IBlockState p_onBlockDestroyed_3_, BlockPos p_onBlockDestroyed_4_, EntityLivingBase p_onBlockDestroyed_5_) {
        if (!p_onBlockDestroyed_2_.isRemote && (double)p_onBlockDestroyed_3_.getBlockHardness(p_onBlockDestroyed_2_, p_onBlockDestroyed_4_) != 0.0) {
            p_onBlockDestroyed_1_.damageItem(1, p_onBlockDestroyed_5_);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isFull3D() {
        return true;
    }

    public Item.ToolMaterial getToolMaterial() {
        return this.toolMaterial;
    }

    @Override
    public int getItemEnchantability() {
        return this.toolMaterial.getEnchantability();
    }

    public String getToolMaterialName() {
        return this.toolMaterial.toString();
    }

    @Override
    public boolean getIsRepairable(ItemStack p_getIsRepairable_1_, ItemStack p_getIsRepairable_2_) {
        ItemStack mat = this.toolMaterial.getRepairItemStack();
        if (!mat.isEmpty() && OreDictionary.itemMatches(mat, p_getIsRepairable_2_, false)) {
            return true;
        }
        return super.getIsRepairable(p_getIsRepairable_1_, p_getIsRepairable_2_);
    }

    @Override
    public Multimap<String, AttributeModifier> getItemAttributeModifiers(EntityEquipmentSlot p_getItemAttributeModifiers_1_) {
        Multimap<String, AttributeModifier> multimap = super.getItemAttributeModifiers(p_getItemAttributeModifiers_1_);
        if (p_getItemAttributeModifiers_1_ == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getName(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Tool modifier", this.damageVsEntity, 0));
            multimap.put((Object)SharedMonsterAttributes.ATTACK_SPEED.getName(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Tool modifier", this.attackSpeed, 0));
        }
        return multimap;
    }

    @Override
    public int getHarvestLevel(ItemStack p_getHarvestLevel_1_, String p_getHarvestLevel_2_, EntityPlayer p_getHarvestLevel_3_, IBlockState p_getHarvestLevel_4_) {
        int level = super.getHarvestLevel(p_getHarvestLevel_1_, p_getHarvestLevel_2_, p_getHarvestLevel_3_, p_getHarvestLevel_4_);
        if (level == -1 && p_getHarvestLevel_2_.equals(this.toolClass)) {
            return this.toolMaterial.getHarvestLevel();
        }
        return level;
    }

    @Override
    public Set<String> getToolClasses(ItemStack p_getToolClasses_1_) {
        return this.toolClass != null ? ImmutableSet.of((Object)this.toolClass) : super.getToolClasses(p_getToolClasses_1_);
    }
}

