/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWrittenBook
extends Item {
    public ItemWrittenBook() {
        this.setMaxStackSize(1);
    }

    public static boolean validBookTagContents(NBTTagCompound p_validBookTagContents_0_) {
        if (!ItemWritableBook.isNBTValid(p_validBookTagContents_0_)) {
            return false;
        }
        if (!p_validBookTagContents_0_.hasKey("title", 8)) {
            return false;
        }
        String lvt_1_1_ = p_validBookTagContents_0_.getString("title");
        if (lvt_1_1_ == null || lvt_1_1_.length() > 32) {
            return false;
        }
        return p_validBookTagContents_0_.hasKey("author", 8);
    }

    public static int getGeneration(ItemStack p_getGeneration_0_) {
        return p_getGeneration_0_.getTagCompound().getInteger("generation");
    }

    @Override
    public String getItemStackDisplayName(ItemStack p_getItemStackDisplayName_1_) {
        NBTTagCompound lvt_2_1_;
        String lvt_3_1_;
        if (p_getItemStackDisplayName_1_.hasTagCompound() && !StringUtils.isNullOrEmpty(lvt_3_1_ = (lvt_2_1_ = p_getItemStackDisplayName_1_.getTagCompound()).getString("title"))) {
            return lvt_3_1_;
        }
        return super.getItemStackDisplayName(p_getItemStackDisplayName_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack p_addInformation_1_, EntityPlayer p_addInformation_2_, List<String> p_addInformation_3_, boolean p_addInformation_4_) {
        if (p_addInformation_1_.hasTagCompound()) {
            NBTTagCompound lvt_5_1_ = p_addInformation_1_.getTagCompound();
            String lvt_6_1_ = lvt_5_1_.getString("author");
            if (!StringUtils.isNullOrEmpty(lvt_6_1_)) {
                p_addInformation_3_.add((Object)((Object)TextFormatting.GRAY) + I18n.translateToLocalFormatted("book.byAuthor", lvt_6_1_));
            }
            p_addInformation_3_.add((Object)((Object)TextFormatting.GRAY) + I18n.translateToLocal("book.generation." + lvt_5_1_.getInteger("generation")));
        }
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World p_onItemRightClick_1_, EntityPlayer p_onItemRightClick_2_, EnumHand p_onItemRightClick_3_) {
        ItemStack lvt_4_1_ = p_onItemRightClick_2_.getHeldItem(p_onItemRightClick_3_);
        if (!p_onItemRightClick_1_.isRemote) {
            this.resolveContents(lvt_4_1_, p_onItemRightClick_2_);
        }
        p_onItemRightClick_2_.openBook(lvt_4_1_, p_onItemRightClick_3_);
        p_onItemRightClick_2_.addStat(StatList.getObjectUseStats(this));
        return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, lvt_4_1_);
    }

    private void resolveContents(ItemStack p_resolveContents_1_, EntityPlayer p_resolveContents_2_) {
        if (p_resolveContents_1_.getTagCompound() == null) {
            return;
        }
        NBTTagCompound lvt_3_1_ = p_resolveContents_1_.getTagCompound();
        if (lvt_3_1_.getBoolean("resolved")) {
            return;
        }
        lvt_3_1_.setBoolean("resolved", true);
        if (!ItemWrittenBook.validBookTagContents(lvt_3_1_)) {
            return;
        }
        NBTTagList lvt_4_1_ = lvt_3_1_.getTagList("pages", 8);
        for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_4_1_.tagCount(); ++lvt_5_1_) {
            TextComponentString lvt_7_2_;
            String lvt_6_1_ = lvt_4_1_.getStringTagAt(lvt_5_1_);
            try {
                ITextComponent lvt_7_1_ = ITextComponent.Serializer.fromJsonLenient(lvt_6_1_);
                lvt_7_1_ = TextComponentUtils.processComponent(p_resolveContents_2_, lvt_7_1_, p_resolveContents_2_);
            }
            catch (Exception lvt_8_1_) {
                lvt_7_2_ = new TextComponentString(lvt_6_1_);
            }
            lvt_4_1_.set(lvt_5_1_, new NBTTagString(ITextComponent.Serializer.componentToJson(lvt_7_2_)));
        }
        lvt_3_1_.setTag("pages", lvt_4_1_);
        if (p_resolveContents_2_ instanceof EntityPlayerMP && p_resolveContents_2_.getHeldItemMainhand() == p_resolveContents_1_) {
            Slot lvt_5_2_ = p_resolveContents_2_.openContainer.getSlotFromInventory(p_resolveContents_2_.inventory, p_resolveContents_2_.inventory.currentItem);
            ((EntityPlayerMP)p_resolveContents_2_).connection.sendPacket(new SPacketSetSlot(0, lvt_5_2_.slotNumber, p_resolveContents_1_));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack p_hasEffect_1_) {
        return true;
    }
}

