/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockStoneSlabNew;
import net.minecraft.block.BlockWall;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBookCloning;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipeRepairItem;
import net.minecraft.item.crafting.RecipeTippedArrow;
import net.minecraft.item.crafting.RecipesArmor;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.item.crafting.RecipesBanners;
import net.minecraft.item.crafting.RecipesCrafting;
import net.minecraft.item.crafting.RecipesDyes;
import net.minecraft.item.crafting.RecipesFood;
import net.minecraft.item.crafting.RecipesIngots;
import net.minecraft.item.crafting.RecipesMapCloning;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.item.crafting.RecipesTools;
import net.minecraft.item.crafting.RecipesWeapons;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.item.crafting.ShieldRecipes;
import net.minecraft.item.crafting.ShulkerBoxRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class CraftingManager {
    private static final CraftingManager INSTANCE = new CraftingManager();
    private final List<IRecipe> recipes = Lists.newArrayList();

    public static CraftingManager getInstance() {
        return INSTANCE;
    }

    private CraftingManager() {
        new RecipesTools().addRecipes(this);
        new RecipesWeapons().addRecipes(this);
        new RecipesIngots().addRecipes(this);
        new RecipesFood().addRecipes(this);
        new RecipesCrafting().addRecipes(this);
        new RecipesArmor().addRecipes(this);
        new RecipesDyes().addRecipes(this);
        this.recipes.add(new RecipesArmorDyes());
        this.recipes.add(new RecipeBookCloning());
        this.recipes.add(new RecipesMapCloning());
        this.recipes.add(new RecipesMapExtending());
        this.recipes.add(new RecipeFireworks());
        this.recipes.add(new RecipeRepairItem());
        this.recipes.add(new RecipeTippedArrow());
        new RecipesBanners().addRecipes(this);
        new ShieldRecipes().addRecipes(this);
        new ShulkerBoxRecipes().addRecipes(this);
        this.addRecipe(new ItemStack(Items.PAPER, 3), "###", Character.valueOf('#'), Items.REEDS);
        this.addShapelessRecipe(new ItemStack(Items.BOOK, 1), Items.PAPER, Items.PAPER, Items.PAPER, Items.LEATHER);
        this.addShapelessRecipe(new ItemStack(Items.WRITABLE_BOOK, 1), Items.BOOK, new ItemStack(Items.DYE, 1, EnumDyeColor.BLACK.getDyeDamage()), Items.FEATHER);
        this.addRecipe(new ItemStack(Blocks.OAK_FENCE, 3), "W#W", "W#W", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.OAK.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.BIRCH_FENCE, 3), "W#W", "W#W", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.BIRCH.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.SPRUCE_FENCE, 3), "W#W", "W#W", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.SPRUCE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.JUNGLE_FENCE, 3), "W#W", "W#W", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.JUNGLE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.ACACIA_FENCE, 3), "W#W", "W#W", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, 4 + BlockPlanks.EnumType.ACACIA.getMetadata() - 4));
        this.addRecipe(new ItemStack(Blocks.DARK_OAK_FENCE, 3), "W#W", "W#W", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, 4 + BlockPlanks.EnumType.DARK_OAK.getMetadata() - 4));
        this.addRecipe(new ItemStack(Blocks.COBBLESTONE_WALL, 6, BlockWall.EnumType.NORMAL.getMetadata()), "###", "###", Character.valueOf('#'), Blocks.COBBLESTONE);
        this.addRecipe(new ItemStack(Blocks.COBBLESTONE_WALL, 6, BlockWall.EnumType.MOSSY.getMetadata()), "###", "###", Character.valueOf('#'), Blocks.MOSSY_COBBLESTONE);
        this.addRecipe(new ItemStack(Blocks.NETHER_BRICK_FENCE, 6), "###", "###", Character.valueOf('#'), Blocks.NETHER_BRICK);
        this.addRecipe(new ItemStack(Blocks.OAK_FENCE_GATE, 1), "#W#", "#W#", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.OAK.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.BIRCH_FENCE_GATE, 1), "#W#", "#W#", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.BIRCH.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.SPRUCE_FENCE_GATE, 1), "#W#", "#W#", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.SPRUCE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.JUNGLE_FENCE_GATE, 1), "#W#", "#W#", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.JUNGLE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.ACACIA_FENCE_GATE, 1), "#W#", "#W#", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, 4 + BlockPlanks.EnumType.ACACIA.getMetadata() - 4));
        this.addRecipe(new ItemStack(Blocks.DARK_OAK_FENCE_GATE, 1), "#W#", "#W#", Character.valueOf('#'), Items.STICK, Character.valueOf('W'), new ItemStack(Blocks.PLANKS, 1, 4 + BlockPlanks.EnumType.DARK_OAK.getMetadata() - 4));
        this.addRecipe(new ItemStack(Blocks.JUKEBOX, 1), "###", "#X#", "###", Character.valueOf('#'), Blocks.PLANKS, Character.valueOf('X'), Items.DIAMOND);
        this.addRecipe(new ItemStack(Items.LEAD, 2), "~~ ", "~O ", "  ~", Character.valueOf('~'), Items.STRING, Character.valueOf('O'), Items.SLIME_BALL);
        this.addRecipe(new ItemStack(Blocks.NOTEBLOCK, 1), "###", "#X#", "###", Character.valueOf('#'), Blocks.PLANKS, Character.valueOf('X'), Items.REDSTONE);
        this.addRecipe(new ItemStack(Blocks.BOOKSHELF, 1), "###", "XXX", "###", Character.valueOf('#'), Blocks.PLANKS, Character.valueOf('X'), Items.BOOK);
        this.addRecipe(new ItemStack(Blocks.SNOW, 1), "##", "##", Character.valueOf('#'), Items.SNOWBALL);
        this.addRecipe(new ItemStack(Blocks.SNOW_LAYER, 6), "###", Character.valueOf('#'), Blocks.SNOW);
        this.addRecipe(new ItemStack(Blocks.CLAY, 1), "##", "##", Character.valueOf('#'), Items.CLAY_BALL);
        this.addRecipe(new ItemStack(Blocks.BRICK_BLOCK, 1), "##", "##", Character.valueOf('#'), Items.BRICK);
        this.addRecipe(new ItemStack(Blocks.GLOWSTONE, 1), "##", "##", Character.valueOf('#'), Items.GLOWSTONE_DUST);
        this.addRecipe(new ItemStack(Blocks.QUARTZ_BLOCK, 1), "##", "##", Character.valueOf('#'), Items.QUARTZ);
        this.addRecipe(new ItemStack(Blocks.WOOL, 1), "##", "##", Character.valueOf('#'), Items.STRING);
        this.addRecipe(new ItemStack(Blocks.TNT, 1), "X#X", "#X#", "X#X", Character.valueOf('X'), Items.GUNPOWDER, Character.valueOf('#'), Blocks.SAND);
        this.addRecipe(new ItemStack(Blocks.STONE_SLAB, 6, BlockStoneSlab.EnumType.COBBLESTONE.getMetadata()), "###", Character.valueOf('#'), Blocks.COBBLESTONE);
        this.addRecipe(new ItemStack(Blocks.STONE_SLAB, 6, BlockStoneSlab.EnumType.STONE.getMetadata()), "###", Character.valueOf('#'), new ItemStack(Blocks.STONE, 1, BlockStone.EnumType.STONE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.STONE_SLAB, 6, BlockStoneSlab.EnumType.SAND.getMetadata()), "###", Character.valueOf('#'), Blocks.SANDSTONE);
        this.addRecipe(new ItemStack(Blocks.STONE_SLAB, 6, BlockStoneSlab.EnumType.BRICK.getMetadata()), "###", Character.valueOf('#'), Blocks.BRICK_BLOCK);
        this.addRecipe(new ItemStack(Blocks.STONE_SLAB, 6, BlockStoneSlab.EnumType.SMOOTHBRICK.getMetadata()), "###", Character.valueOf('#'), Blocks.STONEBRICK);
        this.addRecipe(new ItemStack(Blocks.STONE_SLAB, 6, BlockStoneSlab.EnumType.NETHERBRICK.getMetadata()), "###", Character.valueOf('#'), Blocks.NETHER_BRICK);
        this.addRecipe(new ItemStack(Blocks.STONE_SLAB, 6, BlockStoneSlab.EnumType.QUARTZ.getMetadata()), "###", Character.valueOf('#'), Blocks.QUARTZ_BLOCK);
        this.addRecipe(new ItemStack(Blocks.STONE_SLAB2, 6, BlockStoneSlabNew.EnumType.RED_SANDSTONE.getMetadata()), "###", Character.valueOf('#'), Blocks.RED_SANDSTONE);
        this.addRecipe(new ItemStack(Blocks.PURPUR_SLAB, 6, 0), "###", Character.valueOf('#'), Blocks.PURPUR_BLOCK);
        this.addRecipe(new ItemStack(Blocks.WOODEN_SLAB, 6, 0), "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.OAK.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.WOODEN_SLAB, 6, BlockPlanks.EnumType.BIRCH.getMetadata()), "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.BIRCH.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.WOODEN_SLAB, 6, BlockPlanks.EnumType.SPRUCE.getMetadata()), "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.SPRUCE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.WOODEN_SLAB, 6, BlockPlanks.EnumType.JUNGLE.getMetadata()), "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.JUNGLE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.WOODEN_SLAB, 6, 4 + BlockPlanks.EnumType.ACACIA.getMetadata() - 4), "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, 4 + BlockPlanks.EnumType.ACACIA.getMetadata() - 4));
        this.addRecipe(new ItemStack(Blocks.WOODEN_SLAB, 6, 4 + BlockPlanks.EnumType.DARK_OAK.getMetadata() - 4), "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, 4 + BlockPlanks.EnumType.DARK_OAK.getMetadata() - 4));
        this.addRecipe(new ItemStack(Blocks.LADDER, 3), "# #", "###", "# #", Character.valueOf('#'), Items.STICK);
        this.addRecipe(new ItemStack(Items.OAK_DOOR, 3), "##", "##", "##", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.OAK.getMetadata()));
        this.addRecipe(new ItemStack(Items.SPRUCE_DOOR, 3), "##", "##", "##", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.SPRUCE.getMetadata()));
        this.addRecipe(new ItemStack(Items.BIRCH_DOOR, 3), "##", "##", "##", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.BIRCH.getMetadata()));
        this.addRecipe(new ItemStack(Items.JUNGLE_DOOR, 3), "##", "##", "##", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.JUNGLE.getMetadata()));
        this.addRecipe(new ItemStack(Items.ACACIA_DOOR, 3), "##", "##", "##", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.ACACIA.getMetadata()));
        this.addRecipe(new ItemStack(Items.DARK_OAK_DOOR, 3), "##", "##", "##", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.DARK_OAK.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.TRAPDOOR, 2), "###", "###", Character.valueOf('#'), Blocks.PLANKS);
        this.addRecipe(new ItemStack(Items.IRON_DOOR, 3), "##", "##", "##", Character.valueOf('#'), Items.IRON_INGOT);
        this.addRecipe(new ItemStack(Blocks.IRON_TRAPDOOR, 1), "##", "##", Character.valueOf('#'), Items.IRON_INGOT);
        this.addRecipe(new ItemStack(Items.SIGN, 3), "###", "###", " X ", Character.valueOf('#'), Blocks.PLANKS, Character.valueOf('X'), Items.STICK);
        this.addRecipe(new ItemStack(Items.CAKE, 1), "AAA", "BEB", "CCC", Character.valueOf('A'), Items.MILK_BUCKET, Character.valueOf('B'), Items.SUGAR, Character.valueOf('C'), Items.WHEAT, Character.valueOf('E'), Items.EGG);
        this.addRecipe(new ItemStack(Items.SUGAR, 1), "#", Character.valueOf('#'), Items.REEDS);
        this.addRecipe(new ItemStack(Blocks.PLANKS, 4, BlockPlanks.EnumType.OAK.getMetadata()), "#", Character.valueOf('#'), new ItemStack(Blocks.LOG, 1, BlockPlanks.EnumType.OAK.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.PLANKS, 4, BlockPlanks.EnumType.SPRUCE.getMetadata()), "#", Character.valueOf('#'), new ItemStack(Blocks.LOG, 1, BlockPlanks.EnumType.SPRUCE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.PLANKS, 4, BlockPlanks.EnumType.BIRCH.getMetadata()), "#", Character.valueOf('#'), new ItemStack(Blocks.LOG, 1, BlockPlanks.EnumType.BIRCH.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.PLANKS, 4, BlockPlanks.EnumType.JUNGLE.getMetadata()), "#", Character.valueOf('#'), new ItemStack(Blocks.LOG, 1, BlockPlanks.EnumType.JUNGLE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.PLANKS, 4, 4 + BlockPlanks.EnumType.ACACIA.getMetadata() - 4), "#", Character.valueOf('#'), new ItemStack(Blocks.LOG2, 1, BlockPlanks.EnumType.ACACIA.getMetadata() - 4));
        this.addRecipe(new ItemStack(Blocks.PLANKS, 4, 4 + BlockPlanks.EnumType.DARK_OAK.getMetadata() - 4), "#", Character.valueOf('#'), new ItemStack(Blocks.LOG2, 1, BlockPlanks.EnumType.DARK_OAK.getMetadata() - 4));
        this.addRecipe(new ItemStack(Items.STICK, 4), "#", "#", Character.valueOf('#'), Blocks.PLANKS);
        this.addRecipe(new ItemStack(Blocks.TORCH, 4), "X", "#", Character.valueOf('X'), Items.COAL, Character.valueOf('#'), Items.STICK);
        this.addRecipe(new ItemStack(Blocks.TORCH, 4), "X", "#", Character.valueOf('X'), new ItemStack(Items.COAL, 1, 1), Character.valueOf('#'), Items.STICK);
        this.addRecipe(new ItemStack(Items.BOWL, 4), "# #", " # ", Character.valueOf('#'), Blocks.PLANKS);
        this.addRecipe(new ItemStack(Items.GLASS_BOTTLE, 3), "# #", " # ", Character.valueOf('#'), Blocks.GLASS);
        this.addRecipe(new ItemStack(Blocks.RAIL, 16), "X X", "X#X", "X X", Character.valueOf('X'), Items.IRON_INGOT, Character.valueOf('#'), Items.STICK);
        this.addRecipe(new ItemStack(Blocks.GOLDEN_RAIL, 6), "X X", "X#X", "XRX", Character.valueOf('X'), Items.GOLD_INGOT, Character.valueOf('R'), Items.REDSTONE, Character.valueOf('#'), Items.STICK);
        this.addRecipe(new ItemStack(Blocks.ACTIVATOR_RAIL, 6), "XSX", "X#X", "XSX", Character.valueOf('X'), Items.IRON_INGOT, Character.valueOf('#'), Blocks.REDSTONE_TORCH, Character.valueOf('S'), Items.STICK);
        this.addRecipe(new ItemStack(Blocks.DETECTOR_RAIL, 6), "X X", "X#X", "XRX", Character.valueOf('X'), Items.IRON_INGOT, Character.valueOf('R'), Items.REDSTONE, Character.valueOf('#'), Blocks.STONE_PRESSURE_PLATE);
        this.addRecipe(new ItemStack(Items.MINECART, 1), "# #", "###", Character.valueOf('#'), Items.IRON_INGOT);
        this.addRecipe(new ItemStack(Items.CAULDRON, 1), "# #", "# #", "###", Character.valueOf('#'), Items.IRON_INGOT);
        this.addRecipe(new ItemStack(Items.BREWING_STAND, 1), " B ", "###", Character.valueOf('#'), Blocks.COBBLESTONE, Character.valueOf('B'), Items.BLAZE_ROD);
        this.addRecipe(new ItemStack(Blocks.LIT_PUMPKIN, 1), "A", "B", Character.valueOf('A'), Blocks.PUMPKIN, Character.valueOf('B'), Blocks.TORCH);
        this.addRecipe(new ItemStack(Items.CHEST_MINECART, 1), "A", "B", Character.valueOf('A'), Blocks.CHEST, Character.valueOf('B'), Items.MINECART);
        this.addRecipe(new ItemStack(Items.FURNACE_MINECART, 1), "A", "B", Character.valueOf('A'), Blocks.FURNACE, Character.valueOf('B'), Items.MINECART);
        this.addRecipe(new ItemStack(Items.TNT_MINECART, 1), "A", "B", Character.valueOf('A'), Blocks.TNT, Character.valueOf('B'), Items.MINECART);
        this.addRecipe(new ItemStack(Items.HOPPER_MINECART, 1), "A", "B", Character.valueOf('A'), Blocks.HOPPER, Character.valueOf('B'), Items.MINECART);
        this.addRecipe(new ItemStack(Items.BOAT, 1), "# #", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.OAK.getMetadata()));
        this.addRecipe(new ItemStack(Items.SPRUCE_BOAT, 1), "# #", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.SPRUCE.getMetadata()));
        this.addRecipe(new ItemStack(Items.BIRCH_BOAT, 1), "# #", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.BIRCH.getMetadata()));
        this.addRecipe(new ItemStack(Items.JUNGLE_BOAT, 1), "# #", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.JUNGLE.getMetadata()));
        this.addRecipe(new ItemStack(Items.ACACIA_BOAT, 1), "# #", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.ACACIA.getMetadata()));
        this.addRecipe(new ItemStack(Items.DARK_OAK_BOAT, 1), "# #", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.DARK_OAK.getMetadata()));
        this.addRecipe(new ItemStack(Items.BUCKET, 1), "# #", " # ", Character.valueOf('#'), Items.IRON_INGOT);
        this.addRecipe(new ItemStack(Items.FLOWER_POT, 1), "# #", " # ", Character.valueOf('#'), Items.BRICK);
        this.addShapelessRecipe(new ItemStack(Items.FLINT_AND_STEEL, 1), new ItemStack(Items.IRON_INGOT, 1), new ItemStack(Items.FLINT, 1));
        this.addRecipe(new ItemStack(Items.BREAD, 1), "###", Character.valueOf('#'), Items.WHEAT);
        this.addRecipe(new ItemStack(Blocks.OAK_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.OAK.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.BIRCH_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.BIRCH.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.SPRUCE_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.SPRUCE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.JUNGLE_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, BlockPlanks.EnumType.JUNGLE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.ACACIA_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, 4 + BlockPlanks.EnumType.ACACIA.getMetadata() - 4));
        this.addRecipe(new ItemStack(Blocks.DARK_OAK_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(Blocks.PLANKS, 1, 4 + BlockPlanks.EnumType.DARK_OAK.getMetadata() - 4));
        this.addRecipe(new ItemStack(Items.FISHING_ROD, 1), "  #", " #X", "# X", Character.valueOf('#'), Items.STICK, Character.valueOf('X'), Items.STRING);
        this.addRecipe(new ItemStack(Items.CARROT_ON_A_STICK, 1), "# ", " X", Character.valueOf('#'), Items.FISHING_ROD, Character.valueOf('X'), Items.CARROT);
        this.addRecipe(new ItemStack(Blocks.STONE_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Blocks.COBBLESTONE);
        this.addRecipe(new ItemStack(Blocks.BRICK_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Blocks.BRICK_BLOCK);
        this.addRecipe(new ItemStack(Blocks.STONE_BRICK_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Blocks.STONEBRICK);
        this.addRecipe(new ItemStack(Blocks.NETHER_BRICK_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Blocks.NETHER_BRICK);
        this.addRecipe(new ItemStack(Blocks.SANDSTONE_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Blocks.SANDSTONE);
        this.addRecipe(new ItemStack(Blocks.RED_SANDSTONE_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Blocks.RED_SANDSTONE);
        this.addRecipe(new ItemStack(Blocks.QUARTZ_STAIRS, 4), "#  ", "## ", "###", Character.valueOf('#'), Blocks.QUARTZ_BLOCK);
        this.addRecipe(new ItemStack(Items.PAINTING, 1), "###", "#X#", "###", Character.valueOf('#'), Items.STICK, Character.valueOf('X'), Blocks.WOOL);
        this.addRecipe(new ItemStack(Items.ITEM_FRAME, 1), "###", "#X#", "###", Character.valueOf('#'), Items.STICK, Character.valueOf('X'), Items.LEATHER);
        this.addRecipe(new ItemStack(Items.GOLDEN_APPLE), "###", "#X#", "###", Character.valueOf('#'), Items.GOLD_INGOT, Character.valueOf('X'), Items.APPLE);
        this.addRecipe(new ItemStack(Items.GOLDEN_CARROT), "###", "#X#", "###", Character.valueOf('#'), Items.GOLD_NUGGET, Character.valueOf('X'), Items.CARROT);
        this.addRecipe(new ItemStack(Items.SPECKLED_MELON, 1), "###", "#X#", "###", Character.valueOf('#'), Items.GOLD_NUGGET, Character.valueOf('X'), Items.MELON);
        this.addRecipe(new ItemStack(Blocks.LEVER, 1), "X", "#", Character.valueOf('#'), Blocks.COBBLESTONE, Character.valueOf('X'), Items.STICK);
        this.addRecipe(new ItemStack(Blocks.TRIPWIRE_HOOK, 2), "I", "S", "#", Character.valueOf('#'), Blocks.PLANKS, Character.valueOf('S'), Items.STICK, Character.valueOf('I'), Items.IRON_INGOT);
        this.addRecipe(new ItemStack(Blocks.REDSTONE_TORCH, 1), "X", "#", Character.valueOf('#'), Items.STICK, Character.valueOf('X'), Items.REDSTONE);
        this.addRecipe(new ItemStack(Items.REPEATER, 1), "#X#", "III", Character.valueOf('#'), Blocks.REDSTONE_TORCH, Character.valueOf('X'), Items.REDSTONE, Character.valueOf('I'), new ItemStack(Blocks.STONE, 1, BlockStone.EnumType.STONE.getMetadata()));
        this.addRecipe(new ItemStack(Items.COMPARATOR, 1), " # ", "#X#", "III", Character.valueOf('#'), Blocks.REDSTONE_TORCH, Character.valueOf('X'), Items.QUARTZ, Character.valueOf('I'), new ItemStack(Blocks.STONE, 1, BlockStone.EnumType.STONE.getMetadata()));
        this.addRecipe(new ItemStack(Items.CLOCK, 1), " # ", "#X#", " # ", Character.valueOf('#'), Items.GOLD_INGOT, Character.valueOf('X'), Items.REDSTONE);
        this.addRecipe(new ItemStack(Items.COMPASS, 1), " # ", "#X#", " # ", Character.valueOf('#'), Items.IRON_INGOT, Character.valueOf('X'), Items.REDSTONE);
        this.addRecipe(new ItemStack(Items.MAP, 1), "###", "#X#", "###", Character.valueOf('#'), Items.PAPER, Character.valueOf('X'), Items.COMPASS);
        this.addRecipe(new ItemStack(Blocks.STONE_BUTTON, 1), "#", Character.valueOf('#'), new ItemStack(Blocks.STONE, 1, BlockStone.EnumType.STONE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.WOODEN_BUTTON, 1), "#", Character.valueOf('#'), Blocks.PLANKS);
        this.addRecipe(new ItemStack(Blocks.STONE_PRESSURE_PLATE, 1), "##", Character.valueOf('#'), new ItemStack(Blocks.STONE, 1, BlockStone.EnumType.STONE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.WOODEN_PRESSURE_PLATE, 1), "##", Character.valueOf('#'), Blocks.PLANKS);
        this.addRecipe(new ItemStack(Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE, 1), "##", Character.valueOf('#'), Items.IRON_INGOT);
        this.addRecipe(new ItemStack(Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE, 1), "##", Character.valueOf('#'), Items.GOLD_INGOT);
        this.addRecipe(new ItemStack(Blocks.DISPENSER, 1), "###", "#X#", "#R#", Character.valueOf('#'), Blocks.COBBLESTONE, Character.valueOf('X'), Items.BOW, Character.valueOf('R'), Items.REDSTONE);
        this.addRecipe(new ItemStack(Blocks.DROPPER, 1), "###", "# #", "#R#", Character.valueOf('#'), Blocks.COBBLESTONE, Character.valueOf('R'), Items.REDSTONE);
        this.addRecipe(new ItemStack(Blocks.OBSERVER, 1), "###", "RRQ", "###", Character.valueOf('#'), Blocks.COBBLESTONE, Character.valueOf('R'), Items.REDSTONE, Character.valueOf('Q'), Items.QUARTZ);
        this.addRecipe(new ItemStack(Blocks.PISTON, 1), "TTT", "#X#", "#R#", Character.valueOf('#'), Blocks.COBBLESTONE, Character.valueOf('X'), Items.IRON_INGOT, Character.valueOf('R'), Items.REDSTONE, Character.valueOf('T'), Blocks.PLANKS);
        this.addRecipe(new ItemStack(Blocks.STICKY_PISTON, 1), "S", "P", Character.valueOf('S'), Items.SLIME_BALL, Character.valueOf('P'), Blocks.PISTON);
        this.addRecipe(new ItemStack(Items.BED, 1), "###", "XXX", Character.valueOf('#'), Blocks.WOOL, Character.valueOf('X'), Blocks.PLANKS);
        this.addRecipe(new ItemStack(Blocks.ENCHANTING_TABLE, 1), " B ", "D#D", "###", Character.valueOf('#'), Blocks.OBSIDIAN, Character.valueOf('B'), Items.BOOK, Character.valueOf('D'), Items.DIAMOND);
        this.addRecipe(new ItemStack(Blocks.ANVIL, 1), "III", " i ", "iii", Character.valueOf('I'), Blocks.IRON_BLOCK, Character.valueOf('i'), Items.IRON_INGOT);
        this.addRecipe(new ItemStack(Items.LEATHER), "##", "##", Character.valueOf('#'), Items.RABBIT_HIDE);
        this.addShapelessRecipe(new ItemStack(Items.ENDER_EYE, 1), Items.ENDER_PEARL, Items.BLAZE_POWDER);
        this.addShapelessRecipe(new ItemStack(Items.FIRE_CHARGE, 3), Items.GUNPOWDER, Items.BLAZE_POWDER, Items.COAL);
        this.addShapelessRecipe(new ItemStack(Items.FIRE_CHARGE, 3), Items.GUNPOWDER, Items.BLAZE_POWDER, new ItemStack(Items.COAL, 1, 1));
        this.addRecipe(new ItemStack(Blocks.DAYLIGHT_DETECTOR), "GGG", "QQQ", "WWW", Character.valueOf('G'), Blocks.GLASS, Character.valueOf('Q'), Items.QUARTZ, Character.valueOf('W'), Blocks.WOODEN_SLAB);
        this.addRecipe(new ItemStack(Items.END_CRYSTAL), "GGG", "GEG", "GTG", Character.valueOf('G'), Blocks.GLASS, Character.valueOf('E'), Items.ENDER_EYE, Character.valueOf('T'), Items.GHAST_TEAR);
        this.addRecipe(new ItemStack(Blocks.HOPPER), "I I", "ICI", " I ", Character.valueOf('I'), Items.IRON_INGOT, Character.valueOf('C'), Blocks.CHEST);
        this.addRecipe(new ItemStack(Items.ARMOR_STAND, 1), "///", " / ", "/_/", Character.valueOf('/'), Items.STICK, Character.valueOf('_'), new ItemStack(Blocks.STONE_SLAB, 1, BlockStoneSlab.EnumType.STONE.getMetadata()));
        this.addRecipe(new ItemStack(Blocks.END_ROD, 4), "/", "#", Character.valueOf('/'), Items.BLAZE_ROD, Character.valueOf('#'), Items.CHORUS_FRUIT_POPPED);
        this.addRecipe(new ItemStack(Blocks.BONE_BLOCK, 1), "XXX", "XXX", "XXX", Character.valueOf('X'), new ItemStack(Items.DYE, 1, EnumDyeColor.WHITE.getDyeDamage()));
        Collections.sort(this.recipes, new Comparator<IRecipe>(){

            @Override
            public int compare(IRecipe p_compare_1_, IRecipe p_compare_2_) {
                if (p_compare_1_ instanceof ShapelessRecipes && p_compare_2_ instanceof ShapedRecipes) {
                    return 1;
                }
                if (p_compare_2_ instanceof ShapelessRecipes && p_compare_1_ instanceof ShapedRecipes) {
                    return -1;
                }
                if (p_compare_2_.getRecipeSize() < p_compare_1_.getRecipeSize()) {
                    return -1;
                }
                if (p_compare_2_.getRecipeSize() > p_compare_1_.getRecipeSize()) {
                    return 1;
                }
                return 0;
            }

            @Override
            public /* synthetic */ int compare(Object p_compare_1_, Object p_compare_2_) {
                return this.compare((IRecipe)p_compare_1_, (IRecipe)p_compare_2_);
            }
        });
    }

    public ShapedRecipes addRecipe(ItemStack p_addRecipe_1_, Object ... p_addRecipe_2_) {
        String lvt_3_1_ = "";
        int lvt_4_1_ = 0;
        int lvt_5_1_ = 0;
        int lvt_6_1_ = 0;
        if (p_addRecipe_2_[lvt_4_1_] instanceof String[]) {
            String[] lvt_7_1_;
            for (String lvt_11_1_ : lvt_7_1_ = (String[])p_addRecipe_2_[lvt_4_1_++]) {
                ++lvt_6_1_;
                lvt_5_1_ = lvt_11_1_.length();
                lvt_3_1_ = lvt_3_1_ + lvt_11_1_;
            }
        } else {
            while (p_addRecipe_2_[lvt_4_1_] instanceof String) {
                String lvt_7_2_ = (String)p_addRecipe_2_[lvt_4_1_++];
                ++lvt_6_1_;
                lvt_5_1_ = lvt_7_2_.length();
                lvt_3_1_ = lvt_3_1_ + lvt_7_2_;
            }
        }
        HashMap lvt_7_3_ = Maps.newHashMap();
        while (lvt_4_1_ < p_addRecipe_2_.length) {
            Character lvt_8_1_ = (Character)p_addRecipe_2_[lvt_4_1_];
            ItemStack lvt_9_1_ = ItemStack.EMPTY;
            if (p_addRecipe_2_[lvt_4_1_ + 1] instanceof Item) {
                lvt_9_1_ = new ItemStack((Item)p_addRecipe_2_[lvt_4_1_ + 1]);
            } else if (p_addRecipe_2_[lvt_4_1_ + 1] instanceof Block) {
                lvt_9_1_ = new ItemStack((Block)p_addRecipe_2_[lvt_4_1_ + 1], 1, Short.MAX_VALUE);
            } else if (p_addRecipe_2_[lvt_4_1_ + 1] instanceof ItemStack) {
                lvt_9_1_ = (ItemStack)p_addRecipe_2_[lvt_4_1_ + 1];
            }
            lvt_7_3_.put(lvt_8_1_, lvt_9_1_);
            lvt_4_1_ += 2;
        }
        ItemStack[] lvt_8_2_ = new ItemStack[lvt_5_1_ * lvt_6_1_];
        for (int lvt_9_2_ = 0; lvt_9_2_ < lvt_5_1_ * lvt_6_1_; ++lvt_9_2_) {
            char lvt_10_1_ = lvt_3_1_.charAt(lvt_9_2_);
            lvt_8_2_[lvt_9_2_] = lvt_7_3_.containsKey(Character.valueOf(lvt_10_1_)) ? ((ItemStack)lvt_7_3_.get(Character.valueOf(lvt_10_1_))).copy() : ItemStack.EMPTY;
        }
        ShapedRecipes lvt_9_3_ = new ShapedRecipes(lvt_5_1_, lvt_6_1_, lvt_8_2_, p_addRecipe_1_);
        this.recipes.add(lvt_9_3_);
        return lvt_9_3_;
    }

    public void addShapelessRecipe(ItemStack p_addShapelessRecipe_1_, Object ... p_addShapelessRecipe_2_) {
        ArrayList lvt_3_1_ = Lists.newArrayList();
        for (Object lvt_7_1_ : p_addShapelessRecipe_2_) {
            if (lvt_7_1_ instanceof ItemStack) {
                lvt_3_1_.add(((ItemStack)lvt_7_1_).copy());
                continue;
            }
            if (lvt_7_1_ instanceof Item) {
                lvt_3_1_.add(new ItemStack((Item)lvt_7_1_));
                continue;
            }
            if (lvt_7_1_ instanceof Block) {
                lvt_3_1_.add(new ItemStack((Block)lvt_7_1_));
                continue;
            }
            throw new IllegalArgumentException("Invalid shapeless recipe: unknown type " + lvt_7_1_.getClass().getName() + "!");
        }
        this.recipes.add(new ShapelessRecipes(p_addShapelessRecipe_1_, lvt_3_1_));
    }

    public void addRecipe(IRecipe p_addRecipe_1_) {
        this.recipes.add(p_addRecipe_1_);
    }

    public ItemStack findMatchingRecipe(InventoryCrafting p_findMatchingRecipe_1_, World p_findMatchingRecipe_2_) {
        for (IRecipe lvt_4_1_ : this.recipes) {
            if (!lvt_4_1_.matches(p_findMatchingRecipe_1_, p_findMatchingRecipe_2_)) continue;
            return lvt_4_1_.getCraftingResult(p_findMatchingRecipe_1_);
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting p_getRemainingItems_1_, World p_getRemainingItems_2_) {
        for (IRecipe lvt_4_1_ : this.recipes) {
            if (!lvt_4_1_.matches(p_getRemainingItems_1_, p_getRemainingItems_2_)) continue;
            return lvt_4_1_.getRemainingItems(p_getRemainingItems_1_);
        }
        NonNullList<ItemStack> lvt_3_1_ = NonNullList.withSize(p_getRemainingItems_1_.getSizeInventory(), ItemStack.EMPTY);
        for (int lvt_4_2_ = 0; lvt_4_2_ < lvt_3_1_.size(); ++lvt_4_2_) {
            lvt_3_1_.set(lvt_4_2_, p_getRemainingItems_1_.getStackInSlot(lvt_4_2_));
        }
        return lvt_3_1_;
    }

    public List<IRecipe> getRecipeList() {
        return this.recipes;
    }
}

