/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class FurnaceRecipes {
    private static final FurnaceRecipes SMELTING_BASE = new FurnaceRecipes();
    private final Map<ItemStack, ItemStack> smeltingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static FurnaceRecipes instance() {
        return SMELTING_BASE;
    }

    private FurnaceRecipes() {
        this.addSmeltingRecipeForBlock(Blocks.IRON_ORE, new ItemStack(Items.IRON_INGOT), 0.7f);
        this.addSmeltingRecipeForBlock(Blocks.GOLD_ORE, new ItemStack(Items.GOLD_INGOT), 1.0f);
        this.addSmeltingRecipeForBlock(Blocks.DIAMOND_ORE, new ItemStack(Items.DIAMOND), 1.0f);
        this.addSmeltingRecipeForBlock(Blocks.SAND, new ItemStack(Blocks.GLASS), 0.1f);
        this.addSmelting(Items.PORKCHOP, new ItemStack(Items.COOKED_PORKCHOP), 0.35f);
        this.addSmelting(Items.BEEF, new ItemStack(Items.COOKED_BEEF), 0.35f);
        this.addSmelting(Items.CHICKEN, new ItemStack(Items.COOKED_CHICKEN), 0.35f);
        this.addSmelting(Items.RABBIT, new ItemStack(Items.COOKED_RABBIT), 0.35f);
        this.addSmelting(Items.MUTTON, new ItemStack(Items.COOKED_MUTTON), 0.35f);
        this.addSmeltingRecipeForBlock(Blocks.COBBLESTONE, new ItemStack(Blocks.STONE), 0.1f);
        this.addSmeltingRecipe(new ItemStack(Blocks.STONEBRICK, 1, BlockStoneBrick.DEFAULT_META), new ItemStack(Blocks.STONEBRICK, 1, BlockStoneBrick.CRACKED_META), 0.1f);
        this.addSmelting(Items.CLAY_BALL, new ItemStack(Items.BRICK), 0.3f);
        this.addSmeltingRecipeForBlock(Blocks.CLAY, new ItemStack(Blocks.HARDENED_CLAY), 0.35f);
        this.addSmeltingRecipeForBlock(Blocks.CACTUS, new ItemStack(Items.DYE, 1, EnumDyeColor.GREEN.getDyeDamage()), 0.2f);
        this.addSmeltingRecipeForBlock(Blocks.LOG, new ItemStack(Items.COAL, 1, 1), 0.15f);
        this.addSmeltingRecipeForBlock(Blocks.LOG2, new ItemStack(Items.COAL, 1, 1), 0.15f);
        this.addSmeltingRecipeForBlock(Blocks.EMERALD_ORE, new ItemStack(Items.EMERALD), 1.0f);
        this.addSmelting(Items.POTATO, new ItemStack(Items.BAKED_POTATO), 0.35f);
        this.addSmeltingRecipeForBlock(Blocks.NETHERRACK, new ItemStack(Items.NETHERBRICK), 0.1f);
        this.addSmeltingRecipe(new ItemStack(Blocks.SPONGE, 1, 1), new ItemStack(Blocks.SPONGE, 1, 0), 0.15f);
        this.addSmelting(Items.CHORUS_FRUIT, new ItemStack(Items.CHORUS_FRUIT_POPPED), 0.1f);
        for (ItemFishFood.FishType itemfishfood$fishtype : ItemFishFood.FishType.values()) {
            if (!itemfishfood$fishtype.canCook()) continue;
            this.addSmeltingRecipe(new ItemStack(Items.FISH, 1, itemfishfood$fishtype.getMetadata()), new ItemStack(Items.COOKED_FISH, 1, itemfishfood$fishtype.getMetadata()), 0.35f);
        }
        this.addSmeltingRecipeForBlock(Blocks.COAL_ORE, new ItemStack(Items.COAL), 0.1f);
        this.addSmeltingRecipeForBlock(Blocks.REDSTONE_ORE, new ItemStack(Items.REDSTONE), 0.7f);
        this.addSmeltingRecipeForBlock(Blocks.LAPIS_ORE, new ItemStack(Items.DYE, 1, EnumDyeColor.BLUE.getDyeDamage()), 0.2f);
        this.addSmeltingRecipeForBlock(Blocks.QUARTZ_ORE, new ItemStack(Items.QUARTZ), 0.2f);
        this.addSmelting(Items.CHAINMAIL_HELMET, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.CHAINMAIL_CHESTPLATE, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.CHAINMAIL_LEGGINGS, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.CHAINMAIL_BOOTS, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.IRON_PICKAXE, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.IRON_SHOVEL, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.IRON_AXE, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.IRON_HOE, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.IRON_SWORD, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.IRON_HELMET, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.IRON_CHESTPLATE, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.IRON_LEGGINGS, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.IRON_BOOTS, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.IRON_HORSE_ARMOR, new ItemStack(Items.field_191525_da), 0.1f);
        this.addSmelting(Items.GOLDEN_PICKAXE, new ItemStack(Items.GOLD_NUGGET), 0.1f);
        this.addSmelting(Items.GOLDEN_SHOVEL, new ItemStack(Items.GOLD_NUGGET), 0.1f);
        this.addSmelting(Items.GOLDEN_AXE, new ItemStack(Items.GOLD_NUGGET), 0.1f);
        this.addSmelting(Items.GOLDEN_HOE, new ItemStack(Items.GOLD_NUGGET), 0.1f);
        this.addSmelting(Items.GOLDEN_SWORD, new ItemStack(Items.GOLD_NUGGET), 0.1f);
        this.addSmelting(Items.GOLDEN_HELMET, new ItemStack(Items.GOLD_NUGGET), 0.1f);
        this.addSmelting(Items.GOLDEN_CHESTPLATE, new ItemStack(Items.GOLD_NUGGET), 0.1f);
        this.addSmelting(Items.GOLDEN_LEGGINGS, new ItemStack(Items.GOLD_NUGGET), 0.1f);
        this.addSmelting(Items.GOLDEN_BOOTS, new ItemStack(Items.GOLD_NUGGET), 0.1f);
        this.addSmelting(Items.GOLDEN_HORSE_ARMOR, new ItemStack(Items.GOLD_NUGGET), 0.1f);
    }

    public void addSmeltingRecipeForBlock(Block p_addSmeltingRecipeForBlock_1_, ItemStack p_addSmeltingRecipeForBlock_2_, float p_addSmeltingRecipeForBlock_3_) {
        this.addSmelting(Item.getItemFromBlock(p_addSmeltingRecipeForBlock_1_), p_addSmeltingRecipeForBlock_2_, p_addSmeltingRecipeForBlock_3_);
    }

    public void addSmelting(Item p_addSmelting_1_, ItemStack p_addSmelting_2_, float p_addSmelting_3_) {
        this.addSmeltingRecipe(new ItemStack(p_addSmelting_1_, 1, Short.MAX_VALUE), p_addSmelting_2_, p_addSmelting_3_);
    }

    public void addSmeltingRecipe(ItemStack p_addSmeltingRecipe_1_, ItemStack p_addSmeltingRecipe_2_, float p_addSmeltingRecipe_3_) {
        if (this.getSmeltingResult(p_addSmeltingRecipe_1_) != ItemStack.EMPTY) {
            FMLLog.info("Ignored smelting recipe with conflicting input: " + p_addSmeltingRecipe_1_ + " = " + p_addSmeltingRecipe_2_, new Object[0]);
            return;
        }
        this.smeltingList.put(p_addSmeltingRecipe_1_, p_addSmeltingRecipe_2_);
        this.experienceList.put(p_addSmeltingRecipe_2_, Float.valueOf(p_addSmeltingRecipe_3_));
    }

    public ItemStack getSmeltingResult(ItemStack p_getSmeltingResult_1_) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!this.compareItemStacks(p_getSmeltingResult_1_, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.EMPTY;
    }

    private boolean compareItemStacks(ItemStack p_compareItemStacks_1_, ItemStack p_compareItemStacks_2_) {
        return p_compareItemStacks_2_.getItem() == p_compareItemStacks_1_.getItem() && (p_compareItemStacks_2_.getMetadata() == Short.MAX_VALUE || p_compareItemStacks_2_.getMetadata() == p_compareItemStacks_1_.getMetadata());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float getSmeltingExperience(ItemStack p_getSmeltingExperience_1_) {
        float ret = p_getSmeltingExperience_1_.getItem().getSmeltingExperience(p_getSmeltingExperience_1_);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(p_getSmeltingExperience_1_, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

