/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesBanners {
    void addRecipes(CraftingManager p_addRecipes_1_) {
        for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
            p_addRecipes_1_.addRecipe(ItemBanner.makeBanner(enumdyecolor, null), "###", "###", " | ", Character.valueOf('#'), new ItemStack(Blocks.WOOL, 1, enumdyecolor.getMetadata()), Character.valueOf('|'), Items.STICK);
        }
        p_addRecipes_1_.addRecipe(new RecipeDuplicatePattern());
        p_addRecipes_1_.addRecipe(new RecipeAddPattern());
    }

    public static class RecipeDuplicatePattern
    implements IRecipe {
        private RecipeDuplicatePattern() {
        }

        @Override
        public boolean matches(InventoryCrafting p_matches_1_, World p_matches_2_) {
            ItemStack itemstack = ItemStack.EMPTY;
            ItemStack itemstack1 = ItemStack.EMPTY;
            for (int i = 0; i < p_matches_1_.getSizeInventory(); ++i) {
                boolean flag;
                ItemStack itemstack2 = p_matches_1_.getStackInSlot(i);
                if (itemstack2.isEmpty()) continue;
                if (itemstack2.getItem() != Items.BANNER) {
                    return false;
                }
                if (!itemstack.isEmpty() && !itemstack1.isEmpty()) {
                    return false;
                }
                EnumDyeColor enumdyecolor = ItemBanner.getBaseColor(itemstack2);
                boolean bl = flag = TileEntityBanner.getPatterns(itemstack2) > 0;
                if (!itemstack.isEmpty()) {
                    if (flag) {
                        return false;
                    }
                    if (enumdyecolor != ItemBanner.getBaseColor(itemstack)) {
                        return false;
                    }
                    itemstack1 = itemstack2;
                    continue;
                }
                if (!itemstack1.isEmpty()) {
                    if (!flag) {
                        return false;
                    }
                    if (enumdyecolor != ItemBanner.getBaseColor(itemstack1)) {
                        return false;
                    }
                    itemstack = itemstack2;
                    continue;
                }
                if (flag) {
                    itemstack = itemstack2;
                    continue;
                }
                itemstack1 = itemstack2;
            }
            return !itemstack.isEmpty() && !itemstack1.isEmpty();
        }

        @Override
        public ItemStack getCraftingResult(InventoryCrafting p_getCraftingResult_1_) {
            for (int i = 0; i < p_getCraftingResult_1_.getSizeInventory(); ++i) {
                ItemStack itemstack = p_getCraftingResult_1_.getStackInSlot(i);
                if (itemstack.isEmpty() || TileEntityBanner.getPatterns(itemstack) <= 0) continue;
                ItemStack itemstack1 = itemstack.copy();
                itemstack1.setCount(1);
                return itemstack1;
            }
            return ItemStack.EMPTY;
        }

        @Override
        public int getRecipeSize() {
            return 2;
        }

        @Override
        public ItemStack getRecipeOutput() {
            return ItemStack.EMPTY;
        }

        @Override
        public NonNullList<ItemStack> getRemainingItems(InventoryCrafting p_getRemainingItems_1_) {
            NonNullList<ItemStack> nonnulllist = NonNullList.withSize(p_getRemainingItems_1_.getSizeInventory(), ItemStack.EMPTY);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack itemstack = p_getRemainingItems_1_.getStackInSlot(i);
                if (itemstack.isEmpty()) continue;
                if (itemstack.getItem().hasContainerItem(itemstack)) {
                    nonnulllist.set(i, ForgeHooks.getContainerItem(itemstack));
                    continue;
                }
                if (!itemstack.hasTagCompound() || TileEntityBanner.getPatterns(itemstack) <= 0) continue;
                ItemStack itemstack1 = itemstack.copy();
                itemstack1.setCount(1);
                nonnulllist.set(i, itemstack1);
            }
            return nonnulllist;
        }
    }

    public static class RecipeAddPattern
    implements IRecipe {
        private static String[] colors = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        private static List<ItemStack>[] colored = new List[colors.length];
        private static List<ItemStack> dyes;
        private static boolean hasInit;

        private RecipeAddPattern() {
        }

        @Override
        public boolean matches(InventoryCrafting p_matches_1_, World p_matches_2_) {
            boolean flag = false;
            for (int i = 0; i < p_matches_1_.getSizeInventory(); ++i) {
                ItemStack itemstack = p_matches_1_.getStackInSlot(i);
                if (itemstack.getItem() != Items.BANNER) continue;
                if (flag) {
                    return false;
                }
                if (TileEntityBanner.getPatterns(itemstack) >= 6) {
                    return false;
                }
                flag = true;
            }
            if (!flag) {
                return false;
            }
            return this.matchPatterns(p_matches_1_) != null;
        }

        @Override
        public ItemStack getCraftingResult(InventoryCrafting p_getCraftingResult_1_) {
            BannerPattern bannerpattern;
            ItemStack itemstack = ItemStack.EMPTY;
            for (int i = 0; i < p_getCraftingResult_1_.getSizeInventory(); ++i) {
                ItemStack itemstack1 = p_getCraftingResult_1_.getStackInSlot(i);
                if (itemstack1.isEmpty() || itemstack1.getItem() != Items.BANNER) continue;
                itemstack = itemstack1.copy();
                itemstack.setCount(1);
                break;
            }
            if ((bannerpattern = this.matchPatterns(p_getCraftingResult_1_)) != null) {
                NBTTagList nbttaglist;
                NBTTagCompound nbttagcompound1;
                int k = 0;
                for (int j = 0; j < p_getCraftingResult_1_.getSizeInventory(); ++j) {
                    ItemStack itemstack2 = p_getCraftingResult_1_.getStackInSlot(j);
                    int color = this.getColor(itemstack2);
                    if (color == -1) continue;
                    k = color;
                    break;
                }
                if ((nbttagcompound1 = itemstack.getOrCreateSubCompound("BlockEntityTag")).hasKey("Patterns", 9)) {
                    nbttaglist = nbttagcompound1.getTagList("Patterns", 10);
                } else {
                    nbttaglist = new NBTTagList();
                    nbttagcompound1.setTag("Patterns", nbttaglist);
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.setString("Pattern", bannerpattern.getHashname());
                nbttagcompound.setInteger("Color", k);
                nbttaglist.appendTag(nbttagcompound);
            }
            return itemstack;
        }

        @Override
        public int getRecipeSize() {
            return 10;
        }

        @Override
        public ItemStack getRecipeOutput() {
            return ItemStack.EMPTY;
        }

        @Override
        public NonNullList<ItemStack> getRemainingItems(InventoryCrafting p_getRemainingItems_1_) {
            NonNullList<ItemStack> nonnulllist = NonNullList.withSize(p_getRemainingItems_1_.getSizeInventory(), ItemStack.EMPTY);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack itemstack = p_getRemainingItems_1_.getStackInSlot(i);
                nonnulllist.set(i, ForgeHooks.getContainerItem(itemstack));
            }
            return nonnulllist;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        private BannerPattern matchPatterns(InventoryCrafting p_matchPatterns_1_) {
            BannerPattern[] bannerPatternArray = BannerPattern.values();
            int n = bannerPatternArray.length;
            int n2 = 0;
            while (true) {
                block12: {
                    boolean flag;
                    BannerPattern bannerpattern;
                    block17: {
                        int j;
                        block16: {
                            boolean flag2;
                            boolean flag1;
                            block14: {
                                block15: {
                                    block13: {
                                        if (n2 >= n) {
                                            return null;
                                        }
                                        bannerpattern = bannerPatternArray[n2];
                                        if (!bannerpattern.hasPattern()) break block12;
                                        flag = true;
                                        if (!bannerpattern.hasPatternItem()) break block13;
                                        flag1 = false;
                                        flag2 = false;
                                        break block14;
                                    }
                                    if (p_matchPatterns_1_.getSizeInventory() != bannerpattern.getPatterns().length * bannerpattern.getPatterns()[0].length()) break block15;
                                    j = -1;
                                    break block16;
                                }
                                flag = false;
                                break block17;
                            }
                            for (int i = 0; i < p_matchPatterns_1_.getSizeInventory() && flag; ++i) {
                                ItemStack itemstack = p_matchPatterns_1_.getStackInSlot(i);
                                if (itemstack.isEmpty() || itemstack.getItem() == Items.BANNER) continue;
                                if (this.isDye(itemstack)) {
                                    if (flag2) {
                                        flag = false;
                                        break;
                                    }
                                    flag2 = true;
                                    continue;
                                }
                                if (flag1 || !itemstack.isItemEqual(bannerpattern.getPatternItem())) {
                                    flag = false;
                                    break;
                                }
                                flag1 = true;
                            }
                            if (flag1 && flag2) break block17;
                            flag = false;
                            break block17;
                        }
                        for (int k = 0; k < p_matchPatterns_1_.getSizeInventory() && flag; ++k) {
                            int l = k / 3;
                            int i1 = k % 3;
                            ItemStack itemstack1 = p_matchPatterns_1_.getStackInSlot(k);
                            if (!itemstack1.isEmpty() && itemstack1.getItem() != Items.BANNER) {
                                if (!this.isDye(itemstack1)) {
                                    flag = false;
                                    break;
                                }
                                if (j != -1 && j != itemstack1.getMetadata()) {
                                    flag = false;
                                    break;
                                }
                                if (bannerpattern.getPatterns()[l].charAt(i1) == ' ') {
                                    flag = false;
                                    break;
                                }
                                j = itemstack1.getMetadata();
                                continue;
                            }
                            if (bannerpattern.getPatterns()[l].charAt(i1) == ' ') continue;
                            flag = false;
                            break;
                        }
                    }
                    if (flag) {
                        return bannerpattern;
                    }
                }
                ++n2;
            }
        }

        private static void init() {
            if (hasInit) {
                return;
            }
            for (int x = 0; x < colors.length; ++x) {
                RecipeAddPattern.colored[x] = OreDictionary.getOres("dye" + colors[x]);
            }
            dyes = OreDictionary.getOres("dye");
            hasInit = true;
        }

        private boolean isDye(ItemStack p_isDye_1_) {
            RecipeAddPattern.init();
            for (ItemStack ore : dyes) {
                if (!OreDictionary.itemMatches(ore, p_isDye_1_, false)) continue;
                return true;
            }
            return false;
        }

        private int getColor(ItemStack p_getColor_1_) {
            RecipeAddPattern.init();
            if (p_getColor_1_ == null) {
                return -1;
            }
            for (int x = 0; x < colored.length; ++x) {
                for (ItemStack ore : colored[x]) {
                    if (!OreDictionary.itemMatches(ore, p_getColor_1_, true)) continue;
                    return x;
                }
            }
            return -1;
        }

        static {
            hasInit = false;
        }
    }
}

