/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class RecipesMapCloning
implements IRecipe {
    @Override
    public boolean matches(InventoryCrafting p_matches_1_, World p_matches_2_) {
        int i = 0;
        ItemStack itemstack = ItemStack.EMPTY;
        for (int j = 0; j < p_matches_1_.getSizeInventory(); ++j) {
            ItemStack itemstack1 = p_matches_1_.getStackInSlot(j);
            if (itemstack1.isEmpty()) continue;
            if (itemstack1.getItem() == Items.FILLED_MAP) {
                if (!itemstack.isEmpty()) {
                    return false;
                }
                itemstack = itemstack1;
                continue;
            }
            if (itemstack1.getItem() != Items.MAP) {
                return false;
            }
            ++i;
        }
        return !itemstack.isEmpty() && i > 0;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting p_getCraftingResult_1_) {
        int i = 0;
        ItemStack itemstack = ItemStack.EMPTY;
        for (int j = 0; j < p_getCraftingResult_1_.getSizeInventory(); ++j) {
            ItemStack itemstack1 = p_getCraftingResult_1_.getStackInSlot(j);
            if (itemstack1.isEmpty()) continue;
            if (itemstack1.getItem() == Items.FILLED_MAP) {
                if (!itemstack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                itemstack = itemstack1;
                continue;
            }
            if (itemstack1.getItem() != Items.MAP) {
                return ItemStack.EMPTY;
            }
            ++i;
        }
        if (!itemstack.isEmpty() && i >= 1) {
            ItemStack itemstack2 = new ItemStack(Items.FILLED_MAP, i + 1, itemstack.getMetadata());
            if (itemstack.hasDisplayName()) {
                itemstack2.setStackDisplayName(itemstack.getDisplayName());
            }
            if (itemstack.hasTagCompound()) {
                itemstack2.setTagCompound(itemstack.getTagCompound());
            }
            return itemstack2;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public int getRecipeSize() {
        return 9;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return ItemStack.EMPTY;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting p_getRemainingItems_1_) {
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(p_getRemainingItems_1_.getSizeInventory(), ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = p_getRemainingItems_1_.getStackInSlot(i);
            nonnulllist.set(i, ForgeHooks.getContainerItem(itemstack));
        }
        return nonnulllist;
    }
}

