/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;

public class RecipesMapExtending
extends ShapedRecipes {
    public RecipesMapExtending() {
        super(3, 3, new ItemStack[]{new ItemStack(Items.PAPER), new ItemStack(Items.PAPER), new ItemStack(Items.PAPER), new ItemStack(Items.PAPER), new ItemStack(Items.FILLED_MAP, 1, Short.MAX_VALUE), new ItemStack(Items.PAPER), new ItemStack(Items.PAPER), new ItemStack(Items.PAPER), new ItemStack(Items.PAPER)}, new ItemStack(Items.MAP));
    }

    @Override
    public boolean matches(InventoryCrafting p_matches_1_, World p_matches_2_) {
        if (!super.matches(p_matches_1_, p_matches_2_)) {
            return false;
        }
        ItemStack lvt_3_1_ = ItemStack.EMPTY;
        for (int lvt_4_1_ = 0; lvt_4_1_ < p_matches_1_.getSizeInventory() && lvt_3_1_.isEmpty(); ++lvt_4_1_) {
            ItemStack lvt_5_1_ = p_matches_1_.getStackInSlot(lvt_4_1_);
            if (lvt_5_1_.getItem() != Items.FILLED_MAP) continue;
            lvt_3_1_ = lvt_5_1_;
        }
        if (lvt_3_1_.isEmpty()) {
            return false;
        }
        MapData lvt_4_2_ = Items.FILLED_MAP.getMapData(lvt_3_1_, p_matches_2_);
        if (lvt_4_2_ == null) {
            return false;
        }
        if (this.isExplorationMap(lvt_4_2_)) {
            return false;
        }
        return lvt_4_2_.scale < 4;
    }

    private boolean isExplorationMap(MapData p_isExplorationMap_1_) {
        if (p_isExplorationMap_1_.mapDecorations != null) {
            for (MapDecoration lvt_3_1_ : p_isExplorationMap_1_.mapDecorations.values()) {
                if (lvt_3_1_.getType() != MapDecoration.Type.MANSION && lvt_3_1_.getType() != MapDecoration.Type.MONUMENT) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting p_getCraftingResult_1_) {
        ItemStack lvt_2_1_ = ItemStack.EMPTY;
        for (int lvt_3_1_ = 0; lvt_3_1_ < p_getCraftingResult_1_.getSizeInventory() && lvt_2_1_.isEmpty(); ++lvt_3_1_) {
            ItemStack lvt_4_1_ = p_getCraftingResult_1_.getStackInSlot(lvt_3_1_);
            if (lvt_4_1_.getItem() != Items.FILLED_MAP) continue;
            lvt_2_1_ = lvt_4_1_;
        }
        lvt_2_1_ = lvt_2_1_.copy();
        lvt_2_1_.setCount(1);
        if (lvt_2_1_.getTagCompound() == null) {
            lvt_2_1_.setTagCompound(new NBTTagCompound());
        }
        lvt_2_1_.getTagCompound().setInteger("map_scale_direction", 1);
        return lvt_2_1_;
    }
}

