/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ShapedRecipes
implements IRecipe {
    public final int recipeWidth;
    public final int recipeHeight;
    public final ItemStack[] recipeItems;
    private final ItemStack recipeOutput;
    private boolean copyIngredientNBT;

    public ShapedRecipes(int p_i1917_1_, int p_i1917_2_, ItemStack[] p_i1917_3_, ItemStack p_i1917_4_) {
        this.recipeWidth = p_i1917_1_;
        this.recipeHeight = p_i1917_2_;
        this.recipeItems = p_i1917_3_;
        for (int i = 0; i < this.recipeItems.length; ++i) {
            if (this.recipeItems[i] != null) continue;
            this.recipeItems[i] = ItemStack.EMPTY;
        }
        this.recipeOutput = p_i1917_4_;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting p_getRemainingItems_1_) {
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(p_getRemainingItems_1_.getSizeInventory(), ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = p_getRemainingItems_1_.getStackInSlot(i);
            nonnulllist.set(i, ForgeHooks.getContainerItem(itemstack));
        }
        return nonnulllist;
    }

    @Override
    public boolean matches(InventoryCrafting p_matches_1_, World p_matches_2_) {
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.checkMatch(p_matches_1_, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(p_matches_1_, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting p_checkMatch_1_, int p_checkMatch_2_, int p_checkMatch_3_, boolean p_checkMatch_4_) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack1;
                int k = i - p_checkMatch_2_;
                int l = j - p_checkMatch_3_;
                ItemStack itemstack = ItemStack.EMPTY;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    itemstack = p_checkMatch_4_ ? this.recipeItems[this.recipeWidth - k - 1 + l * this.recipeWidth] : this.recipeItems[k + l * this.recipeWidth];
                }
                if ((itemstack1 = p_checkMatch_1_.getStackInRowAndColumn(i, j)).isEmpty() && itemstack.isEmpty()) continue;
                if (itemstack1.isEmpty() != itemstack.isEmpty()) {
                    return false;
                }
                if (itemstack.getItem() != itemstack1.getItem()) {
                    return false;
                }
                if (itemstack.getMetadata() == Short.MAX_VALUE || itemstack.getMetadata() == itemstack1.getMetadata()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting p_getCraftingResult_1_) {
        ItemStack itemstack = this.getRecipeOutput().copy();
        if (this.copyIngredientNBT) {
            for (int i = 0; i < p_getCraftingResult_1_.getSizeInventory(); ++i) {
                ItemStack itemstack1 = p_getCraftingResult_1_.getStackInSlot(i);
                if (itemstack1.isEmpty() || !itemstack1.hasTagCompound()) continue;
                itemstack.setTagCompound(itemstack1.getTagCompound().copy());
            }
        }
        return itemstack;
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }
}

