/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ShapelessRecipes
implements IRecipe {
    private final ItemStack recipeOutput;
    public final List<ItemStack> recipeItems;

    public ShapelessRecipes(ItemStack p_i1918_1_, List<ItemStack> p_i1918_2_) {
        this.recipeOutput = p_i1918_1_;
        this.recipeItems = p_i1918_2_;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting p_getRemainingItems_1_) {
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(p_getRemainingItems_1_.getSizeInventory(), ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = p_getRemainingItems_1_.getStackInSlot(i);
            nonnulllist.set(i, ForgeHooks.getContainerItem(itemstack));
        }
        return nonnulllist;
    }

    @Override
    public boolean matches(InventoryCrafting p_matches_1_, World p_matches_2_) {
        ArrayList list = Lists.newArrayList(this.recipeItems);
        for (int i = 0; i < p_matches_1_.getHeight(); ++i) {
            for (int j = 0; j < p_matches_1_.getWidth(); ++j) {
                ItemStack itemstack = p_matches_1_.getStackInRowAndColumn(j, i);
                if (itemstack.isEmpty()) continue;
                boolean flag = false;
                for (ItemStack itemstack1 : list) {
                    if (itemstack.getItem() != itemstack1.getItem() || itemstack1.getMetadata() != Short.MAX_VALUE && itemstack.getMetadata() != itemstack1.getMetadata()) continue;
                    flag = true;
                    list.remove(itemstack1);
                    break;
                }
                if (flag) continue;
                return false;
            }
        }
        return list.isEmpty();
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting p_getCraftingResult_1_) {
        return this.recipeOutput.copy();
    }

    @Override
    public int getRecipeSize() {
        return this.recipeItems.size();
    }
}

