/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ShulkerBoxRecipes {
    void addRecipes(CraftingManager p_addRecipes_1_) {
        p_addRecipes_1_.addRecipe(BlockShulkerBox.getColoredItemStack(EntityShulker.DEFAULT_COLOR), "-", "#", "-", Character.valueOf('-'), Items.SHULKER_SHELL, Character.valueOf('#'), Blocks.CHEST);
        p_addRecipes_1_.addRecipe(new ShulkerBoxColoring());
    }

    static class ShulkerBoxColoring
    implements IRecipe {
        private ShulkerBoxColoring() {
        }

        @Override
        public boolean matches(InventoryCrafting p_matches_1_, World p_matches_2_) {
            int lvt_3_1_ = 0;
            int lvt_4_1_ = 0;
            for (int lvt_5_1_ = 0; lvt_5_1_ < p_matches_1_.getSizeInventory(); ++lvt_5_1_) {
                ItemStack lvt_6_1_ = p_matches_1_.getStackInSlot(lvt_5_1_);
                if (lvt_6_1_.isEmpty()) continue;
                if (Block.getBlockFromItem(lvt_6_1_.getItem()) instanceof BlockShulkerBox) {
                    ++lvt_3_1_;
                } else if (lvt_6_1_.getItem() == Items.DYE) {
                    ++lvt_4_1_;
                } else {
                    return false;
                }
                if (lvt_4_1_ <= 1 && lvt_3_1_ <= 1) continue;
                return false;
            }
            return lvt_3_1_ == 1 && lvt_4_1_ == 1;
        }

        @Override
        public ItemStack getCraftingResult(InventoryCrafting p_getCraftingResult_1_) {
            ItemStack lvt_2_1_ = ItemStack.EMPTY;
            ItemStack lvt_3_1_ = ItemStack.EMPTY;
            for (int lvt_4_1_ = 0; lvt_4_1_ < p_getCraftingResult_1_.getSizeInventory(); ++lvt_4_1_) {
                ItemStack lvt_5_1_ = p_getCraftingResult_1_.getStackInSlot(lvt_4_1_);
                if (lvt_5_1_.isEmpty()) continue;
                if (Block.getBlockFromItem(lvt_5_1_.getItem()) instanceof BlockShulkerBox) {
                    lvt_2_1_ = lvt_5_1_;
                    continue;
                }
                if (lvt_5_1_.getItem() != Items.DYE) continue;
                lvt_3_1_ = lvt_5_1_;
            }
            ItemStack lvt_4_2_ = BlockShulkerBox.getColoredItemStack(EnumDyeColor.byDyeDamage(lvt_3_1_.getMetadata()));
            if (lvt_2_1_.hasTagCompound()) {
                lvt_4_2_.setTagCompound(lvt_2_1_.getTagCompound().copy());
            }
            return lvt_4_2_;
        }

        @Override
        public int getRecipeSize() {
            return 10;
        }

        @Override
        public ItemStack getRecipeOutput() {
            return ItemStack.EMPTY;
        }

        @Override
        public NonNullList<ItemStack> getRemainingItems(InventoryCrafting p_getRemainingItems_1_) {
            NonNullList<ItemStack> lvt_2_1_ = NonNullList.withSize(p_getRemainingItems_1_.getSizeInventory(), ItemStack.EMPTY);
            for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_.size(); ++lvt_3_1_) {
                ItemStack lvt_4_1_ = p_getRemainingItems_1_.getStackInSlot(lvt_3_1_);
                if (!lvt_4_1_.getItem().hasContainerItem()) continue;
                lvt_2_1_.set(lvt_3_1_, new ItemStack(lvt_4_1_.getItem().getContainerItem()));
            }
            return lvt_2_1_;
        }
    }
}

