/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.util.ReportedException;

public class CompressedStreamTools {
    public static NBTTagCompound readCompressed(InputStream p_readCompressed_0_) throws IOException {
        NBTTagCompound nbttagcompound;
        DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(p_readCompressed_0_)));
        try {
            nbttagcompound = CompressedStreamTools.read(datainputstream, NBTSizeTracker.INFINITE);
        }
        finally {
            datainputstream.close();
        }
        return nbttagcompound;
    }

    public static void writeCompressed(NBTTagCompound p_writeCompressed_0_, OutputStream p_writeCompressed_1_) throws IOException {
        DataOutputStream dataoutputstream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(p_writeCompressed_1_)));
        try {
            CompressedStreamTools.write(p_writeCompressed_0_, dataoutputstream);
        }
        finally {
            dataoutputstream.close();
        }
    }

    public static void safeWrite(NBTTagCompound p_safeWrite_0_, File p_safeWrite_1_) throws IOException {
        File file1 = new File(p_safeWrite_1_.getAbsolutePath() + "_tmp");
        if (file1.exists()) {
            file1.delete();
        }
        CompressedStreamTools.write(p_safeWrite_0_, file1);
        if (p_safeWrite_1_.exists()) {
            p_safeWrite_1_.delete();
        }
        if (p_safeWrite_1_.exists()) {
            throw new IOException("Failed to delete " + p_safeWrite_1_);
        }
        file1.renameTo(p_safeWrite_1_);
    }

    public static NBTTagCompound read(DataInputStream p_read_0_) throws IOException {
        return CompressedStreamTools.read(p_read_0_, NBTSizeTracker.INFINITE);
    }

    public static NBTTagCompound read(DataInput p_read_0_, NBTSizeTracker p_read_1_) throws IOException {
        NBTBase nbtbase = CompressedStreamTools.read(p_read_0_, 0, p_read_1_);
        if (nbtbase instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(NBTTagCompound p_write_0_, DataOutput p_write_1_) throws IOException {
        CompressedStreamTools.writeTag(p_write_0_, p_write_1_);
    }

    private static void writeTag(NBTBase p_writeTag_0_, DataOutput p_writeTag_1_) throws IOException {
        p_writeTag_1_.writeByte(p_writeTag_0_.getId());
        if (p_writeTag_0_.getId() != 0) {
            p_writeTag_1_.writeUTF("");
            p_writeTag_0_.write(p_writeTag_1_);
        }
    }

    private static NBTBase read(DataInput p_read_0_, int p_read_1_, NBTSizeTracker p_read_2_) throws IOException {
        byte b0 = p_read_0_.readByte();
        p_read_2_.read(8L);
        if (b0 == 0) {
            return new NBTTagEnd();
        }
        NBTSizeTracker.readUTF(p_read_2_, p_read_0_.readUTF());
        p_read_2_.read(32L);
        NBTBase nbtbase = NBTBase.createNewByType(b0);
        try {
            nbtbase.read(p_read_0_, p_read_1_, p_read_2_);
            return nbtbase;
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.makeCrashReport(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("NBT Tag");
            crashreportcategory.addCrashSection("Tag name", "[UNNAMED TAG]");
            crashreportcategory.addCrashSection("Tag type", b0);
            throw new ReportedException(crashreport);
        }
    }

    public static void write(NBTTagCompound p_write_0_, File p_write_1_) throws IOException {
        DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(p_write_1_));
        try {
            CompressedStreamTools.write(p_write_0_, dataoutputstream);
        }
        finally {
            dataoutputstream.close();
        }
    }

    public static NBTTagCompound read(File p_read_0_) throws IOException {
        NBTTagCompound nbttagcompound;
        if (!p_read_0_.exists()) {
            return null;
        }
        DataInputStream datainputstream = new DataInputStream(new FileInputStream(p_read_0_));
        try {
            nbttagcompound = CompressedStreamTools.read(datainputstream, NBTSizeTracker.INFINITE);
        }
        finally {
            datainputstream.close();
        }
        return nbttagcompound;
    }
}

