/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Stack;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonToNBT {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern INT_ARRAY_MATCHER = Pattern.compile("\\[[-+\\d|,\\s]+\\]");

    public static NBTTagCompound getTagFromJson(String p_getTagFromJson_0_) throws NBTException {
        if (!(p_getTagFromJson_0_ = p_getTagFromJson_0_.trim()).startsWith("{")) {
            throw new NBTException("Invalid tag encountered, expected '{' as first char.");
        }
        if (JsonToNBT.topTagsCount(p_getTagFromJson_0_) != 1) {
            throw new NBTException("Encountered multiple top tags, only one expected");
        }
        return (NBTTagCompound)JsonToNBT.nameValueToNBT("tag", p_getTagFromJson_0_).parse();
    }

    static int topTagsCount(String p_topTagsCount_0_) throws NBTException {
        int lvt_1_1_ = 0;
        boolean lvt_2_1_ = false;
        Stack<Character> lvt_3_1_ = new Stack<Character>();
        for (int lvt_4_1_ = 0; lvt_4_1_ < p_topTagsCount_0_.length(); ++lvt_4_1_) {
            char lvt_5_1_ = p_topTagsCount_0_.charAt(lvt_4_1_);
            if (lvt_5_1_ == '\"') {
                if (JsonToNBT.isCharEscaped(p_topTagsCount_0_, lvt_4_1_)) {
                    if (lvt_2_1_) continue;
                    throw new NBTException("Illegal use of \\\": " + p_topTagsCount_0_);
                }
                lvt_2_1_ = !lvt_2_1_;
                continue;
            }
            if (lvt_2_1_) continue;
            if (lvt_5_1_ == '{' || lvt_5_1_ == '[') {
                if (lvt_3_1_.isEmpty()) {
                    ++lvt_1_1_;
                }
                lvt_3_1_.push(Character.valueOf(lvt_5_1_));
                continue;
            }
            if (lvt_5_1_ == '}' && (lvt_3_1_.isEmpty() || ((Character)lvt_3_1_.pop()).charValue() != '{')) {
                throw new NBTException("Unbalanced curly brackets {}: " + p_topTagsCount_0_);
            }
            if (lvt_5_1_ != ']' || !lvt_3_1_.isEmpty() && ((Character)lvt_3_1_.pop()).charValue() == '[') continue;
            throw new NBTException("Unbalanced square brackets []: " + p_topTagsCount_0_);
        }
        if (lvt_2_1_) {
            throw new NBTException("Unbalanced quotation: " + p_topTagsCount_0_);
        }
        if (!lvt_3_1_.isEmpty()) {
            throw new NBTException("Unbalanced brackets: " + p_topTagsCount_0_);
        }
        if (lvt_1_1_ == 0 && !p_topTagsCount_0_.isEmpty()) {
            lvt_1_1_ = 1;
        }
        return lvt_1_1_;
    }

    static Any joinStrToNBT(String ... p_joinStrToNBT_0_) throws NBTException {
        return JsonToNBT.nameValueToNBT(p_joinStrToNBT_0_[0], p_joinStrToNBT_0_[1]);
    }

    static Any nameValueToNBT(String p_nameValueToNBT_0_, String p_nameValueToNBT_1_) throws NBTException {
        if ((p_nameValueToNBT_1_ = p_nameValueToNBT_1_.trim()).startsWith("{")) {
            p_nameValueToNBT_1_ = p_nameValueToNBT_1_.substring(1, p_nameValueToNBT_1_.length() - 1);
            Compound lvt_2_1_ = new Compound(p_nameValueToNBT_0_);
            while (p_nameValueToNBT_1_.length() > 0) {
                String lvt_3_1_ = JsonToNBT.nextNameValuePair(p_nameValueToNBT_1_, true);
                if (lvt_3_1_.length() > 0) {
                    boolean lvt_4_1_ = false;
                    lvt_2_1_.tagList.add(JsonToNBT.getTagFromNameValue(lvt_3_1_, false));
                }
                if (p_nameValueToNBT_1_.length() < lvt_3_1_.length() + 1) break;
                char lvt_4_2_ = p_nameValueToNBT_1_.charAt(lvt_3_1_.length());
                if (lvt_4_2_ != ',' && lvt_4_2_ != '{' && lvt_4_2_ != '}' && lvt_4_2_ != '[' && lvt_4_2_ != ']') {
                    throw new NBTException("Unexpected token '" + lvt_4_2_ + "' at: " + p_nameValueToNBT_1_.substring(lvt_3_1_.length()));
                }
                p_nameValueToNBT_1_ = p_nameValueToNBT_1_.substring(lvt_3_1_.length() + 1);
            }
            return lvt_2_1_;
        }
        if (p_nameValueToNBT_1_.startsWith("[") && !INT_ARRAY_MATCHER.matcher(p_nameValueToNBT_1_).matches()) {
            p_nameValueToNBT_1_ = p_nameValueToNBT_1_.substring(1, p_nameValueToNBT_1_.length() - 1);
            List lvt_2_2_ = new List(p_nameValueToNBT_0_);
            while (p_nameValueToNBT_1_.length() > 0) {
                String lvt_3_2_ = JsonToNBT.nextNameValuePair(p_nameValueToNBT_1_, false);
                if (lvt_3_2_.length() > 0) {
                    boolean lvt_4_3_ = true;
                    lvt_2_2_.tagList.add(JsonToNBT.getTagFromNameValue(lvt_3_2_, true));
                }
                if (p_nameValueToNBT_1_.length() < lvt_3_2_.length() + 1) break;
                char lvt_4_4_ = p_nameValueToNBT_1_.charAt(lvt_3_2_.length());
                if (lvt_4_4_ != ',' && lvt_4_4_ != '{' && lvt_4_4_ != '}' && lvt_4_4_ != '[' && lvt_4_4_ != ']') {
                    throw new NBTException("Unexpected token '" + lvt_4_4_ + "' at: " + p_nameValueToNBT_1_.substring(lvt_3_2_.length()));
                }
                p_nameValueToNBT_1_ = p_nameValueToNBT_1_.substring(lvt_3_2_.length() + 1);
            }
            return lvt_2_2_;
        }
        return new Primitive(p_nameValueToNBT_0_, p_nameValueToNBT_1_);
    }

    private static Any getTagFromNameValue(String p_getTagFromNameValue_0_, boolean p_getTagFromNameValue_1_) throws NBTException {
        String lvt_2_1_ = JsonToNBT.locateName(p_getTagFromNameValue_0_, p_getTagFromNameValue_1_);
        String lvt_3_1_ = JsonToNBT.locateValue(p_getTagFromNameValue_0_, p_getTagFromNameValue_1_);
        return JsonToNBT.joinStrToNBT(lvt_2_1_, lvt_3_1_);
    }

    private static String nextNameValuePair(String p_nextNameValuePair_0_, boolean p_nextNameValuePair_1_) throws NBTException {
        int lvt_2_1_ = JsonToNBT.getNextCharIndex(p_nextNameValuePair_0_, ':');
        int lvt_3_1_ = JsonToNBT.getNextCharIndex(p_nextNameValuePair_0_, ',');
        if (p_nextNameValuePair_1_) {
            if (lvt_2_1_ == -1) {
                throw new NBTException("Unable to locate name/value separator for string: " + p_nextNameValuePair_0_);
            }
            if (lvt_3_1_ != -1 && lvt_3_1_ < lvt_2_1_) {
                throw new NBTException("Name error at: " + p_nextNameValuePair_0_);
            }
        } else if (lvt_2_1_ == -1 || lvt_2_1_ > lvt_3_1_) {
            lvt_2_1_ = -1;
        }
        return JsonToNBT.locateValueAt(p_nextNameValuePair_0_, lvt_2_1_);
    }

    private static String locateValueAt(String p_locateValueAt_0_, int p_locateValueAt_1_) throws NBTException {
        int lvt_3_1_;
        Stack<Character> lvt_2_1_ = new Stack<Character>();
        boolean lvt_4_1_ = false;
        boolean lvt_5_1_ = false;
        boolean lvt_6_1_ = false;
        int lvt_7_1_ = 0;
        for (lvt_3_1_ = p_locateValueAt_1_ + 1; lvt_3_1_ < p_locateValueAt_0_.length(); ++lvt_3_1_) {
            char lvt_8_1_ = p_locateValueAt_0_.charAt(lvt_3_1_);
            if (lvt_8_1_ == '\"') {
                if (JsonToNBT.isCharEscaped(p_locateValueAt_0_, lvt_3_1_)) {
                    if (!lvt_4_1_) {
                        throw new NBTException("Illegal use of \\\": " + p_locateValueAt_0_);
                    }
                } else {
                    boolean bl = lvt_4_1_ = !lvt_4_1_;
                    if (lvt_4_1_ && !lvt_6_1_) {
                        lvt_5_1_ = true;
                    }
                    if (!lvt_4_1_) {
                        lvt_7_1_ = lvt_3_1_;
                    }
                }
            } else if (!lvt_4_1_) {
                if (lvt_8_1_ == '{' || lvt_8_1_ == '[') {
                    lvt_2_1_.push(Character.valueOf(lvt_8_1_));
                } else {
                    if (lvt_8_1_ == '}' && (lvt_2_1_.isEmpty() || ((Character)lvt_2_1_.pop()).charValue() != '{')) {
                        throw new NBTException("Unbalanced curly brackets {}: " + p_locateValueAt_0_);
                    }
                    if (lvt_8_1_ == ']' && (lvt_2_1_.isEmpty() || ((Character)lvt_2_1_.pop()).charValue() != '[')) {
                        throw new NBTException("Unbalanced square brackets []: " + p_locateValueAt_0_);
                    }
                    if (lvt_8_1_ == ',' && lvt_2_1_.isEmpty()) {
                        return p_locateValueAt_0_.substring(0, lvt_3_1_);
                    }
                }
            }
            if (Character.isWhitespace(lvt_8_1_)) continue;
            if (!lvt_4_1_ && lvt_5_1_ && lvt_7_1_ != lvt_3_1_) {
                return p_locateValueAt_0_.substring(0, lvt_7_1_ + 1);
            }
            lvt_6_1_ = true;
        }
        return p_locateValueAt_0_.substring(0, lvt_3_1_);
    }

    private static String locateName(String p_locateName_0_, boolean p_locateName_1_) throws NBTException {
        if (p_locateName_1_ && ((p_locateName_0_ = p_locateName_0_.trim()).startsWith("{") || p_locateName_0_.startsWith("["))) {
            return "";
        }
        int lvt_2_1_ = JsonToNBT.getNextCharIndex(p_locateName_0_, ':');
        if (lvt_2_1_ == -1) {
            if (p_locateName_1_) {
                return "";
            }
            throw new NBTException("Unable to locate name/value separator for string: " + p_locateName_0_);
        }
        return p_locateName_0_.substring(0, lvt_2_1_).trim();
    }

    private static String locateValue(String p_locateValue_0_, boolean p_locateValue_1_) throws NBTException {
        if (p_locateValue_1_ && ((p_locateValue_0_ = p_locateValue_0_.trim()).startsWith("{") || p_locateValue_0_.startsWith("["))) {
            return p_locateValue_0_;
        }
        int lvt_2_1_ = JsonToNBT.getNextCharIndex(p_locateValue_0_, ':');
        if (lvt_2_1_ == -1) {
            if (p_locateValue_1_) {
                return p_locateValue_0_;
            }
            throw new NBTException("Unable to locate name/value separator for string: " + p_locateValue_0_);
        }
        return p_locateValue_0_.substring(lvt_2_1_ + 1).trim();
    }

    private static int getNextCharIndex(String p_getNextCharIndex_0_, char p_getNextCharIndex_1_) {
        boolean lvt_3_1_ = true;
        for (int lvt_2_1_ = 0; lvt_2_1_ < p_getNextCharIndex_0_.length(); ++lvt_2_1_) {
            char lvt_4_1_ = p_getNextCharIndex_0_.charAt(lvt_2_1_);
            if (lvt_4_1_ == '\"') {
                if (JsonToNBT.isCharEscaped(p_getNextCharIndex_0_, lvt_2_1_)) continue;
                lvt_3_1_ = !lvt_3_1_;
                continue;
            }
            if (!lvt_3_1_) continue;
            if (lvt_4_1_ == p_getNextCharIndex_1_) {
                return lvt_2_1_;
            }
            if (lvt_4_1_ != '{' && lvt_4_1_ != '[') continue;
            return -1;
        }
        return -1;
    }

    private static boolean isCharEscaped(String p_isCharEscaped_0_, int p_isCharEscaped_1_) {
        return p_isCharEscaped_1_ > 0 && p_isCharEscaped_0_.charAt(p_isCharEscaped_1_ - 1) == '\\' && !JsonToNBT.isCharEscaped(p_isCharEscaped_0_, p_isCharEscaped_1_ - 1);
    }

    static class Primitive
    extends Any {
        private static final Pattern DOUBLE = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+[d|D]");
        private static final Pattern FLOAT = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+[f|F]");
        private static final Pattern BYTE = Pattern.compile("[-+]?[0-9]+[b|B]");
        private static final Pattern LONG = Pattern.compile("[-+]?[0-9]+[l|L]");
        private static final Pattern SHORT = Pattern.compile("[-+]?[0-9]+[s|S]");
        private static final Pattern INTEGER = Pattern.compile("[-+]?[0-9]+");
        private static final Pattern DOUBLE_UNTYPED = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+");
        private static final Splitter SPLITTER = Splitter.on((char)',').omitEmptyStrings();
        protected String jsonValue;

        public Primitive(String p_i45139_1_, String p_i45139_2_) {
            this.json = p_i45139_1_;
            this.jsonValue = p_i45139_2_;
        }

        @Override
        public NBTBase parse() throws NBTException {
            try {
                if (DOUBLE.matcher(this.jsonValue).matches()) {
                    return new NBTTagDouble(Double.parseDouble(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (FLOAT.matcher(this.jsonValue).matches()) {
                    return new NBTTagFloat(Float.parseFloat(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (BYTE.matcher(this.jsonValue).matches()) {
                    return new NBTTagByte(Byte.parseByte(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (LONG.matcher(this.jsonValue).matches()) {
                    return new NBTTagLong(Long.parseLong(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (SHORT.matcher(this.jsonValue).matches()) {
                    return new NBTTagShort(Short.parseShort(this.jsonValue.substring(0, this.jsonValue.length() - 1)));
                }
                if (INTEGER.matcher(this.jsonValue).matches()) {
                    return new NBTTagInt(Integer.parseInt(this.jsonValue));
                }
                if (DOUBLE_UNTYPED.matcher(this.jsonValue).matches()) {
                    return new NBTTagDouble(Double.parseDouble(this.jsonValue));
                }
                if ("true".equalsIgnoreCase(this.jsonValue) || "false".equalsIgnoreCase(this.jsonValue)) {
                    return new NBTTagByte(Boolean.parseBoolean(this.jsonValue) ? (byte)1 : 0);
                }
            }
            catch (NumberFormatException lvt_1_1_) {
                this.jsonValue = this.jsonValue.replaceAll("\\\\\"", "\"");
                return new NBTTagString(this.jsonValue);
            }
            if (this.jsonValue.startsWith("[") && this.jsonValue.endsWith("]")) {
                String lvt_1_2_ = this.jsonValue.substring(1, this.jsonValue.length() - 1);
                String[] lvt_2_1_ = (String[])Iterables.toArray((Iterable)SPLITTER.split((CharSequence)lvt_1_2_), String.class);
                try {
                    int[] lvt_3_1_ = new int[lvt_2_1_.length];
                    for (int lvt_4_1_ = 0; lvt_4_1_ < lvt_2_1_.length; ++lvt_4_1_) {
                        lvt_3_1_[lvt_4_1_] = Integer.parseInt(lvt_2_1_[lvt_4_1_].trim());
                    }
                    return new NBTTagIntArray(lvt_3_1_);
                }
                catch (NumberFormatException lvt_3_2_) {
                    return new NBTTagString(this.jsonValue);
                }
            }
            if (this.jsonValue.startsWith("\"") && this.jsonValue.endsWith("\"")) {
                this.jsonValue = this.jsonValue.substring(1, this.jsonValue.length() - 1);
            }
            this.jsonValue = this.jsonValue.replaceAll("\\\\\"", "\"");
            StringBuilder lvt_1_3_ = new StringBuilder();
            for (int lvt_2_2_ = 0; lvt_2_2_ < this.jsonValue.length(); ++lvt_2_2_) {
                if (lvt_2_2_ < this.jsonValue.length() - 1 && this.jsonValue.charAt(lvt_2_2_) == '\\' && this.jsonValue.charAt(lvt_2_2_ + 1) == '\\') {
                    lvt_1_3_.append('\\');
                    ++lvt_2_2_;
                    continue;
                }
                lvt_1_3_.append(this.jsonValue.charAt(lvt_2_2_));
            }
            return new NBTTagString(lvt_1_3_.toString());
        }
    }

    static class List
    extends Any {
        protected java.util.List<Any> tagList = Lists.newArrayList();

        public List(String p_i45138_1_) {
            this.json = p_i45138_1_;
        }

        @Override
        public NBTBase parse() throws NBTException {
            NBTTagList lvt_1_1_ = new NBTTagList();
            for (Any lvt_3_1_ : this.tagList) {
                lvt_1_1_.appendTag(lvt_3_1_.parse());
            }
            return lvt_1_1_;
        }
    }

    static class Compound
    extends Any {
        protected java.util.List<Any> tagList = Lists.newArrayList();

        public Compound(String p_i45137_1_) {
            this.json = p_i45137_1_;
        }

        @Override
        public NBTBase parse() throws NBTException {
            NBTTagCompound lvt_1_1_ = new NBTTagCompound();
            for (Any lvt_3_1_ : this.tagList) {
                lvt_1_1_.setTag(lvt_3_1_.json, lvt_3_1_.parse());
            }
            return lvt_1_1_;
        }
    }

    static abstract class Any {
        protected String json;

        Any() {
        }

        public abstract NBTBase parse() throws NBTException;
    }
}

