/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

public class NBTSizeTracker {
    public static final NBTSizeTracker INFINITE = new NBTSizeTracker(0L){

        @Override
        public void read(long p_read_1_) {
        }
    };
    private final long max;
    private long read;

    public NBTSizeTracker(long p_i46342_1_) {
        this.max = p_i46342_1_;
    }

    public void read(long p_read_1_) {
        this.read += p_read_1_ / 8L;
        if (this.read > this.max) {
            throw new RuntimeException("Tried to read NBT tag that was too big; tried to allocate: " + this.read + "bytes where max allowed: " + this.max);
        }
    }

    public static void readUTF(NBTSizeTracker p_readUTF_0_, String p_readUTF_1_) {
        p_readUTF_0_.read(16L);
        if (p_readUTF_1_ == null) {
            return;
        }
        int len = p_readUTF_1_.length();
        int utflen = 0;
        for (int i = 0; i < len; ++i) {
            char c = p_readUTF_1_.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        p_readUTF_0_.read(8 * utflen);
    }
}

