/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;

public class NBTTagByteArray
extends NBTBase {
    private byte[] data;

    NBTTagByteArray() {
    }

    public NBTTagByteArray(byte[] p_i45128_1_) {
        this.data = p_i45128_1_;
    }

    @Override
    void write(DataOutput p_write_1_) throws IOException {
        p_write_1_.writeInt(this.data.length);
        p_write_1_.write(this.data);
    }

    @Override
    void read(DataInput p_read_1_, int p_read_2_, NBTSizeTracker p_read_3_) throws IOException {
        p_read_3_.read(192L);
        int lvt_4_1_ = p_read_1_.readInt();
        p_read_3_.read(8 * lvt_4_1_);
        this.data = new byte[lvt_4_1_];
        p_read_1_.readFully(this.data);
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    public String toString() {
        return "[" + this.data.length + " bytes]";
    }

    @Override
    public NBTBase copy() {
        byte[] lvt_1_1_ = new byte[this.data.length];
        System.arraycopy(this.data, 0, lvt_1_1_, 0, this.data.length);
        return new NBTTagByteArray(lvt_1_1_);
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (super.equals(p_equals_1_)) {
            return Arrays.equals(this.data, ((NBTTagByteArray)p_equals_1_).data);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.data);
    }

    public byte[] getByteArray() {
        return this.data;
    }
}

