/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ReportedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTTagCompound
extends NBTBase {
    private static final Logger field_191551_b = LogManager.getLogger();
    private final Map<String, NBTBase> tagMap = Maps.newHashMap();

    @Override
    void write(DataOutput p_write_1_) throws IOException {
        for (String s : this.tagMap.keySet()) {
            NBTBase nbtbase = this.tagMap.get(s);
            NBTTagCompound.writeEntry(s, nbtbase, p_write_1_);
        }
        p_write_1_.writeByte(0);
    }

    @Override
    void read(DataInput p_read_1_, int p_read_2_, NBTSizeTracker p_read_3_) throws IOException {
        byte b0;
        p_read_3_.read(384L);
        if (p_read_2_ > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.tagMap.clear();
        while ((b0 = NBTTagCompound.readType(p_read_1_, p_read_3_)) != 0) {
            String s = NBTTagCompound.readKey(p_read_1_, p_read_3_);
            p_read_3_.read(224 + 16 * s.length());
            NBTBase nbtbase = NBTTagCompound.readNBT(b0, s, p_read_1_, p_read_2_ + 1, p_read_3_);
            if (this.tagMap.put(s, nbtbase) == null) continue;
            p_read_3_.read(288L);
        }
    }

    public Set<String> getKeySet() {
        return this.tagMap.keySet();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public int getSize() {
        return this.tagMap.size();
    }

    public void setTag(String p_setTag_1_, NBTBase p_setTag_2_) {
        this.tagMap.put(p_setTag_1_, p_setTag_2_);
    }

    public void setByte(String p_setByte_1_, byte p_setByte_2_) {
        this.tagMap.put(p_setByte_1_, new NBTTagByte(p_setByte_2_));
    }

    public void setShort(String p_setShort_1_, short p_setShort_2_) {
        this.tagMap.put(p_setShort_1_, new NBTTagShort(p_setShort_2_));
    }

    public void setInteger(String p_setInteger_1_, int p_setInteger_2_) {
        this.tagMap.put(p_setInteger_1_, new NBTTagInt(p_setInteger_2_));
    }

    public void setLong(String p_setLong_1_, long p_setLong_2_) {
        this.tagMap.put(p_setLong_1_, new NBTTagLong(p_setLong_2_));
    }

    public void setUniqueId(String p_setUniqueId_1_, UUID p_setUniqueId_2_) {
        this.setLong(p_setUniqueId_1_ + "Most", p_setUniqueId_2_.getMostSignificantBits());
        this.setLong(p_setUniqueId_1_ + "Least", p_setUniqueId_2_.getLeastSignificantBits());
    }

    @Nullable
    public UUID getUniqueId(String p_getUniqueId_1_) {
        return new UUID(this.getLong(p_getUniqueId_1_ + "Most"), this.getLong(p_getUniqueId_1_ + "Least"));
    }

    public boolean hasUniqueId(String p_hasUniqueId_1_) {
        return this.hasKey(p_hasUniqueId_1_ + "Most", 99) && this.hasKey(p_hasUniqueId_1_ + "Least", 99);
    }

    public void setFloat(String p_setFloat_1_, float p_setFloat_2_) {
        this.tagMap.put(p_setFloat_1_, new NBTTagFloat(p_setFloat_2_));
    }

    public void setDouble(String p_setDouble_1_, double p_setDouble_2_) {
        this.tagMap.put(p_setDouble_1_, new NBTTagDouble(p_setDouble_2_));
    }

    public void setString(String p_setString_1_, String p_setString_2_) {
        this.tagMap.put(p_setString_1_, new NBTTagString(p_setString_2_));
    }

    public void setByteArray(String p_setByteArray_1_, byte[] p_setByteArray_2_) {
        this.tagMap.put(p_setByteArray_1_, new NBTTagByteArray(p_setByteArray_2_));
    }

    public void setIntArray(String p_setIntArray_1_, int[] p_setIntArray_2_) {
        this.tagMap.put(p_setIntArray_1_, new NBTTagIntArray(p_setIntArray_2_));
    }

    public void setBoolean(String p_setBoolean_1_, boolean p_setBoolean_2_) {
        this.setByte(p_setBoolean_1_, (byte)(p_setBoolean_2_ ? 1 : 0));
    }

    public NBTBase getTag(String p_getTag_1_) {
        return this.tagMap.get(p_getTag_1_);
    }

    public byte getTagId(String p_getTagId_1_) {
        NBTBase nbtbase = this.tagMap.get(p_getTagId_1_);
        return nbtbase == null ? (byte)0 : nbtbase.getId();
    }

    public boolean hasKey(String p_hasKey_1_) {
        return this.tagMap.containsKey(p_hasKey_1_);
    }

    public boolean hasKey(String p_hasKey_1_, int p_hasKey_2_) {
        byte i = this.getTagId(p_hasKey_1_);
        return i == p_hasKey_2_ ? true : (p_hasKey_2_ != 99 ? false : i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6);
    }

    public byte getByte(String p_getByte_1_) {
        try {
            if (this.hasKey(p_getByte_1_, 99)) {
                return ((NBTPrimitive)this.tagMap.get(p_getByte_1_)).getByte();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short getShort(String p_getShort_1_) {
        try {
            if (this.hasKey(p_getShort_1_, 99)) {
                return ((NBTPrimitive)this.tagMap.get(p_getShort_1_)).getShort();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int getInteger(String p_getInteger_1_) {
        try {
            if (this.hasKey(p_getInteger_1_, 99)) {
                return ((NBTPrimitive)this.tagMap.get(p_getInteger_1_)).getInt();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long getLong(String p_getLong_1_) {
        try {
            if (this.hasKey(p_getLong_1_, 99)) {
                return ((NBTPrimitive)this.tagMap.get(p_getLong_1_)).getLong();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float getFloat(String p_getFloat_1_) {
        try {
            if (this.hasKey(p_getFloat_1_, 99)) {
                return ((NBTPrimitive)this.tagMap.get(p_getFloat_1_)).getFloat();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double getDouble(String p_getDouble_1_) {
        try {
            if (this.hasKey(p_getDouble_1_, 99)) {
                return ((NBTPrimitive)this.tagMap.get(p_getDouble_1_)).getDouble();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String getString(String p_getString_1_) {
        try {
            if (this.hasKey(p_getString_1_, 8)) {
                return this.tagMap.get(p_getString_1_).getString();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] getByteArray(String p_getByteArray_1_) {
        try {
            if (this.hasKey(p_getByteArray_1_, 7)) {
                return ((NBTTagByteArray)this.tagMap.get(p_getByteArray_1_)).getByteArray();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.createCrashReport(p_getByteArray_1_, 7, classcastexception));
        }
        return new byte[0];
    }

    public int[] getIntArray(String p_getIntArray_1_) {
        try {
            if (this.hasKey(p_getIntArray_1_, 11)) {
                return ((NBTTagIntArray)this.tagMap.get(p_getIntArray_1_)).getIntArray();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.createCrashReport(p_getIntArray_1_, 11, classcastexception));
        }
        return new int[0];
    }

    public NBTTagCompound getCompoundTag(String p_getCompoundTag_1_) {
        try {
            if (this.hasKey(p_getCompoundTag_1_, 10)) {
                return (NBTTagCompound)this.tagMap.get(p_getCompoundTag_1_);
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.createCrashReport(p_getCompoundTag_1_, 10, classcastexception));
        }
        return new NBTTagCompound();
    }

    public NBTTagList getTagList(String p_getTagList_1_, int p_getTagList_2_) {
        try {
            if (this.getTagId(p_getTagList_1_) == 9) {
                NBTTagList nbttaglist = (NBTTagList)this.tagMap.get(p_getTagList_1_);
                if (!nbttaglist.hasNoTags() && nbttaglist.getTagType() != p_getTagList_2_) {
                    return new NBTTagList();
                }
                return nbttaglist;
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.createCrashReport(p_getTagList_1_, 9, classcastexception));
        }
        return new NBTTagList();
    }

    public boolean getBoolean(String p_getBoolean_1_) {
        return this.getByte(p_getBoolean_1_) != 0;
    }

    public void removeTag(String p_removeTag_1_) {
        this.tagMap.remove(p_removeTag_1_);
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("{");
        Collection<String> collection = this.tagMap.keySet();
        if (field_191551_b.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(this.tagMap.keySet());
            Collections.sort(list);
            collection = list;
        }
        for (String s : collection) {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            stringbuilder.append(s).append(':').append(this.tagMap.get(s));
        }
        return stringbuilder.append('}').toString();
    }

    @Override
    public boolean hasNoTags() {
        return this.tagMap.isEmpty();
    }

    private CrashReport createCrashReport(final String p_createCrashReport_1_, final int p_createCrashReport_2_, ClassCastException p_createCrashReport_3_) {
        CrashReport crashreport = CrashReport.makeCrashReport(p_createCrashReport_3_, "Reading NBT data");
        CrashReportCategory crashreportcategory = crashreport.makeCategoryDepth("Corrupt NBT tag", 1);
        crashreportcategory.setDetail("Tag type found", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return NBTBase.NBT_TYPES[((NBTBase)NBTTagCompound.this.tagMap.get(p_createCrashReport_1_)).getId()];
            }
        });
        crashreportcategory.setDetail("Tag type expected", new ICrashReportDetail<String>(){

            @Override
            public String call() throws Exception {
                return NBTBase.NBT_TYPES[p_createCrashReport_2_];
            }
        });
        crashreportcategory.addCrashSection("Tag name", p_createCrashReport_1_);
        return crashreport;
    }

    @Override
    public NBTTagCompound copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        for (String s : this.tagMap.keySet()) {
            nbttagcompound.setTag(s, this.tagMap.get(s).copy());
        }
        return nbttagcompound;
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (super.equals(p_equals_1_)) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)p_equals_1_;
            return this.tagMap.entrySet().equals(nbttagcompound.tagMap.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.tagMap.hashCode();
    }

    private static void writeEntry(String p_writeEntry_0_, NBTBase p_writeEntry_1_, DataOutput p_writeEntry_2_) throws IOException {
        p_writeEntry_2_.writeByte(p_writeEntry_1_.getId());
        if (p_writeEntry_1_.getId() != 0) {
            p_writeEntry_2_.writeUTF(p_writeEntry_0_);
            p_writeEntry_1_.write(p_writeEntry_2_);
        }
    }

    private static byte readType(DataInput p_readType_0_, NBTSizeTracker p_readType_1_) throws IOException {
        p_readType_1_.read(8L);
        return p_readType_0_.readByte();
    }

    private static String readKey(DataInput p_readKey_0_, NBTSizeTracker p_readKey_1_) throws IOException {
        return p_readKey_0_.readUTF();
    }

    static NBTBase readNBT(byte p_readNBT_0_, String p_readNBT_1_, DataInput p_readNBT_2_, int p_readNBT_3_, NBTSizeTracker p_readNBT_4_) throws IOException {
        p_readNBT_4_.read(32L);
        NBTBase nbtbase = NBTBase.createNewByType(p_readNBT_0_);
        try {
            nbtbase.read(p_readNBT_2_, p_readNBT_3_, p_readNBT_4_);
            return nbtbase;
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.makeCrashReport(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("NBT Tag");
            crashreportcategory.addCrashSection("Tag name", p_readNBT_1_);
            crashreportcategory.addCrashSection("Tag type", p_readNBT_0_);
            throw new ReportedException(crashreport);
        }
    }

    public void merge(NBTTagCompound p_merge_1_) {
        for (String s : p_merge_1_.tagMap.keySet()) {
            NBTBase nbtbase = p_merge_1_.tagMap.get(s);
            if (nbtbase.getId() == 10) {
                if (this.hasKey(s, 10)) {
                    NBTTagCompound nbttagcompound = this.getCompoundTag(s);
                    nbttagcompound.merge((NBTTagCompound)nbtbase);
                    continue;
                }
                this.setTag(s, nbtbase.copy());
                continue;
            }
            this.setTag(s, nbtbase.copy());
        }
    }
}

