/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.util.math.MathHelper;

public class NBTTagDouble
extends NBTPrimitive {
    private double data;

    NBTTagDouble() {
    }

    public NBTTagDouble(double p_i45130_1_) {
        this.data = p_i45130_1_;
    }

    @Override
    void write(DataOutput p_write_1_) throws IOException {
        p_write_1_.writeDouble(this.data);
    }

    @Override
    void read(DataInput p_read_1_, int p_read_2_, NBTSizeTracker p_read_3_) throws IOException {
        p_read_3_.read(128L);
        this.data = p_read_1_.readDouble();
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public String toString() {
        return "" + this.data + "d";
    }

    @Override
    public NBTTagDouble copy() {
        return new NBTTagDouble(this.data);
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (super.equals(p_equals_1_)) {
            NBTTagDouble lvt_2_1_ = (NBTTagDouble)p_equals_1_;
            return this.data == lvt_2_1_.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long lvt_1_1_ = Double.doubleToLongBits(this.data);
        return super.hashCode() ^ (int)(lvt_1_1_ ^ lvt_1_1_ >>> 32);
    }

    @Override
    public long getLong() {
        return (long)Math.floor(this.data);
    }

    @Override
    public int getInt() {
        return MathHelper.floor(this.data);
    }

    @Override
    public short getShort() {
        return (short)(MathHelper.floor(this.data) & 0xFFFF);
    }

    @Override
    public byte getByte() {
        return (byte)(MathHelper.floor(this.data) & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return (float)this.data;
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

