/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.util.math.MathHelper;

public class NBTTagFloat
extends NBTPrimitive {
    private float data;

    NBTTagFloat() {
    }

    public NBTTagFloat(float p_i45131_1_) {
        this.data = p_i45131_1_;
    }

    @Override
    void write(DataOutput p_write_1_) throws IOException {
        p_write_1_.writeFloat(this.data);
    }

    @Override
    void read(DataInput p_read_1_, int p_read_2_, NBTSizeTracker p_read_3_) throws IOException {
        p_read_3_.read(96L);
        this.data = p_read_1_.readFloat();
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public String toString() {
        return "" + this.data + "f";
    }

    @Override
    public NBTTagFloat copy() {
        return new NBTTagFloat(this.data);
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (super.equals(p_equals_1_)) {
            NBTTagFloat lvt_2_1_ = (NBTTagFloat)p_equals_1_;
            return this.data == lvt_2_1_.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Float.floatToIntBits(this.data);
    }

    @Override
    public long getLong() {
        return (long)this.data;
    }

    @Override
    public int getInt() {
        return MathHelper.floor(this.data);
    }

    @Override
    public short getShort() {
        return (short)(MathHelper.floor(this.data) & 0xFFFF);
    }

    @Override
    public byte getByte() {
        return (byte)(MathHelper.floor(this.data) & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

