/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTTagList
extends NBTBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<NBTBase> tagList = Lists.newArrayList();
    private byte tagType = 0;

    @Override
    void write(DataOutput p_write_1_) throws IOException {
        this.tagType = this.tagList.isEmpty() ? (byte)0 : this.tagList.get(0).getId();
        p_write_1_.writeByte(this.tagType);
        p_write_1_.writeInt(this.tagList.size());
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.tagList.size(); ++lvt_2_1_) {
            this.tagList.get(lvt_2_1_).write(p_write_1_);
        }
    }

    @Override
    void read(DataInput p_read_1_, int p_read_2_, NBTSizeTracker p_read_3_) throws IOException {
        p_read_3_.read(296L);
        if (p_read_2_ > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.tagType = p_read_1_.readByte();
        int lvt_4_1_ = p_read_1_.readInt();
        if (this.tagType == 0 && lvt_4_1_ > 0) {
            throw new RuntimeException("Missing type on ListTag");
        }
        p_read_3_.read(32L * (long)lvt_4_1_);
        this.tagList = Lists.newArrayListWithCapacity((int)lvt_4_1_);
        for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_4_1_; ++lvt_5_1_) {
            NBTBase lvt_6_1_ = NBTBase.createNewByType(this.tagType);
            lvt_6_1_.read(p_read_1_, p_read_2_ + 1, p_read_3_);
            this.tagList.add(lvt_6_1_);
        }
    }

    @Override
    public byte getId() {
        return 9;
    }

    @Override
    public String toString() {
        StringBuilder lvt_1_1_ = new StringBuilder("[");
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.tagList.size(); ++lvt_2_1_) {
            if (lvt_2_1_ != 0) {
                lvt_1_1_.append(',');
            }
            lvt_1_1_.append(lvt_2_1_).append(':').append(this.tagList.get(lvt_2_1_));
        }
        return lvt_1_1_.append(']').toString();
    }

    public void appendTag(NBTBase p_appendTag_1_) {
        if (p_appendTag_1_.getId() == 0) {
            LOGGER.warn("Invalid TagEnd added to ListTag");
            return;
        }
        if (this.tagType == 0) {
            this.tagType = p_appendTag_1_.getId();
        } else if (this.tagType != p_appendTag_1_.getId()) {
            LOGGER.warn("Adding mismatching tag types to tag list");
            return;
        }
        this.tagList.add(p_appendTag_1_);
    }

    public void set(int p_set_1_, NBTBase p_set_2_) {
        if (p_set_2_.getId() == 0) {
            LOGGER.warn("Invalid TagEnd added to ListTag");
            return;
        }
        if (p_set_1_ < 0 || p_set_1_ >= this.tagList.size()) {
            LOGGER.warn("index out of bounds to set tag in tag list");
            return;
        }
        if (this.tagType == 0) {
            this.tagType = p_set_2_.getId();
        } else if (this.tagType != p_set_2_.getId()) {
            LOGGER.warn("Adding mismatching tag types to tag list");
            return;
        }
        this.tagList.set(p_set_1_, p_set_2_);
    }

    public NBTBase removeTag(int p_removeTag_1_) {
        return this.tagList.remove(p_removeTag_1_);
    }

    @Override
    public boolean hasNoTags() {
        return this.tagList.isEmpty();
    }

    public NBTTagCompound getCompoundTagAt(int p_getCompoundTagAt_1_) {
        NBTBase lvt_2_1_;
        if (p_getCompoundTagAt_1_ >= 0 && p_getCompoundTagAt_1_ < this.tagList.size() && (lvt_2_1_ = this.tagList.get(p_getCompoundTagAt_1_)).getId() == 10) {
            return (NBTTagCompound)lvt_2_1_;
        }
        return new NBTTagCompound();
    }

    public int getIntAt(int p_getIntAt_1_) {
        NBTBase lvt_2_1_;
        if (p_getIntAt_1_ >= 0 && p_getIntAt_1_ < this.tagList.size() && (lvt_2_1_ = this.tagList.get(p_getIntAt_1_)).getId() == 3) {
            return ((NBTTagInt)lvt_2_1_).getInt();
        }
        return 0;
    }

    public int[] getIntArrayAt(int p_getIntArrayAt_1_) {
        NBTBase lvt_2_1_;
        if (p_getIntArrayAt_1_ >= 0 && p_getIntArrayAt_1_ < this.tagList.size() && (lvt_2_1_ = this.tagList.get(p_getIntArrayAt_1_)).getId() == 11) {
            return ((NBTTagIntArray)lvt_2_1_).getIntArray();
        }
        return new int[0];
    }

    public double getDoubleAt(int p_getDoubleAt_1_) {
        NBTBase lvt_2_1_;
        if (p_getDoubleAt_1_ >= 0 && p_getDoubleAt_1_ < this.tagList.size() && (lvt_2_1_ = this.tagList.get(p_getDoubleAt_1_)).getId() == 6) {
            return ((NBTTagDouble)lvt_2_1_).getDouble();
        }
        return 0.0;
    }

    public float getFloatAt(int p_getFloatAt_1_) {
        NBTBase lvt_2_1_;
        if (p_getFloatAt_1_ >= 0 && p_getFloatAt_1_ < this.tagList.size() && (lvt_2_1_ = this.tagList.get(p_getFloatAt_1_)).getId() == 5) {
            return ((NBTTagFloat)lvt_2_1_).getFloat();
        }
        return 0.0f;
    }

    public String getStringTagAt(int p_getStringTagAt_1_) {
        if (p_getStringTagAt_1_ < 0 || p_getStringTagAt_1_ >= this.tagList.size()) {
            return "";
        }
        NBTBase lvt_2_1_ = this.tagList.get(p_getStringTagAt_1_);
        if (lvt_2_1_.getId() == 8) {
            return lvt_2_1_.getString();
        }
        return lvt_2_1_.toString();
    }

    public NBTBase get(int p_get_1_) {
        if (p_get_1_ < 0 || p_get_1_ >= this.tagList.size()) {
            return new NBTTagEnd();
        }
        return this.tagList.get(p_get_1_);
    }

    public int tagCount() {
        return this.tagList.size();
    }

    @Override
    public NBTTagList copy() {
        NBTTagList lvt_1_1_ = new NBTTagList();
        lvt_1_1_.tagType = this.tagType;
        for (NBTBase lvt_3_1_ : this.tagList) {
            NBTBase lvt_4_1_ = lvt_3_1_.copy();
            lvt_1_1_.tagList.add(lvt_4_1_);
        }
        return lvt_1_1_;
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (super.equals(p_equals_1_)) {
            NBTTagList lvt_2_1_ = (NBTTagList)p_equals_1_;
            if (this.tagType == lvt_2_1_.tagType) {
                return this.tagList.equals(lvt_2_1_.tagList);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.tagList.hashCode();
    }

    public int getTagType() {
        return this.tagType;
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

