/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import org.apache.commons.lang3.StringUtils;

public class NBTTagString
extends NBTBase {
    private String data;

    public NBTTagString() {
        this.data = "";
    }

    public NBTTagString(String p_i1389_1_) {
        this.data = p_i1389_1_;
        if (p_i1389_1_ == null) {
            throw new IllegalArgumentException("Empty string not allowed");
        }
    }

    @Override
    void write(DataOutput p_write_1_) throws IOException {
        p_write_1_.writeUTF(this.data);
    }

    @Override
    void read(DataInput p_read_1_, int p_read_2_, NBTSizeTracker p_read_3_) throws IOException {
        p_read_3_.read(288L);
        this.data = p_read_1_.readUTF();
        NBTSizeTracker.readUTF(p_read_3_, this.data);
    }

    @Override
    public byte getId() {
        return 8;
    }

    @Override
    public String toString() {
        return "\"" + StringUtils.replaceEach((String)this.data, (String[])new String[]{"\\", "\""}, (String[])new String[]{"\\\\", "\\\""}) + "\"";
    }

    @Override
    public NBTTagString copy() {
        return new NBTTagString(this.data);
    }

    @Override
    public boolean hasNoTags() {
        return this.data.isEmpty();
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (!super.equals(p_equals_1_)) {
            return false;
        }
        NBTTagString nbttagstring = (NBTTagString)p_equals_1_;
        return this.data == null && nbttagstring.data == null || this.data != null && this.data.equals(nbttagstring.data);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.data.hashCode();
    }

    @Override
    public String getString() {
        return this.data;
    }
}

