/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;

public final class NBTUtil {
    @Nullable
    public static GameProfile readGameProfileFromNBT(NBTTagCompound p_readGameProfileFromNBT_0_) {
        String lvt_1_1_ = null;
        String lvt_2_1_ = null;
        if (p_readGameProfileFromNBT_0_.hasKey("Name", 8)) {
            lvt_1_1_ = p_readGameProfileFromNBT_0_.getString("Name");
        }
        if (p_readGameProfileFromNBT_0_.hasKey("Id", 8)) {
            lvt_2_1_ = p_readGameProfileFromNBT_0_.getString("Id");
        }
        try {
            UUID lvt_3_2_;
            try {
                UUID lvt_3_1_ = UUID.fromString(lvt_2_1_);
            }
            catch (Throwable lvt_4_1_) {
                lvt_3_2_ = null;
            }
            GameProfile lvt_4_2_ = new GameProfile(lvt_3_2_, lvt_1_1_);
            if (p_readGameProfileFromNBT_0_.hasKey("Properties", 10)) {
                NBTTagCompound lvt_5_1_ = p_readGameProfileFromNBT_0_.getCompoundTag("Properties");
                for (String lvt_7_1_ : lvt_5_1_.getKeySet()) {
                    NBTTagList lvt_8_1_ = lvt_5_1_.getTagList(lvt_7_1_, 10);
                    for (int lvt_9_1_ = 0; lvt_9_1_ < lvt_8_1_.tagCount(); ++lvt_9_1_) {
                        NBTTagCompound lvt_10_1_ = lvt_8_1_.getCompoundTagAt(lvt_9_1_);
                        String lvt_11_1_ = lvt_10_1_.getString("Value");
                        if (lvt_10_1_.hasKey("Signature", 8)) {
                            lvt_4_2_.getProperties().put((Object)lvt_7_1_, (Object)new Property(lvt_7_1_, lvt_11_1_, lvt_10_1_.getString("Signature")));
                            continue;
                        }
                        lvt_4_2_.getProperties().put((Object)lvt_7_1_, (Object)new Property(lvt_7_1_, lvt_11_1_));
                    }
                }
            }
            return lvt_4_2_;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static NBTTagCompound writeGameProfile(NBTTagCompound p_writeGameProfile_0_, GameProfile p_writeGameProfile_1_) {
        if (!StringUtils.isNullOrEmpty(p_writeGameProfile_1_.getName())) {
            p_writeGameProfile_0_.setString("Name", p_writeGameProfile_1_.getName());
        }
        if (p_writeGameProfile_1_.getId() != null) {
            p_writeGameProfile_0_.setString("Id", p_writeGameProfile_1_.getId().toString());
        }
        if (!p_writeGameProfile_1_.getProperties().isEmpty()) {
            NBTTagCompound lvt_2_1_ = new NBTTagCompound();
            for (String lvt_4_1_ : p_writeGameProfile_1_.getProperties().keySet()) {
                NBTTagList lvt_5_1_ = new NBTTagList();
                for (Property lvt_7_1_ : p_writeGameProfile_1_.getProperties().get((Object)lvt_4_1_)) {
                    NBTTagCompound lvt_8_1_ = new NBTTagCompound();
                    lvt_8_1_.setString("Value", lvt_7_1_.getValue());
                    if (lvt_7_1_.hasSignature()) {
                        lvt_8_1_.setString("Signature", lvt_7_1_.getSignature());
                    }
                    lvt_5_1_.appendTag(lvt_8_1_);
                }
                lvt_2_1_.setTag(lvt_4_1_, lvt_5_1_);
            }
            p_writeGameProfile_0_.setTag("Properties", lvt_2_1_);
        }
        return p_writeGameProfile_0_;
    }

    @VisibleForTesting
    public static boolean areNBTEquals(NBTBase p_areNBTEquals_0_, NBTBase p_areNBTEquals_1_, boolean p_areNBTEquals_2_) {
        if (p_areNBTEquals_0_ == p_areNBTEquals_1_) {
            return true;
        }
        if (p_areNBTEquals_0_ == null) {
            return true;
        }
        if (p_areNBTEquals_1_ == null) {
            return false;
        }
        if (!p_areNBTEquals_0_.getClass().equals(p_areNBTEquals_1_.getClass())) {
            return false;
        }
        if (p_areNBTEquals_0_ instanceof NBTTagCompound) {
            NBTTagCompound lvt_3_1_ = (NBTTagCompound)p_areNBTEquals_0_;
            NBTTagCompound lvt_4_1_ = (NBTTagCompound)p_areNBTEquals_1_;
            for (String lvt_6_1_ : lvt_3_1_.getKeySet()) {
                NBTBase lvt_7_1_ = lvt_3_1_.getTag(lvt_6_1_);
                if (NBTUtil.areNBTEquals(lvt_7_1_, lvt_4_1_.getTag(lvt_6_1_), p_areNBTEquals_2_)) continue;
                return false;
            }
            return true;
        }
        if (p_areNBTEquals_0_ instanceof NBTTagList && p_areNBTEquals_2_) {
            NBTTagList lvt_3_2_ = (NBTTagList)p_areNBTEquals_0_;
            NBTTagList lvt_4_2_ = (NBTTagList)p_areNBTEquals_1_;
            if (lvt_3_2_.hasNoTags()) {
                return lvt_4_2_.hasNoTags();
            }
            for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_3_2_.tagCount(); ++lvt_5_1_) {
                NBTBase lvt_6_2_ = lvt_3_2_.get(lvt_5_1_);
                boolean lvt_7_2_ = false;
                for (int lvt_8_1_ = 0; lvt_8_1_ < lvt_4_2_.tagCount(); ++lvt_8_1_) {
                    if (!NBTUtil.areNBTEquals(lvt_6_2_, lvt_4_2_.get(lvt_8_1_), p_areNBTEquals_2_)) continue;
                    lvt_7_2_ = true;
                    break;
                }
                if (lvt_7_2_) continue;
                return false;
            }
            return true;
        }
        return p_areNBTEquals_0_.equals(p_areNBTEquals_1_);
    }

    public static NBTTagCompound createUUIDTag(UUID p_createUUIDTag_0_) {
        NBTTagCompound lvt_1_1_ = new NBTTagCompound();
        lvt_1_1_.setLong("M", p_createUUIDTag_0_.getMostSignificantBits());
        lvt_1_1_.setLong("L", p_createUUIDTag_0_.getLeastSignificantBits());
        return lvt_1_1_;
    }

    public static UUID getUUIDFromTag(NBTTagCompound p_getUUIDFromTag_0_) {
        return new UUID(p_getUUIDFromTag_0_.getLong("M"), p_getUUIDFromTag_0_.getLong("L"));
    }

    public static BlockPos getPosFromTag(NBTTagCompound p_getPosFromTag_0_) {
        return new BlockPos(p_getPosFromTag_0_.getInteger("X"), p_getPosFromTag_0_.getInteger("Y"), p_getPosFromTag_0_.getInteger("Z"));
    }

    public static NBTTagCompound createPosTag(BlockPos p_createPosTag_0_) {
        NBTTagCompound lvt_1_1_ = new NBTTagCompound();
        lvt_1_1_.setInteger("X", p_createPosTag_0_.getX());
        lvt_1_1_.setInteger("Y", p_createPosTag_0_.getY());
        lvt_1_1_.setInteger("Z", p_createPosTag_0_.getZ());
        return lvt_1_1_;
    }

    public static IBlockState readBlockState(NBTTagCompound p_readBlockState_0_) {
        if (!p_readBlockState_0_.hasKey("Name", 8)) {
            return Blocks.AIR.getDefaultState();
        }
        Block lvt_1_1_ = Block.REGISTRY.getObject(new ResourceLocation(p_readBlockState_0_.getString("Name")));
        IBlockState lvt_2_1_ = lvt_1_1_.getDefaultState();
        if (p_readBlockState_0_.hasKey("Properties", 10)) {
            NBTTagCompound lvt_3_1_ = p_readBlockState_0_.getCompoundTag("Properties");
            BlockStateContainer lvt_4_1_ = lvt_1_1_.getBlockState();
            for (String lvt_6_1_ : lvt_3_1_.getKeySet()) {
                IProperty<?> lvt_7_1_ = lvt_4_1_.getProperty(lvt_6_1_);
                if (lvt_7_1_ == null) continue;
                lvt_2_1_ = NBTUtil.setValueHelper(lvt_2_1_, lvt_7_1_, lvt_3_1_.getString(lvt_6_1_));
            }
        }
        return lvt_2_1_;
    }

    private static <T extends Comparable<T>> IBlockState setValueHelper(IBlockState p_setValueHelper_0_, IProperty<T> p_setValueHelper_1_, String p_setValueHelper_2_) {
        return p_setValueHelper_0_.withProperty(p_setValueHelper_1_, (Comparable)p_setValueHelper_1_.parseValue(p_setValueHelper_2_).get());
    }

    public static NBTTagCompound writeBlockState(NBTTagCompound p_writeBlockState_0_, IBlockState p_writeBlockState_1_) {
        p_writeBlockState_0_.setString("Name", Block.REGISTRY.getNameForObject(p_writeBlockState_1_.getBlock()).toString());
        if (!p_writeBlockState_1_.getProperties().isEmpty()) {
            NBTTagCompound lvt_2_1_ = new NBTTagCompound();
            for (Map.Entry lvt_4_1_ : p_writeBlockState_1_.getProperties().entrySet()) {
                IProperty lvt_5_1_ = (IProperty)lvt_4_1_.getKey();
                lvt_2_1_.setString(lvt_5_1_.getName(), NBTUtil.getName(lvt_5_1_, (Comparable)lvt_4_1_.getValue()));
            }
            p_writeBlockState_0_.setTag("Properties", lvt_2_1_);
        }
        return p_writeBlockState_0_;
    }

    private static <T extends Comparable<T>> String getName(IProperty<T> p_getName_0_, Comparable<?> p_getName_1_) {
        return p_getName_0_.getName(p_getName_1_);
    }
}

