/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.util.concurrent.Futures;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketClickWindow;
import net.minecraft.network.play.client.CPacketClientSettings;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketCloseWindow;
import net.minecraft.network.play.client.CPacketConfirmTeleport;
import net.minecraft.network.play.client.CPacketConfirmTransaction;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.client.CPacketEnchantItem;
import net.minecraft.network.play.client.CPacketEntityAction;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.client.CPacketInput;
import net.minecraft.network.play.client.CPacketKeepAlive;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketPlayerAbilities;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.client.CPacketResourcePackStatus;
import net.minecraft.network.play.client.CPacketSpectate;
import net.minecraft.network.play.client.CPacketSteerBoat;
import net.minecraft.network.play.client.CPacketTabComplete;
import net.minecraft.network.play.client.CPacketUpdateSign;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.network.play.client.CPacketVehicleMove;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketConfirmTransaction;
import net.minecraft.network.play.server.SPacketDisconnect;
import net.minecraft.network.play.server.SPacketHeldItemChange;
import net.minecraft.network.play.server.SPacketKeepAlive;
import net.minecraft.network.play.server.SPacketMoveVehicle;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.network.play.server.SPacketTabComplete;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.AchievementList;
import net.minecraft.tileentity.CommandBlockBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ReportedException;
import net.minecraft.util.Rotation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetHandlerPlayServer
implements INetHandlerPlayServer,
ITickable {
    private static final Logger LOGGER = LogManager.getLogger();
    public final NetworkManager netManager;
    private final MinecraftServer serverController;
    public EntityPlayerMP playerEntity;
    private int networkTickCount;
    private int keepAliveId;
    private long lastPingTime;
    private long lastSentPingPacket;
    private int chatSpamThresholdCount;
    private int itemDropThreshold;
    private final IntHashMap<Short> pendingTransactions = new IntHashMap();
    private double firstGoodX;
    private double firstGoodY;
    private double firstGoodZ;
    private double lastGoodX;
    private double lastGoodY;
    private double lastGoodZ;
    private Entity lowestRiddenEnt;
    private double lowestRiddenX;
    private double lowestRiddenY;
    private double lowestRiddenZ;
    private double lowestRiddenX1;
    private double lowestRiddenY1;
    private double lowestRiddenZ1;
    private Vec3d targetPos;
    private int teleportId;
    private int lastPositionUpdate;
    private boolean floating;
    private int floatingTickCount;
    private boolean vehicleFloating;
    private int vehicleFloatingTickCount;
    private int movePacketCounter;
    private int lastMovePacketCounter;

    public NetHandlerPlayServer(MinecraftServer p_i1530_1_, NetworkManager p_i1530_2_, EntityPlayerMP p_i1530_3_) {
        this.serverController = p_i1530_1_;
        this.netManager = p_i1530_2_;
        p_i1530_2_.setNetHandler(this);
        this.playerEntity = p_i1530_3_;
        p_i1530_3_.connection = this;
    }

    @Override
    public void update() {
        this.captureCurrentPosition();
        this.playerEntity.onUpdateEntity();
        this.playerEntity.setPositionAndRotation(this.firstGoodX, this.firstGoodY, this.firstGoodZ, this.playerEntity.rotationYaw, this.playerEntity.rotationPitch);
        ++this.networkTickCount;
        this.lastMovePacketCounter = this.movePacketCounter;
        if (this.floating) {
            if (++this.floatingTickCount > 80) {
                LOGGER.warn("{} was kicked for floating too long!", new Object[]{this.playerEntity.getName()});
                this.disconnect("Flying is not enabled on this server");
                return;
            }
        } else {
            this.floating = false;
            this.floatingTickCount = 0;
        }
        this.lowestRiddenEnt = this.playerEntity.getLowestRidingEntity();
        if (this.lowestRiddenEnt != this.playerEntity && this.lowestRiddenEnt.getControllingPassenger() == this.playerEntity) {
            this.lowestRiddenX = this.lowestRiddenEnt.posX;
            this.lowestRiddenY = this.lowestRiddenEnt.posY;
            this.lowestRiddenZ = this.lowestRiddenEnt.posZ;
            this.lowestRiddenX1 = this.lowestRiddenEnt.posX;
            this.lowestRiddenY1 = this.lowestRiddenEnt.posY;
            this.lowestRiddenZ1 = this.lowestRiddenEnt.posZ;
            if (this.vehicleFloating && this.playerEntity.getLowestRidingEntity().getControllingPassenger() == this.playerEntity) {
                if (++this.vehicleFloatingTickCount > 80) {
                    LOGGER.warn("{} was kicked for floating a vehicle too long!", new Object[]{this.playerEntity.getName()});
                    this.disconnect("Flying is not enabled on this server");
                    return;
                }
            } else {
                this.vehicleFloating = false;
                this.vehicleFloatingTickCount = 0;
            }
        } else {
            this.lowestRiddenEnt = null;
            this.vehicleFloating = false;
            this.vehicleFloatingTickCount = 0;
        }
        this.serverController.theProfiler.startSection("keepAlive");
        if ((long)this.networkTickCount - this.lastSentPingPacket > 40L) {
            this.lastSentPingPacket = this.networkTickCount;
            this.lastPingTime = this.currentTimeMillis();
            this.keepAliveId = (int)this.lastPingTime;
            this.sendPacket(new SPacketKeepAlive(this.keepAliveId));
        }
        this.serverController.theProfiler.endSection();
        if (this.chatSpamThresholdCount > 0) {
            --this.chatSpamThresholdCount;
        }
        if (this.itemDropThreshold > 0) {
            --this.itemDropThreshold;
        }
        if (this.playerEntity.getLastActiveTime() > 0L && this.serverController.getMaxPlayerIdleMinutes() > 0 && MinecraftServer.getCurrentTimeMillis() - this.playerEntity.getLastActiveTime() > (long)(this.serverController.getMaxPlayerIdleMinutes() * 1000 * 60)) {
            this.disconnect("You have been idle for too long!");
        }
    }

    private void captureCurrentPosition() {
        this.firstGoodX = this.playerEntity.posX;
        this.firstGoodY = this.playerEntity.posY;
        this.firstGoodZ = this.playerEntity.posZ;
        this.lastGoodX = this.playerEntity.posX;
        this.lastGoodY = this.playerEntity.posY;
        this.lastGoodZ = this.playerEntity.posZ;
    }

    public NetworkManager getNetworkManager() {
        return this.netManager;
    }

    public void disconnect(String p_disconnect_1_) {
        final TextComponentString textcomponentstring = new TextComponentString(p_disconnect_1_);
        this.netManager.sendPacket(new SPacketDisconnect(textcomponentstring), (GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> p_operationComplete_1_) throws Exception {
                NetHandlerPlayServer.this.netManager.closeChannel(textcomponentstring);
            }
        }, new GenericFutureListener[0]);
        this.netManager.disableAutoRead();
        Futures.getUnchecked(this.serverController.addScheduledTask(new Runnable(){

            @Override
            public void run() {
                NetHandlerPlayServer.this.netManager.checkDisconnected();
            }
        }));
    }

    @Override
    public void processInput(CPacketInput p_processInput_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processInput_1_, this, this.playerEntity.getServerWorld());
        this.playerEntity.setEntityActionState(p_processInput_1_.getStrafeSpeed(), p_processInput_1_.getForwardSpeed(), p_processInput_1_.isJumping(), p_processInput_1_.isSneaking());
    }

    private static boolean isMovePlayerPacketInvalid(CPacketPlayer p_isMovePlayerPacketInvalid_0_) {
        return Doubles.isFinite((double)p_isMovePlayerPacketInvalid_0_.getX(0.0)) && Doubles.isFinite((double)p_isMovePlayerPacketInvalid_0_.getY(0.0)) && Doubles.isFinite((double)p_isMovePlayerPacketInvalid_0_.getZ(0.0)) && Floats.isFinite((float)p_isMovePlayerPacketInvalid_0_.getPitch(0.0f)) && Floats.isFinite((float)p_isMovePlayerPacketInvalid_0_.getYaw(0.0f)) ? false : Math.abs(p_isMovePlayerPacketInvalid_0_.getX(0.0)) <= 3.0E7 && Math.abs(p_isMovePlayerPacketInvalid_0_.getZ(0.0)) <= 3.0E7;
    }

    private static boolean isMoveVehiclePacketInvalid(CPacketVehicleMove p_isMoveVehiclePacketInvalid_0_) {
        return !Doubles.isFinite((double)p_isMoveVehiclePacketInvalid_0_.getX()) || !Doubles.isFinite((double)p_isMoveVehiclePacketInvalid_0_.getY()) || !Doubles.isFinite((double)p_isMoveVehiclePacketInvalid_0_.getZ()) || !Floats.isFinite((float)p_isMoveVehiclePacketInvalid_0_.getPitch()) || !Floats.isFinite((float)p_isMoveVehiclePacketInvalid_0_.getYaw());
    }

    @Override
    public void processVehicleMove(CPacketVehicleMove p_processVehicleMove_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processVehicleMove_1_, this, this.playerEntity.getServerWorld());
        if (NetHandlerPlayServer.isMoveVehiclePacketInvalid(p_processVehicleMove_1_)) {
            this.disconnect("Invalid move vehicle packet received");
        } else {
            Entity entity = this.playerEntity.getLowestRidingEntity();
            if (entity != this.playerEntity && entity.getControllingPassenger() == this.playerEntity && entity == this.lowestRiddenEnt) {
                WorldServer worldserver = this.playerEntity.getServerWorld();
                double d0 = entity.posX;
                double d1 = entity.posY;
                double d2 = entity.posZ;
                double d3 = p_processVehicleMove_1_.getX();
                double d4 = p_processVehicleMove_1_.getY();
                double d5 = p_processVehicleMove_1_.getZ();
                float f = p_processVehicleMove_1_.getYaw();
                float f1 = p_processVehicleMove_1_.getPitch();
                double d6 = d3 - this.lowestRiddenX;
                double d7 = d4 - this.lowestRiddenY;
                double d8 = d5 - this.lowestRiddenZ;
                double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                double d9 = entity.motionX * entity.motionX + entity.motionY * entity.motionY + entity.motionZ * entity.motionZ;
                if (!(!(d10 - d9 > 100.0) || this.serverController.isSinglePlayer() && this.serverController.getServerOwner().equals(entity.getName()))) {
                    LOGGER.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.getName(), this.playerEntity.getName(), d6, d7, d8});
                    this.netManager.sendPacket(new SPacketMoveVehicle(entity));
                    return;
                }
                boolean flag = worldserver.getCollisionBoxes(entity, entity.getEntityBoundingBox().contract(0.0625)).isEmpty();
                d6 = d3 - this.lowestRiddenX1;
                d7 = d4 - this.lowestRiddenY1 - 1.0E-6;
                d8 = d5 - this.lowestRiddenZ1;
                entity.move(MoverType.PLAYER, d6, d7, d8);
                double d11 = d7;
                d6 = d3 - entity.posX;
                d7 = d4 - entity.posY;
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.posZ;
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag1 = false;
                if (d10 > 0.0625) {
                    flag1 = true;
                    LOGGER.warn("{} moved wrongly!", new Object[]{entity.getName()});
                }
                entity.setPositionAndRotation(d3, d4, d5, f, f1);
                boolean flag2 = worldserver.getCollisionBoxes(entity, entity.getEntityBoundingBox().contract(0.0625)).isEmpty();
                if (flag && (flag1 || !flag2)) {
                    entity.setPositionAndRotation(d0, d1, d2, f, f1);
                    this.netManager.sendPacket(new SPacketMoveVehicle(entity));
                    return;
                }
                this.serverController.getPlayerList().serverUpdateMovingPlayer(this.playerEntity);
                this.playerEntity.addMovementStat(this.playerEntity.posX - d0, this.playerEntity.posY - d1, this.playerEntity.posZ - d2);
                this.vehicleFloating = d11 >= -0.03125 && !this.serverController.isFlightAllowed() && !worldserver.checkBlockCollision(entity.getEntityBoundingBox().expandXyz(0.0625).addCoord(0.0, -0.55, 0.0));
                this.lowestRiddenX1 = entity.posX;
                this.lowestRiddenY1 = entity.posY;
                this.lowestRiddenZ1 = entity.posZ;
            }
        }
    }

    @Override
    public void processConfirmTeleport(CPacketConfirmTeleport p_processConfirmTeleport_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processConfirmTeleport_1_, this, this.playerEntity.getServerWorld());
        if (p_processConfirmTeleport_1_.getTeleportId() == this.teleportId) {
            this.playerEntity.setPositionAndRotation(this.targetPos.xCoord, this.targetPos.yCoord, this.targetPos.zCoord, this.playerEntity.rotationYaw, this.playerEntity.rotationPitch);
            if (this.playerEntity.isInvulnerableDimensionChange()) {
                this.lastGoodX = this.targetPos.xCoord;
                this.lastGoodY = this.targetPos.yCoord;
                this.lastGoodZ = this.targetPos.zCoord;
                this.playerEntity.clearInvulnerableDimensionChange();
            }
            this.targetPos = null;
        }
    }

    @Override
    public void processPlayer(CPacketPlayer p_processPlayer_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processPlayer_1_, this, this.playerEntity.getServerWorld());
        if (NetHandlerPlayServer.isMovePlayerPacketInvalid(p_processPlayer_1_)) {
            this.disconnect("Invalid move player packet received");
        } else {
            WorldServer worldserver = this.serverController.worldServerForDimension(this.playerEntity.dimension);
            if (!this.playerEntity.playerConqueredTheEnd) {
                if (this.networkTickCount == 0) {
                    this.captureCurrentPosition();
                }
                if (this.targetPos != null) {
                    if (this.networkTickCount - this.lastPositionUpdate > 20) {
                        this.lastPositionUpdate = this.networkTickCount;
                        this.setPlayerLocation(this.targetPos.xCoord, this.targetPos.yCoord, this.targetPos.zCoord, this.playerEntity.rotationYaw, this.playerEntity.rotationPitch);
                    }
                } else {
                    this.lastPositionUpdate = this.networkTickCount;
                    if (this.playerEntity.isRiding()) {
                        this.playerEntity.setPositionAndRotation(this.playerEntity.posX, this.playerEntity.posY, this.playerEntity.posZ, p_processPlayer_1_.getYaw(this.playerEntity.rotationYaw), p_processPlayer_1_.getPitch(this.playerEntity.rotationPitch));
                        this.serverController.getPlayerList().serverUpdateMovingPlayer(this.playerEntity);
                    } else {
                        double d0 = this.playerEntity.posX;
                        double d1 = this.playerEntity.posY;
                        double d2 = this.playerEntity.posZ;
                        double d3 = this.playerEntity.posY;
                        double d4 = p_processPlayer_1_.getX(this.playerEntity.posX);
                        double d5 = p_processPlayer_1_.getY(this.playerEntity.posY);
                        double d6 = p_processPlayer_1_.getZ(this.playerEntity.posZ);
                        float f = p_processPlayer_1_.getYaw(this.playerEntity.rotationYaw);
                        float f1 = p_processPlayer_1_.getPitch(this.playerEntity.rotationPitch);
                        double d7 = d4 - this.firstGoodX;
                        double d8 = d5 - this.firstGoodY;
                        double d9 = d6 - this.firstGoodZ;
                        double d10 = this.playerEntity.motionX * this.playerEntity.motionX + this.playerEntity.motionY * this.playerEntity.motionY + this.playerEntity.motionZ * this.playerEntity.motionZ;
                        double d11 = d7 * d7 + d8 * d8 + d9 * d9;
                        if (this.playerEntity.isPlayerSleeping()) {
                            if (d11 > 1.0) {
                                this.setPlayerLocation(this.playerEntity.posX, this.playerEntity.posY, this.playerEntity.posZ, p_processPlayer_1_.getYaw(this.playerEntity.rotationYaw), p_processPlayer_1_.getPitch(this.playerEntity.rotationPitch));
                            }
                        } else {
                            ++this.movePacketCounter;
                            int i = this.movePacketCounter - this.lastMovePacketCounter;
                            if (i > 5) {
                                LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", new Object[]{this.playerEntity.getName(), i});
                                i = 1;
                            }
                            if (!(this.playerEntity.isInvulnerableDimensionChange() || this.playerEntity.getServerWorld().getGameRules().getBoolean("disableElytraMovementCheck") && this.playerEntity.isElytraFlying())) {
                                float f2;
                                float f3 = f2 = this.playerEntity.isElytraFlying() ? 300.0f : 100.0f;
                                if (!(!(d11 - d10 > (double)(f2 * (float)i)) || this.serverController.isSinglePlayer() && this.serverController.getServerOwner().equals(this.playerEntity.getName()))) {
                                    LOGGER.warn("{} moved too quickly! {},{},{}", new Object[]{this.playerEntity.getName(), d7, d8, d9});
                                    this.setPlayerLocation(this.playerEntity.posX, this.playerEntity.posY, this.playerEntity.posZ, this.playerEntity.rotationYaw, this.playerEntity.rotationPitch);
                                    return;
                                }
                            }
                            boolean flag2 = worldserver.getCollisionBoxes(this.playerEntity, this.playerEntity.getEntityBoundingBox().contract(0.0625)).isEmpty();
                            d7 = d4 - this.lastGoodX;
                            d8 = d5 - this.lastGoodY;
                            d9 = d6 - this.lastGoodZ;
                            if (this.playerEntity.onGround && !p_processPlayer_1_.isOnGround() && d8 > 0.0) {
                                this.playerEntity.jump();
                            }
                            this.playerEntity.move(MoverType.PLAYER, d7, d8, d9);
                            this.playerEntity.onGround = p_processPlayer_1_.isOnGround();
                            double d12 = d8;
                            d7 = d4 - this.playerEntity.posX;
                            d8 = d5 - this.playerEntity.posY;
                            if (d8 > -0.5 || d8 < 0.5) {
                                d8 = 0.0;
                            }
                            d9 = d6 - this.playerEntity.posZ;
                            d11 = d7 * d7 + d8 * d8 + d9 * d9;
                            boolean flag = false;
                            if (!this.playerEntity.isInvulnerableDimensionChange() && d11 > 0.0625 && !this.playerEntity.isPlayerSleeping() && !this.playerEntity.interactionManager.isCreative() && this.playerEntity.interactionManager.getGameType() != GameType.SPECTATOR) {
                                flag = true;
                                LOGGER.warn("{} moved wrongly!", new Object[]{this.playerEntity.getName()});
                            }
                            this.playerEntity.setPositionAndRotation(d4, d5, d6, f, f1);
                            this.playerEntity.addMovementStat(this.playerEntity.posX - d0, this.playerEntity.posY - d1, this.playerEntity.posZ - d2);
                            if (!this.playerEntity.noClip && !this.playerEntity.isPlayerSleeping()) {
                                boolean flag1 = worldserver.getCollisionBoxes(this.playerEntity, this.playerEntity.getEntityBoundingBox().contract(0.0625)).isEmpty();
                                if (flag2 && (flag || !flag1)) {
                                    this.setPlayerLocation(d0, d1, d2, f, f1);
                                    return;
                                }
                            }
                            this.floating = d12 >= -0.03125;
                            this.floating &= !this.serverController.isFlightAllowed() && !this.playerEntity.capabilities.allowFlying;
                            this.floating &= !this.playerEntity.isPotionActive(MobEffects.LEVITATION) && !this.playerEntity.isElytraFlying() && !worldserver.checkBlockCollision(this.playerEntity.getEntityBoundingBox().expandXyz(0.0625).addCoord(0.0, -0.55, 0.0));
                            this.playerEntity.onGround = p_processPlayer_1_.isOnGround();
                            this.serverController.getPlayerList().serverUpdateMovingPlayer(this.playerEntity);
                            this.playerEntity.handleFalling(this.playerEntity.posY - d3, p_processPlayer_1_.isOnGround());
                            this.lastGoodX = this.playerEntity.posX;
                            this.lastGoodY = this.playerEntity.posY;
                            this.lastGoodZ = this.playerEntity.posZ;
                        }
                    }
                }
            }
        }
    }

    public void setPlayerLocation(double p_setPlayerLocation_1_, double p_setPlayerLocation_3_, double p_setPlayerLocation_5_, float p_setPlayerLocation_7_, float p_setPlayerLocation_8_) {
        this.setPlayerLocation(p_setPlayerLocation_1_, p_setPlayerLocation_3_, p_setPlayerLocation_5_, p_setPlayerLocation_7_, p_setPlayerLocation_8_, Collections.<SPacketPlayerPosLook.EnumFlags>emptySet());
    }

    public void setPlayerLocation(double p_setPlayerLocation_1_, double p_setPlayerLocation_3_, double p_setPlayerLocation_5_, float p_setPlayerLocation_7_, float p_setPlayerLocation_8_, Set<SPacketPlayerPosLook.EnumFlags> p_setPlayerLocation_9_) {
        double d0 = p_setPlayerLocation_9_.contains((Object)SPacketPlayerPosLook.EnumFlags.X) ? this.playerEntity.posX : 0.0;
        double d1 = p_setPlayerLocation_9_.contains((Object)SPacketPlayerPosLook.EnumFlags.Y) ? this.playerEntity.posY : 0.0;
        double d2 = p_setPlayerLocation_9_.contains((Object)SPacketPlayerPosLook.EnumFlags.Z) ? this.playerEntity.posZ : 0.0;
        this.targetPos = new Vec3d(p_setPlayerLocation_1_ + d0, p_setPlayerLocation_3_ + d1, p_setPlayerLocation_5_ + d2);
        float f = p_setPlayerLocation_7_;
        float f1 = p_setPlayerLocation_8_;
        if (p_setPlayerLocation_9_.contains((Object)SPacketPlayerPosLook.EnumFlags.Y_ROT)) {
            f = p_setPlayerLocation_7_ + this.playerEntity.rotationYaw;
        }
        if (p_setPlayerLocation_9_.contains((Object)SPacketPlayerPosLook.EnumFlags.X_ROT)) {
            f1 = p_setPlayerLocation_8_ + this.playerEntity.rotationPitch;
        }
        if (++this.teleportId == Integer.MAX_VALUE) {
            this.teleportId = 0;
        }
        this.lastPositionUpdate = this.networkTickCount;
        this.playerEntity.setPositionAndRotation(this.targetPos.xCoord, this.targetPos.yCoord, this.targetPos.zCoord, f, f1);
        this.playerEntity.connection.sendPacket(new SPacketPlayerPosLook(p_setPlayerLocation_1_, p_setPlayerLocation_3_, p_setPlayerLocation_5_, p_setPlayerLocation_7_, p_setPlayerLocation_8_, p_setPlayerLocation_9_, this.teleportId));
    }

    @Override
    public void processPlayerDigging(CPacketPlayerDigging p_processPlayerDigging_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processPlayerDigging_1_, this, this.playerEntity.getServerWorld());
        WorldServer worldserver = this.serverController.worldServerForDimension(this.playerEntity.dimension);
        BlockPos blockpos = p_processPlayerDigging_1_.getPosition();
        this.playerEntity.markPlayerActive();
        switch (p_processPlayerDigging_1_.getAction()) {
            case SWAP_HELD_ITEMS: {
                if (!this.playerEntity.isSpectator()) {
                    ItemStack itemstack = this.playerEntity.getHeldItem(EnumHand.OFF_HAND);
                    this.playerEntity.setHeldItem(EnumHand.OFF_HAND, this.playerEntity.getHeldItem(EnumHand.MAIN_HAND));
                    this.playerEntity.setHeldItem(EnumHand.MAIN_HAND, itemstack);
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.playerEntity.isSpectator()) {
                    this.playerEntity.dropItem(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.playerEntity.isSpectator()) {
                    this.playerEntity.dropItem(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.playerEntity.stopActiveHand();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                double d0 = this.playerEntity.posX - ((double)blockpos.getX() + 0.5);
                double d1 = this.playerEntity.posY - ((double)blockpos.getY() + 0.5) + 1.5;
                double d2 = this.playerEntity.posZ - ((double)blockpos.getZ() + 0.5);
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                double dist = this.playerEntity.interactionManager.getBlockReachDistance() + 1.0;
                dist *= dist;
                if (d3 > dist) {
                    return;
                }
                if (blockpos.getY() >= this.serverController.getBuildLimit()) {
                    return;
                }
                if (p_processPlayerDigging_1_.getAction() == CPacketPlayerDigging.Action.START_DESTROY_BLOCK) {
                    if (!this.serverController.isBlockProtected(worldserver, blockpos, this.playerEntity) && worldserver.getWorldBorder().contains(blockpos)) {
                        this.playerEntity.interactionManager.onBlockClicked(blockpos, p_processPlayerDigging_1_.getFacing());
                    } else {
                        this.playerEntity.connection.sendPacket(new SPacketBlockChange(worldserver, blockpos));
                    }
                } else {
                    if (p_processPlayerDigging_1_.getAction() == CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK) {
                        this.playerEntity.interactionManager.blockRemoving(blockpos);
                    } else if (p_processPlayerDigging_1_.getAction() == CPacketPlayerDigging.Action.ABORT_DESTROY_BLOCK) {
                        this.playerEntity.interactionManager.cancelDestroyingBlock();
                    }
                    if (worldserver.getBlockState(blockpos).getMaterial() != Material.AIR) {
                        this.playerEntity.connection.sendPacket(new SPacketBlockChange(worldserver, blockpos));
                    }
                }
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    @Override
    public void processTryUseItemOnBlock(CPacketPlayerTryUseItemOnBlock p_processTryUseItemOnBlock_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processTryUseItemOnBlock_1_, this, this.playerEntity.getServerWorld());
        WorldServer worldserver = this.serverController.worldServerForDimension(this.playerEntity.dimension);
        EnumHand enumhand = p_processTryUseItemOnBlock_1_.getHand();
        ItemStack itemstack = this.playerEntity.getHeldItem(enumhand);
        BlockPos blockpos = p_processTryUseItemOnBlock_1_.getPos();
        EnumFacing enumfacing = p_processTryUseItemOnBlock_1_.getDirection();
        this.playerEntity.markPlayerActive();
        if (blockpos.getY() < this.serverController.getBuildLimit() - 1 || enumfacing != EnumFacing.UP && blockpos.getY() < this.serverController.getBuildLimit()) {
            double dist = this.playerEntity.interactionManager.getBlockReachDistance() + 3.0;
            dist *= dist;
            if (this.targetPos == null && this.playerEntity.getDistanceSq((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5) < dist && !this.serverController.isBlockProtected(worldserver, blockpos, this.playerEntity) && worldserver.getWorldBorder().contains(blockpos)) {
                this.playerEntity.interactionManager.processRightClickBlock(this.playerEntity, worldserver, itemstack, enumhand, blockpos, enumfacing, p_processTryUseItemOnBlock_1_.getFacingX(), p_processTryUseItemOnBlock_1_.getFacingY(), p_processTryUseItemOnBlock_1_.getFacingZ());
            }
        } else {
            TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("build.tooHigh", this.serverController.getBuildLimit());
            textcomponenttranslation.getStyle().setColor(TextFormatting.RED);
            this.playerEntity.connection.sendPacket(new SPacketChat(textcomponenttranslation, 2));
        }
        this.playerEntity.connection.sendPacket(new SPacketBlockChange(worldserver, blockpos));
        this.playerEntity.connection.sendPacket(new SPacketBlockChange(worldserver, blockpos.offset(enumfacing)));
    }

    @Override
    public void processTryUseItem(CPacketPlayerTryUseItem p_processTryUseItem_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processTryUseItem_1_, this, this.playerEntity.getServerWorld());
        WorldServer worldserver = this.serverController.worldServerForDimension(this.playerEntity.dimension);
        EnumHand enumhand = p_processTryUseItem_1_.getHand();
        ItemStack itemstack = this.playerEntity.getHeldItem(enumhand);
        this.playerEntity.markPlayerActive();
        if (!itemstack.isEmpty()) {
            this.playerEntity.interactionManager.processRightClick(this.playerEntity, worldserver, itemstack, enumhand);
        }
    }

    @Override
    public void handleSpectate(CPacketSpectate p_handleSpectate_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleSpectate_1_, this, this.playerEntity.getServerWorld());
        if (this.playerEntity.isSpectator()) {
            Entity entity = null;
            for (WorldServer worldserver : this.serverController.worlds) {
                if (worldserver != null && (entity = p_handleSpectate_1_.getEntity(worldserver)) != null) break;
            }
            if (entity != null) {
                this.playerEntity.setSpectatingEntity(this.playerEntity);
                this.playerEntity.dismountRidingEntity();
                if (entity.world == this.playerEntity.world) {
                    this.playerEntity.setPositionAndUpdate(entity.posX, entity.posY, entity.posZ);
                } else {
                    WorldServer worldserver1 = this.playerEntity.getServerWorld();
                    WorldServer worldserver2 = (WorldServer)entity.world;
                    this.playerEntity.dimension = entity.dimension;
                    this.sendPacket(new SPacketRespawn(this.playerEntity.dimension, worldserver1.getDifficulty(), worldserver1.getWorldInfo().getTerrainType(), this.playerEntity.interactionManager.getGameType()));
                    this.serverController.getPlayerList().updatePermissionLevel(this.playerEntity);
                    worldserver1.removeEntityDangerously(this.playerEntity);
                    this.playerEntity.isDead = false;
                    this.playerEntity.setLocationAndAngles(entity.posX, entity.posY, entity.posZ, entity.rotationYaw, entity.rotationPitch);
                    if (this.playerEntity.isEntityAlive()) {
                        worldserver1.updateEntityWithOptionalForce(this.playerEntity, false);
                        worldserver2.spawnEntity(this.playerEntity);
                        worldserver2.updateEntityWithOptionalForce(this.playerEntity, false);
                    }
                    this.playerEntity.setWorld(worldserver2);
                    this.serverController.getPlayerList().preparePlayer(this.playerEntity, worldserver1);
                    this.playerEntity.setPositionAndUpdate(entity.posX, entity.posY, entity.posZ);
                    this.playerEntity.interactionManager.setWorld(worldserver2);
                    this.serverController.getPlayerList().updateTimeAndWeatherForPlayer(this.playerEntity, worldserver2);
                    this.serverController.getPlayerList().syncPlayerInventory(this.playerEntity);
                }
            }
        }
    }

    @Override
    public void handleResourcePackStatus(CPacketResourcePackStatus p_handleResourcePackStatus_1_) {
    }

    @Override
    public void processSteerBoat(CPacketSteerBoat p_processSteerBoat_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processSteerBoat_1_, this, this.playerEntity.getServerWorld());
        Entity entity = this.playerEntity.getRidingEntity();
        if (entity instanceof EntityBoat) {
            ((EntityBoat)entity).setPaddleState(p_processSteerBoat_1_.getLeft(), p_processSteerBoat_1_.getRight());
        }
    }

    @Override
    public void onDisconnect(ITextComponent p_onDisconnect_1_) {
        LOGGER.info("{} lost connection: {}", new Object[]{this.playerEntity.getName(), p_onDisconnect_1_});
        this.serverController.refreshStatusNextTick();
        TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("multiplayer.player.left", this.playerEntity.getDisplayName());
        textcomponenttranslation.getStyle().setColor(TextFormatting.YELLOW);
        this.serverController.getPlayerList().sendMessage(textcomponenttranslation);
        this.playerEntity.mountEntityAndWakeUp();
        this.serverController.getPlayerList().playerLoggedOut(this.playerEntity);
        if (this.serverController.isSinglePlayer() && this.playerEntity.getName().equals(this.serverController.getServerOwner())) {
            LOGGER.info("Stopping singleplayer server as player logged out");
            this.serverController.initiateShutdown();
        }
    }

    public void sendPacket(final Packet<?> p_sendPacket_1_) {
        if (p_sendPacket_1_ instanceof SPacketChat) {
            SPacketChat spacketchat = (SPacketChat)p_sendPacket_1_;
            EntityPlayer.EnumChatVisibility entityplayer$enumchatvisibility = this.playerEntity.getChatVisibility();
            if (entityplayer$enumchatvisibility == EntityPlayer.EnumChatVisibility.HIDDEN && spacketchat.getType() != 2) {
                return;
            }
            if (entityplayer$enumchatvisibility == EntityPlayer.EnumChatVisibility.SYSTEM && !spacketchat.isSystem()) {
                return;
            }
        }
        try {
            this.netManager.sendPacket(p_sendPacket_1_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Sending packet");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Packet being sent");
            crashreportcategory.setDetail("Packet class", new ICrashReportDetail<String>(){

                @Override
                public String call() throws Exception {
                    return p_sendPacket_1_.getClass().getCanonicalName();
                }
            });
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void processHeldItemChange(CPacketHeldItemChange p_processHeldItemChange_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processHeldItemChange_1_, this, this.playerEntity.getServerWorld());
        if (p_processHeldItemChange_1_.getSlotId() >= 0 && p_processHeldItemChange_1_.getSlotId() < InventoryPlayer.getHotbarSize()) {
            this.playerEntity.inventory.currentItem = p_processHeldItemChange_1_.getSlotId();
            this.playerEntity.markPlayerActive();
        } else {
            LOGGER.warn("{} tried to set an invalid carried item", new Object[]{this.playerEntity.getName()});
        }
    }

    @Override
    public void processChatMessage(CPacketChatMessage p_processChatMessage_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processChatMessage_1_, this, this.playerEntity.getServerWorld());
        if (this.playerEntity.getChatVisibility() == EntityPlayer.EnumChatVisibility.HIDDEN) {
            TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("chat.cannotSend", new Object[0]);
            textcomponenttranslation.getStyle().setColor(TextFormatting.RED);
            this.sendPacket(new SPacketChat(textcomponenttranslation));
        } else {
            this.playerEntity.markPlayerActive();
            String s = p_processChatMessage_1_.getMessage();
            s = org.apache.commons.lang3.StringUtils.normalizeSpace((String)s);
            for (int i = 0; i < s.length(); ++i) {
                if (ChatAllowedCharacters.isAllowedCharacter(s.charAt(i))) continue;
                this.disconnect("Illegal characters in chat");
                return;
            }
            if (s.startsWith("/")) {
                this.handleSlashCommand(s);
            } else {
                ITextComponent itextcomponent = new TextComponentTranslation("chat.type.text", this.playerEntity.getDisplayName(), ForgeHooks.newChatWithLinks(s));
                if ((itextcomponent = ForgeHooks.onServerChatEvent(this, s, itextcomponent)) == null) {
                    return;
                }
                this.serverController.getPlayerList().sendMessage(itextcomponent, false);
            }
            this.chatSpamThresholdCount += 20;
            if (this.chatSpamThresholdCount > 200 && !this.serverController.getPlayerList().canSendCommands(this.playerEntity.getGameProfile())) {
                this.disconnect("disconnect.spam");
            }
        }
    }

    private void handleSlashCommand(String p_handleSlashCommand_1_) {
        this.serverController.getCommandManager().executeCommand(this.playerEntity, p_handleSlashCommand_1_);
    }

    @Override
    public void handleAnimation(CPacketAnimation p_handleAnimation_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_handleAnimation_1_, this, this.playerEntity.getServerWorld());
        this.playerEntity.markPlayerActive();
        this.playerEntity.swingArm(p_handleAnimation_1_.getHand());
    }

    @Override
    public void processEntityAction(CPacketEntityAction p_processEntityAction_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processEntityAction_1_, this, this.playerEntity.getServerWorld());
        this.playerEntity.markPlayerActive();
        switch (p_processEntityAction_1_.getAction()) {
            case START_SNEAKING: {
                this.playerEntity.setSneaking(true);
                break;
            }
            case STOP_SNEAKING: {
                this.playerEntity.setSneaking(false);
                break;
            }
            case START_SPRINTING: {
                this.playerEntity.setSprinting(true);
                break;
            }
            case STOP_SPRINTING: {
                this.playerEntity.setSprinting(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.playerEntity.isPlayerSleeping()) break;
                this.playerEntity.wakeUpPlayer(false, true, true);
                this.targetPos = new Vec3d(this.playerEntity.posX, this.playerEntity.posY, this.playerEntity.posZ);
                break;
            }
            case START_RIDING_JUMP: {
                if (!(this.playerEntity.getRidingEntity() instanceof IJumpingMount)) break;
                IJumpingMount ijumpingmount1 = (IJumpingMount)((Object)this.playerEntity.getRidingEntity());
                int i = p_processEntityAction_1_.getAuxData();
                if (!ijumpingmount1.canJump() || i <= 0) break;
                ijumpingmount1.handleStartJump(i);
                break;
            }
            case STOP_RIDING_JUMP: {
                if (!(this.playerEntity.getRidingEntity() instanceof IJumpingMount)) break;
                IJumpingMount ijumpingmount = (IJumpingMount)((Object)this.playerEntity.getRidingEntity());
                ijumpingmount.handleStopJump();
                break;
            }
            case OPEN_INVENTORY: {
                if (!(this.playerEntity.getRidingEntity() instanceof AbstractHorse)) break;
                ((AbstractHorse)this.playerEntity.getRidingEntity()).openGUI(this.playerEntity);
                break;
            }
            case START_FALL_FLYING: {
                if (!this.playerEntity.onGround && this.playerEntity.motionY < 0.0 && !this.playerEntity.isElytraFlying() && !this.playerEntity.isInWater()) {
                    ItemStack itemstack = this.playerEntity.getItemStackFromSlot(EntityEquipmentSlot.CHEST);
                    if (itemstack.getItem() != Items.ELYTRA || !ItemElytra.isBroken(itemstack)) break;
                    this.playerEntity.setElytraFlying();
                    break;
                }
                this.playerEntity.clearElytraFlying();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    @Override
    public void processUseEntity(CPacketUseEntity p_processUseEntity_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processUseEntity_1_, this, this.playerEntity.getServerWorld());
        WorldServer worldserver = this.serverController.worldServerForDimension(this.playerEntity.dimension);
        Entity entity = p_processUseEntity_1_.getEntityFromWorld(worldserver);
        this.playerEntity.markPlayerActive();
        if (entity != null) {
            boolean flag = this.playerEntity.canEntityBeSeen(entity);
            double d0 = 36.0;
            if (!flag) {
                d0 = 9.0;
            }
            if (this.playerEntity.getDistanceSqToEntity(entity) < d0) {
                if (p_processUseEntity_1_.getAction() == CPacketUseEntity.Action.INTERACT) {
                    EnumHand enumhand = p_processUseEntity_1_.getHand();
                    this.playerEntity.interactOn(entity, enumhand);
                } else if (p_processUseEntity_1_.getAction() == CPacketUseEntity.Action.INTERACT_AT) {
                    EnumHand enumhand1 = p_processUseEntity_1_.getHand();
                    if (ForgeHooks.onInteractEntityAt((EntityPlayer)this.playerEntity, entity, p_processUseEntity_1_.getHitVec(), enumhand1)) {
                        return;
                    }
                    entity.applyPlayerInteraction(this.playerEntity, p_processUseEntity_1_.getHitVec(), enumhand1);
                } else if (p_processUseEntity_1_.getAction() == CPacketUseEntity.Action.ATTACK) {
                    if (entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow || entity == this.playerEntity) {
                        this.disconnect("Attempting to attack an invalid entity");
                        this.serverController.logWarning("Player " + this.playerEntity.getName() + " tried to attack an invalid entity");
                        return;
                    }
                    this.playerEntity.attackTargetEntityWithCurrentItem(entity);
                }
            }
        }
    }

    @Override
    public void processClientStatus(CPacketClientStatus p_processClientStatus_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processClientStatus_1_, this, this.playerEntity.getServerWorld());
        this.playerEntity.markPlayerActive();
        CPacketClientStatus.State cpacketclientstatus$state = p_processClientStatus_1_.getStatus();
        switch (cpacketclientstatus$state) {
            case PERFORM_RESPAWN: {
                if (this.playerEntity.playerConqueredTheEnd) {
                    this.playerEntity.playerConqueredTheEnd = false;
                    this.playerEntity = this.serverController.getPlayerList().recreatePlayerEntity(this.playerEntity, 0, true);
                    break;
                }
                if (this.playerEntity.getHealth() > 0.0f) {
                    return;
                }
                this.playerEntity = this.serverController.getPlayerList().recreatePlayerEntity(this.playerEntity, this.playerEntity.dimension, false);
                if (!this.serverController.isHardcore()) break;
                this.playerEntity.setGameType(GameType.SPECTATOR);
                this.playerEntity.getServerWorld().getGameRules().setOrCreateGameRule("spectatorsGenerateChunks", "false");
                break;
            }
            case REQUEST_STATS: {
                this.playerEntity.getStatFile().sendStats(this.playerEntity);
                break;
            }
            case OPEN_INVENTORY_ACHIEVEMENT: {
                this.playerEntity.addStat(AchievementList.OPEN_INVENTORY);
            }
        }
    }

    @Override
    public void processCloseWindow(CPacketCloseWindow p_processCloseWindow_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processCloseWindow_1_, this, this.playerEntity.getServerWorld());
        this.playerEntity.closeContainer();
    }

    @Override
    public void processClickWindow(CPacketClickWindow p_processClickWindow_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processClickWindow_1_, this, this.playerEntity.getServerWorld());
        this.playerEntity.markPlayerActive();
        if (this.playerEntity.openContainer.windowId == p_processClickWindow_1_.getWindowId() && this.playerEntity.openContainer.getCanCraft(this.playerEntity)) {
            if (this.playerEntity.isSpectator()) {
                NonNullList<ItemStack> nonnulllist = NonNullList.create();
                for (int i = 0; i < this.playerEntity.openContainer.inventorySlots.size(); ++i) {
                    nonnulllist.add(this.playerEntity.openContainer.inventorySlots.get(i).getStack());
                }
                this.playerEntity.updateCraftingInventory(this.playerEntity.openContainer, nonnulllist);
            } else {
                ItemStack itemstack2 = this.playerEntity.openContainer.slotClick(p_processClickWindow_1_.getSlotId(), p_processClickWindow_1_.getUsedButton(), p_processClickWindow_1_.getClickType(), this.playerEntity);
                if (ItemStack.areItemStacksEqual(p_processClickWindow_1_.getClickedItem(), itemstack2)) {
                    this.playerEntity.connection.sendPacket(new SPacketConfirmTransaction(p_processClickWindow_1_.getWindowId(), p_processClickWindow_1_.getActionNumber(), true));
                    this.playerEntity.isChangingQuantityOnly = true;
                    this.playerEntity.openContainer.detectAndSendChanges();
                    this.playerEntity.updateHeldItem();
                    this.playerEntity.isChangingQuantityOnly = false;
                } else {
                    this.pendingTransactions.addKey(this.playerEntity.openContainer.windowId, p_processClickWindow_1_.getActionNumber());
                    this.playerEntity.connection.sendPacket(new SPacketConfirmTransaction(p_processClickWindow_1_.getWindowId(), p_processClickWindow_1_.getActionNumber(), false));
                    this.playerEntity.openContainer.setCanCraft(this.playerEntity, false);
                    NonNullList<ItemStack> nonnulllist1 = NonNullList.create();
                    for (int j = 0; j < this.playerEntity.openContainer.inventorySlots.size(); ++j) {
                        ItemStack itemstack = this.playerEntity.openContainer.inventorySlots.get(j).getStack();
                        ItemStack itemstack1 = itemstack.isEmpty() ? ItemStack.EMPTY : itemstack;
                        nonnulllist1.add(itemstack1);
                    }
                    this.playerEntity.updateCraftingInventory(this.playerEntity.openContainer, nonnulllist1);
                }
            }
        }
    }

    @Override
    public void processEnchantItem(CPacketEnchantItem p_processEnchantItem_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processEnchantItem_1_, this, this.playerEntity.getServerWorld());
        this.playerEntity.markPlayerActive();
        if (this.playerEntity.openContainer.windowId == p_processEnchantItem_1_.getWindowId() && this.playerEntity.openContainer.getCanCraft(this.playerEntity) && !this.playerEntity.isSpectator()) {
            this.playerEntity.openContainer.enchantItem(this.playerEntity, p_processEnchantItem_1_.getButton());
            this.playerEntity.openContainer.detectAndSendChanges();
        }
    }

    @Override
    public void processCreativeInventoryAction(CPacketCreativeInventoryAction p_processCreativeInventoryAction_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processCreativeInventoryAction_1_, this, this.playerEntity.getServerWorld());
        if (this.playerEntity.interactionManager.isCreative()) {
            boolean flag2;
            BlockPos blockpos;
            TileEntity tileentity;
            NBTTagCompound nbttagcompound;
            boolean flag = p_processCreativeInventoryAction_1_.getSlotId() < 0;
            ItemStack itemstack = p_processCreativeInventoryAction_1_.getStack();
            if (!itemstack.isEmpty() && itemstack.hasTagCompound() && itemstack.getTagCompound().hasKey("BlockEntityTag", 10) && (nbttagcompound = itemstack.getTagCompound().getCompoundTag("BlockEntityTag")).hasKey("x") && nbttagcompound.hasKey("y") && nbttagcompound.hasKey("z") && (tileentity = this.playerEntity.world.getTileEntity(blockpos = new BlockPos(nbttagcompound.getInteger("x"), nbttagcompound.getInteger("y"), nbttagcompound.getInteger("z")))) != null) {
                NBTTagCompound nbttagcompound1 = tileentity.writeToNBT(new NBTTagCompound());
                nbttagcompound1.removeTag("x");
                nbttagcompound1.removeTag("y");
                nbttagcompound1.removeTag("z");
                itemstack.setTagInfo("BlockEntityTag", nbttagcompound1);
            }
            boolean flag1 = p_processCreativeInventoryAction_1_.getSlotId() >= 1 && p_processCreativeInventoryAction_1_.getSlotId() <= 45;
            boolean bl = flag2 = itemstack.isEmpty() || itemstack.getMetadata() >= 0 && itemstack.getCount() <= 64 && !itemstack.isEmpty();
            if (flag1 && flag2) {
                if (itemstack.isEmpty()) {
                    this.playerEntity.inventoryContainer.putStackInSlot(p_processCreativeInventoryAction_1_.getSlotId(), ItemStack.EMPTY);
                } else {
                    this.playerEntity.inventoryContainer.putStackInSlot(p_processCreativeInventoryAction_1_.getSlotId(), itemstack);
                }
                this.playerEntity.inventoryContainer.setCanCraft(this.playerEntity, true);
            } else if (flag && flag2 && this.itemDropThreshold < 200) {
                this.itemDropThreshold += 20;
                EntityItem entityitem = this.playerEntity.dropItem(itemstack, true);
                if (entityitem != null) {
                    entityitem.setAgeToCreativeDespawnTime();
                }
            }
        }
    }

    @Override
    public void processConfirmTransaction(CPacketConfirmTransaction p_processConfirmTransaction_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processConfirmTransaction_1_, this, this.playerEntity.getServerWorld());
        Short oshort = this.pendingTransactions.lookup(this.playerEntity.openContainer.windowId);
        if (oshort != null && p_processConfirmTransaction_1_.getUid() == oshort.shortValue() && this.playerEntity.openContainer.windowId == p_processConfirmTransaction_1_.getWindowId() && !this.playerEntity.openContainer.getCanCraft(this.playerEntity) && !this.playerEntity.isSpectator()) {
            this.playerEntity.openContainer.setCanCraft(this.playerEntity, true);
        }
    }

    @Override
    public void processUpdateSign(CPacketUpdateSign p_processUpdateSign_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processUpdateSign_1_, this, this.playerEntity.getServerWorld());
        this.playerEntity.markPlayerActive();
        WorldServer worldserver = this.serverController.worldServerForDimension(this.playerEntity.dimension);
        BlockPos blockpos = p_processUpdateSign_1_.getPosition();
        if (worldserver.isBlockLoaded(blockpos)) {
            IBlockState iblockstate = worldserver.getBlockState(blockpos);
            TileEntity tileentity = worldserver.getTileEntity(blockpos);
            if (!(tileentity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            if (!tileentitysign.getIsEditable() || tileentitysign.getPlayer() != this.playerEntity) {
                this.serverController.logWarning("Player " + this.playerEntity.getName() + " just tried to change non-editable sign");
                return;
            }
            String[] astring = p_processUpdateSign_1_.getLines();
            for (int i = 0; i < astring.length; ++i) {
                tileentitysign.signText[i] = new TextComponentString(TextFormatting.getTextWithoutFormattingCodes(astring[i]));
            }
            tileentitysign.markDirty();
            worldserver.notifyBlockUpdate(blockpos, iblockstate, iblockstate, 3);
        }
    }

    @Override
    public void processKeepAlive(CPacketKeepAlive p_processKeepAlive_1_) {
        if (p_processKeepAlive_1_.getKey() == this.keepAliveId) {
            int i = (int)(this.currentTimeMillis() - this.lastPingTime);
            this.playerEntity.ping = (this.playerEntity.ping * 3 + i) / 4;
        }
    }

    private long currentTimeMillis() {
        return System.nanoTime() / 1000000L;
    }

    @Override
    public void processPlayerAbilities(CPacketPlayerAbilities p_processPlayerAbilities_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processPlayerAbilities_1_, this, this.playerEntity.getServerWorld());
        this.playerEntity.capabilities.isFlying = p_processPlayerAbilities_1_.isFlying() && this.playerEntity.capabilities.allowFlying;
    }

    @Override
    public void processTabComplete(CPacketTabComplete p_processTabComplete_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processTabComplete_1_, this, this.playerEntity.getServerWorld());
        ArrayList list = Lists.newArrayList();
        for (String s : this.serverController.getTabCompletions(this.playerEntity, p_processTabComplete_1_.getMessage(), p_processTabComplete_1_.getTargetBlock(), p_processTabComplete_1_.hasTargetBlock())) {
            list.add(s);
        }
        this.playerEntity.connection.sendPacket(new SPacketTabComplete(list.toArray(new String[list.size()])));
    }

    @Override
    public void processClientSettings(CPacketClientSettings p_processClientSettings_1_) {
        PacketThreadUtil.checkThreadAndEnqueue(p_processClientSettings_1_, this, this.playerEntity.getServerWorld());
        this.playerEntity.handleClientSettings(p_processClientSettings_1_);
    }

    @Override
    public void processCustomPayload(CPacketCustomPayload p_processCustomPayload_1_) {
        block82: {
            PacketThreadUtil.checkThreadAndEnqueue(p_processCustomPayload_1_, this, this.playerEntity.getServerWorld());
            String s = p_processCustomPayload_1_.getChannelName();
            if ("MC|BEdit".equals(s)) {
                PacketBuffer packetbuffer = p_processCustomPayload_1_.getBufferData();
                try {
                    ItemStack itemstack = packetbuffer.readItemStack();
                    if (itemstack.isEmpty()) {
                        return;
                    }
                    if (!ItemWritableBook.isNBTValid(itemstack.getTagCompound())) {
                        throw new IOException("Invalid book tag!");
                    }
                    ItemStack itemstack1 = this.playerEntity.getHeldItemMainhand();
                    if (itemstack1.isEmpty()) {
                        return;
                    }
                    if (itemstack.getItem() == Items.WRITABLE_BOOK && itemstack.getItem() == itemstack1.getItem()) {
                        itemstack1.setTagInfo("pages", itemstack.getTagCompound().getTagList("pages", 8));
                    }
                }
                catch (Exception exception6) {
                    LOGGER.error("Couldn't handle book info", (Throwable)exception6);
                }
            } else if ("MC|BSign".equals(s)) {
                PacketBuffer packetbuffer1 = p_processCustomPayload_1_.getBufferData();
                try {
                    ItemStack itemstack3 = packetbuffer1.readItemStack();
                    if (itemstack3.isEmpty()) {
                        return;
                    }
                    if (!ItemWrittenBook.validBookTagContents(itemstack3.getTagCompound())) {
                        throw new IOException("Invalid book tag!");
                    }
                    ItemStack itemstack4 = this.playerEntity.getHeldItemMainhand();
                    if (itemstack4.isEmpty()) {
                        return;
                    }
                    if (itemstack3.getItem() == Items.WRITABLE_BOOK && itemstack4.getItem() == Items.WRITABLE_BOOK) {
                        ItemStack itemstack2 = new ItemStack(Items.WRITTEN_BOOK);
                        itemstack2.setTagInfo("author", new NBTTagString(this.playerEntity.getName()));
                        itemstack2.setTagInfo("title", new NBTTagString(itemstack3.getTagCompound().getString("title")));
                        NBTTagList nbttaglist = itemstack3.getTagCompound().getTagList("pages", 8);
                        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                            String s1 = nbttaglist.getStringTagAt(i);
                            TextComponentString itextcomponent = new TextComponentString(s1);
                            s1 = ITextComponent.Serializer.componentToJson(itextcomponent);
                            nbttaglist.set(i, new NBTTagString(s1));
                        }
                        itemstack2.setTagInfo("pages", nbttaglist);
                        this.playerEntity.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, itemstack2);
                    }
                }
                catch (Exception exception7) {
                    LOGGER.error("Couldn't sign book", (Throwable)exception7);
                }
            } else if ("MC|TrSel".equals(s)) {
                try {
                    int k = p_processCustomPayload_1_.getBufferData().readInt();
                    Container container = this.playerEntity.openContainer;
                    if (container instanceof ContainerMerchant) {
                        ((ContainerMerchant)container).setCurrentRecipeIndex(k);
                    }
                }
                catch (Exception exception5) {
                    LOGGER.error("Couldn't select trade", (Throwable)exception5);
                }
            } else if ("MC|AdvCmd".equals(s)) {
                if (!this.serverController.isCommandBlockEnabled()) {
                    this.playerEntity.sendMessage(new TextComponentTranslation("advMode.notEnabled", new Object[0]));
                    return;
                }
                if (!this.playerEntity.canUseCommandBlock()) {
                    this.playerEntity.sendMessage(new TextComponentTranslation("advMode.notAllowed", new Object[0]));
                    return;
                }
                PacketBuffer packetbuffer2 = p_processCustomPayload_1_.getBufferData();
                try {
                    Entity entity;
                    byte l = packetbuffer2.readByte();
                    CommandBlockBaseLogic commandblockbaselogic1 = null;
                    if (l == 0) {
                        TileEntity tileentity = this.playerEntity.world.getTileEntity(new BlockPos(packetbuffer2.readInt(), packetbuffer2.readInt(), packetbuffer2.readInt()));
                        if (tileentity instanceof TileEntityCommandBlock) {
                            commandblockbaselogic1 = ((TileEntityCommandBlock)tileentity).getCommandBlockLogic();
                        }
                    } else if (l == 1 && (entity = this.playerEntity.world.getEntityByID(packetbuffer2.readInt())) instanceof EntityMinecartCommandBlock) {
                        commandblockbaselogic1 = ((EntityMinecartCommandBlock)entity).getCommandBlockLogic();
                    }
                    String s6 = packetbuffer2.readString(packetbuffer2.readableBytes());
                    boolean flag2 = packetbuffer2.readBoolean();
                    if (commandblockbaselogic1 != null) {
                        commandblockbaselogic1.setCommand(s6);
                        commandblockbaselogic1.setTrackOutput(flag2);
                        if (!flag2) {
                            commandblockbaselogic1.setLastOutput(null);
                        }
                        commandblockbaselogic1.updateCommand();
                        this.playerEntity.sendMessage(new TextComponentTranslation("advMode.setCommand.success", s6));
                    }
                }
                catch (Exception exception4) {
                    LOGGER.error("Couldn't set command block", (Throwable)exception4);
                }
            } else if ("MC|AutoCmd".equals(s)) {
                if (!this.serverController.isCommandBlockEnabled()) {
                    this.playerEntity.sendMessage(new TextComponentTranslation("advMode.notEnabled", new Object[0]));
                    return;
                }
                if (!this.playerEntity.canUseCommandBlock()) {
                    this.playerEntity.sendMessage(new TextComponentTranslation("advMode.notAllowed", new Object[0]));
                    return;
                }
                PacketBuffer packetbuffer3 = p_processCustomPayload_1_.getBufferData();
                try {
                    CommandBlockBaseLogic commandblockbaselogic = null;
                    TileEntityCommandBlock tileentitycommandblock = null;
                    BlockPos blockpos1 = new BlockPos(packetbuffer3.readInt(), packetbuffer3.readInt(), packetbuffer3.readInt());
                    TileEntity tileentity2 = this.playerEntity.world.getTileEntity(blockpos1);
                    if (tileentity2 instanceof TileEntityCommandBlock) {
                        tileentitycommandblock = (TileEntityCommandBlock)tileentity2;
                        commandblockbaselogic = tileentitycommandblock.getCommandBlockLogic();
                    }
                    String s7 = packetbuffer3.readString(packetbuffer3.readableBytes());
                    boolean flag3 = packetbuffer3.readBoolean();
                    TileEntityCommandBlock.Mode tileentitycommandblock$mode = TileEntityCommandBlock.Mode.valueOf(packetbuffer3.readString(16));
                    boolean flag = packetbuffer3.readBoolean();
                    boolean flag1 = packetbuffer3.readBoolean();
                    if (commandblockbaselogic == null) break block82;
                    EnumFacing enumfacing = this.playerEntity.world.getBlockState(blockpos1).getValue(BlockCommandBlock.FACING);
                    switch (tileentitycommandblock$mode) {
                        case SEQUENCE: {
                            IBlockState iblockstate3 = Blocks.CHAIN_COMMAND_BLOCK.getDefaultState();
                            this.playerEntity.world.setBlockState(blockpos1, iblockstate3.withProperty(BlockCommandBlock.FACING, enumfacing).withProperty(BlockCommandBlock.CONDITIONAL, flag), 2);
                            break;
                        }
                        case AUTO: {
                            IBlockState iblockstate2 = Blocks.REPEATING_COMMAND_BLOCK.getDefaultState();
                            this.playerEntity.world.setBlockState(blockpos1, iblockstate2.withProperty(BlockCommandBlock.FACING, enumfacing).withProperty(BlockCommandBlock.CONDITIONAL, flag), 2);
                            break;
                        }
                        case REDSTONE: {
                            IBlockState iblockstate = Blocks.COMMAND_BLOCK.getDefaultState();
                            this.playerEntity.world.setBlockState(blockpos1, iblockstate.withProperty(BlockCommandBlock.FACING, enumfacing).withProperty(BlockCommandBlock.CONDITIONAL, flag), 2);
                        }
                    }
                    tileentity2.validate();
                    this.playerEntity.world.setTileEntity(blockpos1, tileentity2);
                    commandblockbaselogic.setCommand(s7);
                    commandblockbaselogic.setTrackOutput(flag3);
                    if (!flag3) {
                        commandblockbaselogic.setLastOutput(null);
                    }
                    tileentitycommandblock.setAuto(flag1);
                    commandblockbaselogic.updateCommand();
                    if (!StringUtils.isNullOrEmpty(s7)) {
                        this.playerEntity.sendMessage(new TextComponentTranslation("advMode.setCommand.success", s7));
                    }
                }
                catch (Exception exception3) {
                    LOGGER.error("Couldn't set command block", (Throwable)exception3);
                }
            } else if ("MC|Beacon".equals(s)) {
                if (this.playerEntity.openContainer instanceof ContainerBeacon) {
                    try {
                        PacketBuffer packetbuffer4 = p_processCustomPayload_1_.getBufferData();
                        int i1 = packetbuffer4.readInt();
                        int k1 = packetbuffer4.readInt();
                        ContainerBeacon containerbeacon = (ContainerBeacon)this.playerEntity.openContainer;
                        Slot slot = containerbeacon.getSlot(0);
                        if (slot.getHasStack()) {
                            slot.decrStackSize(1);
                            IInventory iinventory = containerbeacon.getTileEntity();
                            iinventory.setField(1, i1);
                            iinventory.setField(2, k1);
                            iinventory.markDirty();
                        }
                    }
                    catch (Exception exception2) {
                        LOGGER.error("Couldn't set beacon", (Throwable)exception2);
                    }
                }
            } else if ("MC|ItemName".equals(s)) {
                if (this.playerEntity.openContainer instanceof ContainerRepair) {
                    ContainerRepair containerrepair = (ContainerRepair)this.playerEntity.openContainer;
                    if (p_processCustomPayload_1_.getBufferData() != null && p_processCustomPayload_1_.getBufferData().readableBytes() >= 1) {
                        String s5 = ChatAllowedCharacters.filterAllowedCharacters(p_processCustomPayload_1_.getBufferData().readString(Short.MAX_VALUE));
                        if (s5.length() <= 30) {
                            containerrepair.updateItemName(s5);
                        }
                    } else {
                        containerrepair.updateItemName("");
                    }
                }
            } else if ("MC|Struct".equals(s)) {
                if (!this.playerEntity.canUseCommandBlock()) {
                    return;
                }
                PacketBuffer packetbuffer5 = p_processCustomPayload_1_.getBufferData();
                try {
                    BlockPos blockpos = new BlockPos(packetbuffer5.readInt(), packetbuffer5.readInt(), packetbuffer5.readInt());
                    IBlockState iblockstate1 = this.playerEntity.world.getBlockState(blockpos);
                    TileEntity tileentity1 = this.playerEntity.world.getTileEntity(blockpos);
                    if (tileentity1 instanceof TileEntityStructure) {
                        TileEntityStructure tileentitystructure = (TileEntityStructure)tileentity1;
                        byte l1 = packetbuffer5.readByte();
                        String s8 = packetbuffer5.readString(32);
                        tileentitystructure.setMode(TileEntityStructure.Mode.valueOf(s8));
                        tileentitystructure.setName(packetbuffer5.readString(64));
                        int i2 = MathHelper.clamp(packetbuffer5.readInt(), -32, 32);
                        int j2 = MathHelper.clamp(packetbuffer5.readInt(), -32, 32);
                        int k2 = MathHelper.clamp(packetbuffer5.readInt(), -32, 32);
                        tileentitystructure.setPosition(new BlockPos(i2, j2, k2));
                        int l2 = MathHelper.clamp(packetbuffer5.readInt(), 0, 32);
                        int i3 = MathHelper.clamp(packetbuffer5.readInt(), 0, 32);
                        int j = MathHelper.clamp(packetbuffer5.readInt(), 0, 32);
                        tileentitystructure.setSize(new BlockPos(l2, i3, j));
                        String s2 = packetbuffer5.readString(32);
                        tileentitystructure.setMirror(Mirror.valueOf(s2));
                        String s3 = packetbuffer5.readString(32);
                        tileentitystructure.setRotation(Rotation.valueOf(s3));
                        tileentitystructure.setMetadata(packetbuffer5.readString(128));
                        tileentitystructure.setIgnoresEntities(packetbuffer5.readBoolean());
                        tileentitystructure.setShowAir(packetbuffer5.readBoolean());
                        tileentitystructure.setShowBoundingBox(packetbuffer5.readBoolean());
                        tileentitystructure.setIntegrity(MathHelper.clamp(packetbuffer5.readFloat(), 0.0f, 1.0f));
                        tileentitystructure.setSeed(packetbuffer5.readVarLong());
                        String s4 = tileentitystructure.getName();
                        if (l1 == 2) {
                            if (tileentitystructure.save()) {
                                this.playerEntity.sendStatusMessage(new TextComponentTranslation("structure_block.save_success", s4), false);
                            } else {
                                this.playerEntity.sendStatusMessage(new TextComponentTranslation("structure_block.save_failure", s4), false);
                            }
                        } else if (l1 == 3) {
                            if (!tileentitystructure.isStructureLoadable()) {
                                this.playerEntity.sendStatusMessage(new TextComponentTranslation("structure_block.load_not_found", s4), false);
                            } else if (tileentitystructure.load()) {
                                this.playerEntity.sendStatusMessage(new TextComponentTranslation("structure_block.load_success", s4), false);
                            } else {
                                this.playerEntity.sendStatusMessage(new TextComponentTranslation("structure_block.load_prepare", s4), false);
                            }
                        } else if (l1 == 4) {
                            if (tileentitystructure.detectSize()) {
                                this.playerEntity.sendStatusMessage(new TextComponentTranslation("structure_block.size_success", s4), false);
                            } else {
                                this.playerEntity.sendStatusMessage(new TextComponentTranslation("structure_block.size_failure", new Object[0]), false);
                            }
                        }
                        tileentitystructure.markDirty();
                        this.playerEntity.world.notifyBlockUpdate(blockpos, iblockstate1, iblockstate1, 3);
                    }
                }
                catch (Exception exception1) {
                    LOGGER.error("Couldn't set structure block", (Throwable)exception1);
                }
            } else if ("MC|PickItem".equals(s)) {
                PacketBuffer packetbuffer6 = p_processCustomPayload_1_.getBufferData();
                try {
                    int j1 = packetbuffer6.readVarInt();
                    this.playerEntity.inventory.pickItem(j1);
                    this.playerEntity.connection.sendPacket(new SPacketSetSlot(-2, this.playerEntity.inventory.currentItem, this.playerEntity.inventory.getStackInSlot(this.playerEntity.inventory.currentItem)));
                    this.playerEntity.connection.sendPacket(new SPacketSetSlot(-2, j1, this.playerEntity.inventory.getStackInSlot(j1)));
                    this.playerEntity.connection.sendPacket(new SPacketHeldItemChange(this.playerEntity.inventory.currentItem));
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't pick item", (Throwable)exception);
                }
            }
        }
    }
}

