/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class NettyPacketEncoder
extends MessageToByteEncoder<Packet<?>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker RECEIVED_PACKET_MARKER = MarkerManager.getMarker((String)"PACKET_SENT", (Marker)NetworkManager.NETWORK_PACKETS_MARKER);
    private final EnumPacketDirection direction;

    public NettyPacketEncoder(EnumPacketDirection p_i45998_1_) {
        this.direction = p_i45998_1_;
    }

    protected void encode(ChannelHandlerContext p_encode_1_, Packet<?> p_encode_2_, ByteBuf p_encode_3_) throws IOException, Exception {
        Integer lvt_4_1_ = ((EnumConnectionState)((Object)p_encode_1_.channel().attr(NetworkManager.PROTOCOL_ATTRIBUTE_KEY).get())).getPacketId(this.direction, p_encode_2_);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(RECEIVED_PACKET_MARKER, "OUT: [{}:{}] {}", new Object[]{p_encode_1_.channel().attr(NetworkManager.PROTOCOL_ATTRIBUTE_KEY).get(), lvt_4_1_, p_encode_2_.getClass().getName()});
        }
        if (lvt_4_1_ == null) {
            throw new IOException("Can't serialize unregistered packet");
        }
        PacketBuffer lvt_5_1_ = new PacketBuffer(p_encode_3_);
        lvt_5_1_.writeVarInt(lvt_4_1_);
        try {
            p_encode_2_.writePacketData(lvt_5_1_);
        }
        catch (Throwable lvt_6_1_) {
            LOGGER.error((Object)lvt_6_1_);
        }
    }

    protected /* synthetic */ void encode(ChannelHandlerContext p_encode_1_, Object p_encode_2_, ByteBuf p_encode_3_) throws IOException, Exception {
        this.encode(p_encode_1_, (Packet)p_encode_2_, p_encode_3_);
    }
}

