/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.text.ITextComponent;

public class DataSerializers {
    private static final IntIdentityHashBiMap<DataSerializer<?>> REGISTRY = new IntIdentityHashBiMap(16);
    public static final DataSerializer<Byte> BYTE = new DataSerializer<Byte>(){

        @Override
        public void write(PacketBuffer p_write_1_, Byte p_write_2_) {
            p_write_1_.writeByte(p_write_2_.byteValue());
        }

        @Override
        public Byte read(PacketBuffer p_read_1_) throws IOException {
            return p_read_1_.readByte();
        }

        @Override
        public DataParameter<Byte> createKey(int p_createKey_1_) {
            return new DataParameter<Byte>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<Integer> VARINT = new DataSerializer<Integer>(){

        @Override
        public void write(PacketBuffer p_write_1_, Integer p_write_2_) {
            p_write_1_.writeVarInt(p_write_2_);
        }

        @Override
        public Integer read(PacketBuffer p_read_1_) throws IOException {
            return p_read_1_.readVarInt();
        }

        @Override
        public DataParameter<Integer> createKey(int p_createKey_1_) {
            return new DataParameter<Integer>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<Float> FLOAT = new DataSerializer<Float>(){

        @Override
        public void write(PacketBuffer p_write_1_, Float p_write_2_) {
            p_write_1_.writeFloat(p_write_2_.floatValue());
        }

        @Override
        public Float read(PacketBuffer p_read_1_) throws IOException {
            return Float.valueOf(p_read_1_.readFloat());
        }

        @Override
        public DataParameter<Float> createKey(int p_createKey_1_) {
            return new DataParameter<Float>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<String> STRING = new DataSerializer<String>(){

        @Override
        public void write(PacketBuffer p_write_1_, String p_write_2_) {
            p_write_1_.writeString(p_write_2_);
        }

        @Override
        public String read(PacketBuffer p_read_1_) throws IOException {
            return p_read_1_.readString(Short.MAX_VALUE);
        }

        @Override
        public DataParameter<String> createKey(int p_createKey_1_) {
            return new DataParameter<String>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<ITextComponent> TEXT_COMPONENT = new DataSerializer<ITextComponent>(){

        @Override
        public void write(PacketBuffer p_write_1_, ITextComponent p_write_2_) {
            p_write_1_.writeTextComponent(p_write_2_);
        }

        @Override
        public ITextComponent read(PacketBuffer p_read_1_) throws IOException {
            return p_read_1_.readTextComponent();
        }

        @Override
        public DataParameter<ITextComponent> createKey(int p_createKey_1_) {
            return new DataParameter<ITextComponent>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<ItemStack> OPTIONAL_ITEM_STACK = new DataSerializer<ItemStack>(){

        @Override
        public void write(PacketBuffer p_write_1_, ItemStack p_write_2_) {
            p_write_1_.writeItemStack(p_write_2_);
        }

        @Override
        public ItemStack read(PacketBuffer p_read_1_) throws IOException {
            return p_read_1_.readItemStack();
        }

        @Override
        public DataParameter<ItemStack> createKey(int p_createKey_1_) {
            return new DataParameter<ItemStack>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<Optional<IBlockState>> OPTIONAL_BLOCK_STATE = new DataSerializer<Optional<IBlockState>>(){

        @Override
        public void write(PacketBuffer p_write_1_, Optional<IBlockState> p_write_2_) {
            if (p_write_2_.isPresent()) {
                p_write_1_.writeVarInt(Block.getStateId((IBlockState)p_write_2_.get()));
            } else {
                p_write_1_.writeVarInt(0);
            }
        }

        @Override
        public Optional<IBlockState> read(PacketBuffer p_read_1_) throws IOException {
            int lvt_2_1_ = p_read_1_.readVarInt();
            if (lvt_2_1_ == 0) {
                return Optional.absent();
            }
            return Optional.of((Object)Block.getStateById(lvt_2_1_));
        }

        @Override
        public DataParameter<Optional<IBlockState>> createKey(int p_createKey_1_) {
            return new DataParameter<Optional<IBlockState>>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<Boolean> BOOLEAN = new DataSerializer<Boolean>(){

        @Override
        public void write(PacketBuffer p_write_1_, Boolean p_write_2_) {
            p_write_1_.writeBoolean(p_write_2_);
        }

        @Override
        public Boolean read(PacketBuffer p_read_1_) throws IOException {
            return p_read_1_.readBoolean();
        }

        @Override
        public DataParameter<Boolean> createKey(int p_createKey_1_) {
            return new DataParameter<Boolean>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<Rotations> ROTATIONS = new DataSerializer<Rotations>(){

        @Override
        public void write(PacketBuffer p_write_1_, Rotations p_write_2_) {
            p_write_1_.writeFloat(p_write_2_.getX());
            p_write_1_.writeFloat(p_write_2_.getY());
            p_write_1_.writeFloat(p_write_2_.getZ());
        }

        @Override
        public Rotations read(PacketBuffer p_read_1_) throws IOException {
            return new Rotations(p_read_1_.readFloat(), p_read_1_.readFloat(), p_read_1_.readFloat());
        }

        @Override
        public DataParameter<Rotations> createKey(int p_createKey_1_) {
            return new DataParameter<Rotations>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<BlockPos> BLOCK_POS = new DataSerializer<BlockPos>(){

        @Override
        public void write(PacketBuffer p_write_1_, BlockPos p_write_2_) {
            p_write_1_.writeBlockPos(p_write_2_);
        }

        @Override
        public BlockPos read(PacketBuffer p_read_1_) throws IOException {
            return p_read_1_.readBlockPos();
        }

        @Override
        public DataParameter<BlockPos> createKey(int p_createKey_1_) {
            return new DataParameter<BlockPos>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<Optional<BlockPos>> OPTIONAL_BLOCK_POS = new DataSerializer<Optional<BlockPos>>(){

        @Override
        public void write(PacketBuffer p_write_1_, Optional<BlockPos> p_write_2_) {
            p_write_1_.writeBoolean(p_write_2_.isPresent());
            if (p_write_2_.isPresent()) {
                p_write_1_.writeBlockPos((BlockPos)p_write_2_.get());
            }
        }

        @Override
        public Optional<BlockPos> read(PacketBuffer p_read_1_) throws IOException {
            if (!p_read_1_.readBoolean()) {
                return Optional.absent();
            }
            return Optional.of((Object)p_read_1_.readBlockPos());
        }

        @Override
        public DataParameter<Optional<BlockPos>> createKey(int p_createKey_1_) {
            return new DataParameter<Optional<BlockPos>>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<EnumFacing> FACING = new DataSerializer<EnumFacing>(){

        @Override
        public void write(PacketBuffer p_write_1_, EnumFacing p_write_2_) {
            p_write_1_.writeEnumValue(p_write_2_);
        }

        @Override
        public EnumFacing read(PacketBuffer p_read_1_) throws IOException {
            return p_read_1_.readEnumValue(EnumFacing.class);
        }

        @Override
        public DataParameter<EnumFacing> createKey(int p_createKey_1_) {
            return new DataParameter<EnumFacing>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };
    public static final DataSerializer<Optional<UUID>> OPTIONAL_UNIQUE_ID = new DataSerializer<Optional<UUID>>(){

        @Override
        public void write(PacketBuffer p_write_1_, Optional<UUID> p_write_2_) {
            p_write_1_.writeBoolean(p_write_2_.isPresent());
            if (p_write_2_.isPresent()) {
                p_write_1_.writeUniqueId((UUID)p_write_2_.get());
            }
        }

        @Override
        public Optional<UUID> read(PacketBuffer p_read_1_) throws IOException {
            if (!p_read_1_.readBoolean()) {
                return Optional.absent();
            }
            return Optional.of((Object)p_read_1_.readUniqueId());
        }

        @Override
        public DataParameter<Optional<UUID>> createKey(int p_createKey_1_) {
            return new DataParameter<Optional<UUID>>(p_createKey_1_, this);
        }

        @Override
        public /* synthetic */ Object read(PacketBuffer p_read_1_) throws IOException {
            return this.read(p_read_1_);
        }
    };

    public static void registerSerializer(DataSerializer<?> p_registerSerializer_0_) {
        REGISTRY.add(p_registerSerializer_0_);
    }

    @Nullable
    public static DataSerializer<?> getSerializer(int p_getSerializer_0_) {
        return REGISTRY.get(p_getSerializer_0_);
    }

    public static int getSerializerId(DataSerializer<?> p_getSerializerId_0_) {
        return REGISTRY.getId(p_getSerializerId_0_);
    }

    static {
        DataSerializers.registerSerializer(BYTE);
        DataSerializers.registerSerializer(VARINT);
        DataSerializers.registerSerializer(FLOAT);
        DataSerializers.registerSerializer(STRING);
        DataSerializers.registerSerializer(TEXT_COMPONENT);
        DataSerializers.registerSerializer(OPTIONAL_ITEM_STACK);
        DataSerializers.registerSerializer(BOOLEAN);
        DataSerializers.registerSerializer(ROTATIONS);
        DataSerializers.registerSerializer(BLOCK_POS);
        DataSerializers.registerSerializer(OPTIONAL_BLOCK_POS);
        DataSerializers.registerSerializer(FACING);
        DataSerializers.registerSerializer(OPTIONAL_UNIQUE_ID);
        DataSerializers.registerSerializer(OPTIONAL_BLOCK_STATE);
    }
}

