/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ReportedException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityDataManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Class<? extends Entity>, Integer> NEXT_ID_MAP = Maps.newHashMap();
    private final Entity entity;
    private final Map<Integer, DataEntry<?>> entries = Maps.newHashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean empty = true;
    private boolean dirty;

    public EntityDataManager(Entity p_i46840_1_) {
        this.entity = p_i46840_1_;
    }

    public static <T> DataParameter<T> createKey(Class<? extends Entity> p_createKey_0_, DataSerializer<T> p_createKey_1_) {
        int lvt_2_3_;
        if (LOGGER.isDebugEnabled()) {
            try {
                Class<?> lvt_2_1_ = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!lvt_2_1_.equals(p_createKey_0_)) {
                    LOGGER.debug("defineId called for: {} from {}", new Object[]{p_createKey_0_, lvt_2_1_, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException lvt_2_1_) {
                // empty catch block
            }
        }
        if (NEXT_ID_MAP.containsKey(p_createKey_0_)) {
            int lvt_2_2_ = NEXT_ID_MAP.get(p_createKey_0_) + 1;
        } else {
            int lvt_3_1_ = 0;
            Class<? extends Entity> lvt_4_1_ = p_createKey_0_;
            while (lvt_4_1_ != Entity.class) {
                if (!NEXT_ID_MAP.containsKey(lvt_4_1_ = lvt_4_1_.getSuperclass())) continue;
                lvt_3_1_ = NEXT_ID_MAP.get(lvt_4_1_) + 1;
                break;
            }
            lvt_2_3_ = lvt_3_1_;
        }
        if (lvt_2_3_ > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + lvt_2_3_ + "! (Max is " + 254 + ")");
        }
        NEXT_ID_MAP.put(p_createKey_0_, lvt_2_3_);
        return p_createKey_1_.createKey(lvt_2_3_);
    }

    public <T> void register(DataParameter<T> p_register_1_, T p_register_2_) {
        int lvt_3_1_ = p_register_1_.getId();
        if (lvt_3_1_ > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + lvt_3_1_ + "! (Max is " + 254 + ")");
        }
        if (this.entries.containsKey(lvt_3_1_)) {
            throw new IllegalArgumentException("Duplicate id value for " + lvt_3_1_ + "!");
        }
        if (DataSerializers.getSerializerId(p_register_1_.getSerializer()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + p_register_1_.getSerializer() + " for " + lvt_3_1_ + "!");
        }
        this.setEntry(p_register_1_, p_register_2_);
    }

    private <T> void setEntry(DataParameter<T> p_setEntry_1_, T p_setEntry_2_) {
        DataEntry<T> lvt_3_1_ = new DataEntry<T>(p_setEntry_1_, p_setEntry_2_);
        this.lock.writeLock().lock();
        this.entries.put(p_setEntry_1_.getId(), lvt_3_1_);
        this.empty = false;
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - void declaration
     */
    private <T> DataEntry<T> getEntry(DataParameter<T> p_getEntry_1_) {
        void lvt_2_2_;
        this.lock.readLock().lock();
        try {
            DataEntry<?> lvt_2_1_ = this.entries.get(p_getEntry_1_.getId());
        }
        catch (Throwable lvt_3_1_) {
            CrashReport lvt_4_1_ = CrashReport.makeCrashReport(lvt_3_1_, "Getting synched entity data");
            CrashReportCategory lvt_5_1_ = lvt_4_1_.makeCategory("Synched entity data");
            lvt_5_1_.addCrashSection("Data ID", p_getEntry_1_);
            throw new ReportedException(lvt_4_1_);
        }
        this.lock.readLock().unlock();
        return lvt_2_2_;
    }

    public <T> T get(DataParameter<T> p_get_1_) {
        return this.getEntry(p_get_1_).getValue();
    }

    public <T> void set(DataParameter<T> p_set_1_, T p_set_2_) {
        DataEntry<T> lvt_3_1_ = this.getEntry(p_set_1_);
        if (ObjectUtils.notEqual(p_set_2_, lvt_3_1_.getValue())) {
            lvt_3_1_.setValue(p_set_2_);
            this.entity.notifyDataManagerChange(p_set_1_);
            lvt_3_1_.setDirty(true);
            this.dirty = true;
        }
    }

    public <T> void setDirty(DataParameter<T> p_setDirty_1_) {
        ((DataEntry)this.getEntry(p_setDirty_1_)).dirty = true;
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public static void writeEntries(List<DataEntry<?>> p_writeEntries_0_, PacketBuffer p_writeEntries_1_) throws IOException {
        if (p_writeEntries_0_ != null) {
            int lvt_3_1_ = p_writeEntries_0_.size();
            for (int lvt_2_1_ = 0; lvt_2_1_ < lvt_3_1_; ++lvt_2_1_) {
                DataEntry<?> lvt_4_1_ = p_writeEntries_0_.get(lvt_2_1_);
                EntityDataManager.writeEntry(p_writeEntries_1_, lvt_4_1_);
            }
        }
        p_writeEntries_1_.writeByte(255);
    }

    @Nullable
    public List<DataEntry<?>> getDirty() {
        ArrayList lvt_1_1_ = null;
        if (this.dirty) {
            this.lock.readLock().lock();
            for (DataEntry<?> lvt_3_1_ : this.entries.values()) {
                if (!lvt_3_1_.isDirty()) continue;
                lvt_3_1_.setDirty(false);
                if (lvt_1_1_ == null) {
                    lvt_1_1_ = Lists.newArrayList();
                }
                lvt_1_1_.add(lvt_3_1_);
            }
            this.lock.readLock().unlock();
        }
        this.dirty = false;
        return lvt_1_1_;
    }

    public void writeEntries(PacketBuffer p_writeEntries_1_) throws IOException {
        this.lock.readLock().lock();
        for (DataEntry<?> lvt_3_1_ : this.entries.values()) {
            EntityDataManager.writeEntry(p_writeEntries_1_, lvt_3_1_);
        }
        this.lock.readLock().unlock();
        p_writeEntries_1_.writeByte(255);
    }

    @Nullable
    public List<DataEntry<?>> getAll() {
        ArrayList lvt_1_1_ = null;
        this.lock.readLock().lock();
        for (DataEntry<?> lvt_3_1_ : this.entries.values()) {
            if (lvt_1_1_ == null) {
                lvt_1_1_ = Lists.newArrayList();
            }
            lvt_1_1_.add(lvt_3_1_);
        }
        this.lock.readLock().unlock();
        return lvt_1_1_;
    }

    private static <T> void writeEntry(PacketBuffer p_writeEntry_0_, DataEntry<T> p_writeEntry_1_) throws IOException {
        DataParameter<T> lvt_2_1_ = p_writeEntry_1_.getKey();
        int lvt_3_1_ = DataSerializers.getSerializerId(lvt_2_1_.getSerializer());
        if (lvt_3_1_ < 0) {
            throw new EncoderException("Unknown serializer type " + lvt_2_1_.getSerializer());
        }
        p_writeEntry_0_.writeByte(lvt_2_1_.getId());
        p_writeEntry_0_.writeVarInt(lvt_3_1_);
        lvt_2_1_.getSerializer().write(p_writeEntry_0_, p_writeEntry_1_.getValue());
    }

    @Nullable
    public static List<DataEntry<?>> readEntries(PacketBuffer p_readEntries_0_) throws IOException {
        short lvt_2_1_;
        ArrayList lvt_1_1_ = null;
        while ((lvt_2_1_ = p_readEntries_0_.readUnsignedByte()) != 255) {
            int lvt_3_1_;
            DataSerializer<?> lvt_4_1_;
            if (lvt_1_1_ == null) {
                lvt_1_1_ = Lists.newArrayList();
            }
            if ((lvt_4_1_ = DataSerializers.getSerializer(lvt_3_1_ = p_readEntries_0_.readVarInt())) == null) {
                throw new DecoderException("Unknown serializer type " + lvt_3_1_);
            }
            lvt_1_1_.add(new DataEntry(lvt_4_1_.createKey(lvt_2_1_), lvt_4_1_.read(p_readEntries_0_)));
        }
        return lvt_1_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void setEntryValues(List<DataEntry<?>> p_setEntryValues_1_) {
        this.lock.writeLock().lock();
        for (DataEntry<?> lvt_3_1_ : p_setEntryValues_1_) {
            DataEntry<?> lvt_4_1_ = this.entries.get(lvt_3_1_.getKey().getId());
            if (lvt_4_1_ == null) continue;
            this.setEntryValue(lvt_4_1_, lvt_3_1_);
            this.entity.notifyDataManagerChange(lvt_3_1_.getKey());
        }
        this.lock.writeLock().unlock();
        this.dirty = true;
    }

    @SideOnly(value=Side.CLIENT)
    protected <T> void setEntryValue(DataEntry<T> p_setEntryValue_1_, DataEntry<?> p_setEntryValue_2_) {
        p_setEntryValue_1_.setValue(p_setEntryValue_2_.getValue());
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setClean() {
        this.dirty = false;
        this.lock.readLock().lock();
        for (DataEntry<?> lvt_2_1_ : this.entries.values()) {
            lvt_2_1_.setDirty(false);
        }
        this.lock.readLock().unlock();
    }

    public static class DataEntry<T> {
        private final DataParameter<T> key;
        private T value;
        private boolean dirty;

        public DataEntry(DataParameter<T> p_i47010_1_, T p_i47010_2_) {
            this.key = p_i47010_1_;
            this.value = p_i47010_2_;
            this.dirty = true;
        }

        public DataParameter<T> getKey() {
            return this.key;
        }

        public void setValue(T p_setValue_1_) {
            this.value = p_setValue_1_;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean p_setDirty_1_) {
            this.dirty = p_setDirty_1_;
        }
    }
}

