/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.handshake.client;

import java.io.IOException;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.handshake.INetHandlerHandshakeServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class C00Handshake
implements Packet<INetHandlerHandshakeServer> {
    private int protocolVersion;
    private String ip;
    private int port;
    private EnumConnectionState requestedState;
    private boolean hasFMLMarker = false;

    public C00Handshake() {
    }

    @SideOnly(value=Side.CLIENT)
    public C00Handshake(int p_i45266_1_, String p_i45266_2_, int p_i45266_3_, EnumConnectionState p_i45266_4_) {
        this.protocolVersion = p_i45266_1_;
        this.ip = p_i45266_2_;
        this.port = p_i45266_3_;
        this.requestedState = p_i45266_4_;
    }

    public C00Handshake(int p_i2_1_, String p_i2_2_, int p_i2_3_, EnumConnectionState p_i2_4_, boolean p_i2_5_) {
        this(p_i2_1_, p_i2_2_, p_i2_3_, p_i2_4_);
        this.hasFMLMarker = p_i2_5_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.protocolVersion = p_readPacketData_1_.readVarInt();
        this.ip = p_readPacketData_1_.readString(255);
        this.port = p_readPacketData_1_.readUnsignedShort();
        this.requestedState = EnumConnectionState.getById(p_readPacketData_1_.readVarInt());
        this.hasFMLMarker = this.ip.contains("\u0000FML\u0000");
        this.ip = this.ip.split("\u0000")[0];
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.protocolVersion);
        p_writePacketData_1_.writeString(this.ip + "\u0000FML\u0000");
        p_writePacketData_1_.writeShort(this.port);
        p_writePacketData_1_.writeVarInt(this.requestedState.getId());
    }

    @Override
    public void processPacket(INetHandlerHandshakeServer p_processPacket_1_) {
        p_processPacket_1_.processHandshake(this);
    }

    public EnumConnectionState getRequestedState() {
        return this.requestedState;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean hasFMLMarker() {
        return this.hasFMLMarker;
    }
}

