/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.login.client;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.login.INetHandlerLoginServer;
import net.minecraft.util.CryptManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CPacketEncryptionResponse
implements Packet<INetHandlerLoginServer> {
    private byte[] secretKeyEncrypted = new byte[0];
    private byte[] verifyTokenEncrypted = new byte[0];

    public CPacketEncryptionResponse() {
    }

    @SideOnly(value=Side.CLIENT)
    public CPacketEncryptionResponse(SecretKey p_i46851_1_, PublicKey p_i46851_2_, byte[] p_i46851_3_) {
        this.secretKeyEncrypted = CryptManager.encryptData(p_i46851_2_, p_i46851_1_.getEncoded());
        this.verifyTokenEncrypted = CryptManager.encryptData(p_i46851_2_, p_i46851_3_);
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.secretKeyEncrypted = p_readPacketData_1_.readByteArray();
        this.verifyTokenEncrypted = p_readPacketData_1_.readByteArray();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeByteArray(this.secretKeyEncrypted);
        p_writePacketData_1_.writeByteArray(this.verifyTokenEncrypted);
    }

    @Override
    public void processPacket(INetHandlerLoginServer p_processPacket_1_) {
        p_processPacket_1_.processEncryptionResponse(this);
    }

    public SecretKey getSecretKey(PrivateKey p_getSecretKey_1_) {
        return CryptManager.decryptSharedKey(p_getSecretKey_1_, this.secretKeyEncrypted);
    }

    public byte[] getVerifyToken(PrivateKey p_getVerifyToken_1_) {
        if (p_getVerifyToken_1_ == null) {
            return this.verifyTokenEncrypted;
        }
        return CryptManager.decryptData(p_getVerifyToken_1_, this.verifyTokenEncrypted);
    }
}

