/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.login.server;

import java.io.IOException;
import java.security.PublicKey;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.login.INetHandlerLoginClient;
import net.minecraft.util.CryptManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketEncryptionRequest
implements Packet<INetHandlerLoginClient> {
    private String hashedServerId;
    private PublicKey publicKey;
    private byte[] verifyToken;

    public SPacketEncryptionRequest() {
    }

    public SPacketEncryptionRequest(String p_i46855_1_, PublicKey p_i46855_2_, byte[] p_i46855_3_) {
        this.hashedServerId = p_i46855_1_;
        this.publicKey = p_i46855_2_;
        this.verifyToken = p_i46855_3_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.hashedServerId = p_readPacketData_1_.readString(20);
        this.publicKey = CryptManager.decodePublicKey(p_readPacketData_1_.readByteArray());
        this.verifyToken = p_readPacketData_1_.readByteArray();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeString(this.hashedServerId);
        p_writePacketData_1_.writeByteArray(this.publicKey.getEncoded());
        p_writePacketData_1_.writeByteArray(this.verifyToken);
    }

    @Override
    public void processPacket(INetHandlerLoginClient p_processPacket_1_) {
        p_processPacket_1_.handleEncryptionRequest(this);
    }

    @SideOnly(value=Side.CLIENT)
    public String getServerId() {
        return this.hashedServerId;
    }

    @SideOnly(value=Side.CLIENT)
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @SideOnly(value=Side.CLIENT)
    public byte[] getVerifyToken() {
        return this.verifyToken;
    }
}

