/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.client;

import java.io.IOException;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CPacketClickWindow
implements Packet<INetHandlerPlayServer> {
    private int windowId;
    private int slotId;
    private int packedClickData;
    private short actionNumber;
    private ItemStack clickedItem = ItemStack.EMPTY;
    private ClickType mode;

    public CPacketClickWindow() {
    }

    @SideOnly(value=Side.CLIENT)
    public CPacketClickWindow(int p_i46882_1_, int p_i46882_2_, int p_i46882_3_, ClickType p_i46882_4_, ItemStack p_i46882_5_, short p_i46882_6_) {
        this.windowId = p_i46882_1_;
        this.slotId = p_i46882_2_;
        this.packedClickData = p_i46882_3_;
        this.clickedItem = p_i46882_5_.isEmpty() ? ItemStack.EMPTY : p_i46882_5_.copy();
        this.actionNumber = p_i46882_6_;
        this.mode = p_i46882_4_;
    }

    @Override
    public void processPacket(INetHandlerPlayServer p_processPacket_1_) {
        p_processPacket_1_.processClickWindow(this);
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.windowId = p_readPacketData_1_.readByte();
        this.slotId = p_readPacketData_1_.readShort();
        this.packedClickData = p_readPacketData_1_.readByte();
        this.actionNumber = p_readPacketData_1_.readShort();
        this.mode = p_readPacketData_1_.readEnumValue(ClickType.class);
        this.clickedItem = p_readPacketData_1_.readItemStack();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeByte(this.windowId);
        p_writePacketData_1_.writeShort(this.slotId);
        p_writePacketData_1_.writeByte(this.packedClickData);
        p_writePacketData_1_.writeShort(this.actionNumber);
        p_writePacketData_1_.writeEnumValue(this.mode);
        p_writePacketData_1_.writeItemStack(this.clickedItem);
    }

    public int getWindowId() {
        return this.windowId;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public int getUsedButton() {
        return this.packedClickData;
    }

    public short getActionNumber() {
        return this.actionNumber;
    }

    public ItemStack getClickedItem() {
        return this.clickedItem;
    }

    public ClickType getClickType() {
        return this.mode;
    }
}

