/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.client;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CPacketCustomPayload
implements Packet<INetHandlerPlayServer> {
    private String channel;
    private PacketBuffer data;

    public CPacketCustomPayload() {
    }

    @SideOnly(value=Side.CLIENT)
    public CPacketCustomPayload(String p_i46880_1_, PacketBuffer p_i46880_2_) {
        this.channel = p_i46880_1_;
        this.data = p_i46880_2_;
        if (p_i46880_2_.writerIndex() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Payload may not be larger than 32767 bytes");
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.channel = p_readPacketData_1_.readString(20);
        int i = p_readPacketData_1_.readableBytes();
        if (i < 0 || i > Short.MAX_VALUE) {
            throw new IOException("Payload may not be larger than 32767 bytes");
        }
        this.data = new PacketBuffer(p_readPacketData_1_.readBytes(i));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeString(this.channel);
        PacketBuffer packetBuffer = this.data;
        synchronized (packetBuffer) {
            this.data.markReaderIndex();
            p_writePacketData_1_.writeBytes(this.data);
            this.data.resetReaderIndex();
        }
    }

    @Override
    public void processPacket(INetHandlerPlayServer p_processPacket_1_) {
        p_processPacket_1_.processCustomPayload(this);
        if (this.data != null) {
            this.data.release();
        }
    }

    public String getChannelName() {
        return this.channel;
    }

    public PacketBuffer getBufferData() {
        return this.data;
    }
}

