/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.client;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CPacketInput
implements Packet<INetHandlerPlayServer> {
    private float strafeSpeed;
    private float forwardSpeed;
    private boolean jumping;
    private boolean sneaking;

    public CPacketInput() {
    }

    @SideOnly(value=Side.CLIENT)
    public CPacketInput(float p_i46868_1_, float p_i46868_2_, boolean p_i46868_3_, boolean p_i46868_4_) {
        this.strafeSpeed = p_i46868_1_;
        this.forwardSpeed = p_i46868_2_;
        this.jumping = p_i46868_3_;
        this.sneaking = p_i46868_4_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.strafeSpeed = p_readPacketData_1_.readFloat();
        this.forwardSpeed = p_readPacketData_1_.readFloat();
        byte lvt_2_1_ = p_readPacketData_1_.readByte();
        this.jumping = (lvt_2_1_ & 1) > 0;
        this.sneaking = (lvt_2_1_ & 2) > 0;
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeFloat(this.strafeSpeed);
        p_writePacketData_1_.writeFloat(this.forwardSpeed);
        byte lvt_2_1_ = 0;
        if (this.jumping) {
            lvt_2_1_ = (byte)(lvt_2_1_ | 1);
        }
        if (this.sneaking) {
            lvt_2_1_ = (byte)(lvt_2_1_ | 2);
        }
        p_writePacketData_1_.writeByte(lvt_2_1_);
    }

    @Override
    public void processPacket(INetHandlerPlayServer p_processPacket_1_) {
        p_processPacket_1_.processInput(this);
    }

    public float getStrafeSpeed() {
        return this.strafeSpeed;
    }

    public float getForwardSpeed() {
        return this.forwardSpeed;
    }

    public boolean isJumping() {
        return this.jumping;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }
}

