/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.client;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CPacketPlayer
implements Packet<INetHandlerPlayServer> {
    protected double x;
    protected double y;
    protected double z;
    protected float yaw;
    protected float pitch;
    protected boolean onGround;
    protected boolean moving;
    protected boolean rotating;

    public CPacketPlayer() {
    }

    @SideOnly(value=Side.CLIENT)
    public CPacketPlayer(boolean p_i46875_1_) {
        this.onGround = p_i46875_1_;
    }

    @Override
    public void processPacket(INetHandlerPlayServer p_processPacket_1_) {
        p_processPacket_1_.processPlayer(this);
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.onGround = p_readPacketData_1_.readUnsignedByte() != 0;
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeByte(this.onGround ? 1 : 0);
    }

    public double getX(double p_getX_1_) {
        return this.moving ? this.x : p_getX_1_;
    }

    public double getY(double p_getY_1_) {
        return this.moving ? this.y : p_getY_1_;
    }

    public double getZ(double p_getZ_1_) {
        return this.moving ? this.z : p_getZ_1_;
    }

    public float getYaw(float p_getYaw_1_) {
        return this.rotating ? this.yaw : p_getYaw_1_;
    }

    public float getPitch(float p_getPitch_1_) {
        return this.rotating ? this.pitch : p_getPitch_1_;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public static class Rotation
    extends CPacketPlayer {
        public Rotation() {
            this.rotating = true;
        }

        @SideOnly(value=Side.CLIENT)
        public Rotation(float p_i46863_1_, float p_i46863_2_, boolean p_i46863_3_) {
            this.yaw = p_i46863_1_;
            this.pitch = p_i46863_2_;
            this.onGround = p_i46863_3_;
            this.rotating = true;
        }

        @Override
        public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
            this.yaw = p_readPacketData_1_.readFloat();
            this.pitch = p_readPacketData_1_.readFloat();
            super.readPacketData(p_readPacketData_1_);
        }

        @Override
        public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
            p_writePacketData_1_.writeFloat(this.yaw);
            p_writePacketData_1_.writeFloat(this.pitch);
            super.writePacketData(p_writePacketData_1_);
        }
    }

    public static class Position
    extends CPacketPlayer {
        public Position() {
            this.moving = true;
        }

        @SideOnly(value=Side.CLIENT)
        public Position(double p_i46867_1_, double p_i46867_3_, double p_i46867_5_, boolean p_i46867_7_) {
            this.x = p_i46867_1_;
            this.y = p_i46867_3_;
            this.z = p_i46867_5_;
            this.onGround = p_i46867_7_;
            this.moving = true;
        }

        @Override
        public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
            this.x = p_readPacketData_1_.readDouble();
            this.y = p_readPacketData_1_.readDouble();
            this.z = p_readPacketData_1_.readDouble();
            super.readPacketData(p_readPacketData_1_);
        }

        @Override
        public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
            p_writePacketData_1_.writeDouble(this.x);
            p_writePacketData_1_.writeDouble(this.y);
            p_writePacketData_1_.writeDouble(this.z);
            super.writePacketData(p_writePacketData_1_);
        }
    }

    public static class PositionRotation
    extends CPacketPlayer {
        public PositionRotation() {
            this.moving = true;
            this.rotating = true;
        }

        @SideOnly(value=Side.CLIENT)
        public PositionRotation(double p_i46865_1_, double p_i46865_3_, double p_i46865_5_, float p_i46865_7_, float p_i46865_8_, boolean p_i46865_9_) {
            this.x = p_i46865_1_;
            this.y = p_i46865_3_;
            this.z = p_i46865_5_;
            this.yaw = p_i46865_7_;
            this.pitch = p_i46865_8_;
            this.onGround = p_i46865_9_;
            this.rotating = true;
            this.moving = true;
        }

        @Override
        public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
            this.x = p_readPacketData_1_.readDouble();
            this.y = p_readPacketData_1_.readDouble();
            this.z = p_readPacketData_1_.readDouble();
            this.yaw = p_readPacketData_1_.readFloat();
            this.pitch = p_readPacketData_1_.readFloat();
            super.readPacketData(p_readPacketData_1_);
        }

        @Override
        public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
            p_writePacketData_1_.writeDouble(this.x);
            p_writePacketData_1_.writeDouble(this.y);
            p_writePacketData_1_.writeDouble(this.z);
            p_writePacketData_1_.writeFloat(this.yaw);
            p_writePacketData_1_.writeFloat(this.pitch);
            super.writePacketData(p_writePacketData_1_);
        }
    }
}

