/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.client;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CPacketPlayerDigging
implements Packet<INetHandlerPlayServer> {
    private BlockPos position;
    private EnumFacing facing;
    private Action action;

    public CPacketPlayerDigging() {
    }

    @SideOnly(value=Side.CLIENT)
    public CPacketPlayerDigging(Action p_i46871_1_, BlockPos p_i46871_2_, EnumFacing p_i46871_3_) {
        this.action = p_i46871_1_;
        this.position = p_i46871_2_;
        this.facing = p_i46871_3_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.action = p_readPacketData_1_.readEnumValue(Action.class);
        this.position = p_readPacketData_1_.readBlockPos();
        this.facing = EnumFacing.getFront(p_readPacketData_1_.readUnsignedByte());
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeEnumValue(this.action);
        p_writePacketData_1_.writeBlockPos(this.position);
        p_writePacketData_1_.writeByte(this.facing.getIndex());
    }

    @Override
    public void processPacket(INetHandlerPlayServer p_processPacket_1_) {
        p_processPacket_1_.processPlayerDigging(this);
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public Action getAction() {
        return this.action;
    }

    public static enum Action {
        START_DESTROY_BLOCK,
        ABORT_DESTROY_BLOCK,
        STOP_DESTROY_BLOCK,
        DROP_ALL_ITEMS,
        DROP_ITEM,
        RELEASE_USE_ITEM,
        SWAP_HELD_ITEMS;

    }
}

