/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.client;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class CPacketTabComplete
implements Packet<INetHandlerPlayServer> {
    private String message;
    private boolean hasTargetBlock;
    @Nullable
    private BlockPos targetBlock;

    public CPacketTabComplete() {
    }

    @SideOnly(value=Side.CLIENT)
    public CPacketTabComplete(String p_i46888_1_, BlockPos p_i46888_2_, boolean p_i46888_3_) {
        this.message = p_i46888_1_;
        this.targetBlock = p_i46888_2_;
        this.hasTargetBlock = p_i46888_3_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.message = p_readPacketData_1_.readString(Short.MAX_VALUE);
        this.hasTargetBlock = p_readPacketData_1_.readBoolean();
        boolean lvt_2_1_ = p_readPacketData_1_.readBoolean();
        if (lvt_2_1_) {
            this.targetBlock = p_readPacketData_1_.readBlockPos();
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeString(StringUtils.substring((String)this.message, (int)0, (int)Short.MAX_VALUE));
        p_writePacketData_1_.writeBoolean(this.hasTargetBlock);
        boolean lvt_2_1_ = this.targetBlock != null;
        p_writePacketData_1_.writeBoolean(lvt_2_1_);
        if (lvt_2_1_) {
            p_writePacketData_1_.writeBlockPos(this.targetBlock);
        }
    }

    @Override
    public void processPacket(INetHandlerPlayServer p_processPacket_1_) {
        p_processPacket_1_.processTabComplete(this);
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public BlockPos getTargetBlock() {
        return this.targetBlock;
    }

    public boolean hasTargetBlock() {
        return this.hasTargetBlock;
    }
}

