/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.client;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CPacketUseEntity
implements Packet<INetHandlerPlayServer> {
    private int entityId;
    private Action action;
    private Vec3d hitVec;
    private EnumHand hand;

    public CPacketUseEntity() {
    }

    public CPacketUseEntity(Entity p_i46877_1_) {
        this.entityId = p_i46877_1_.getEntityId();
        this.action = Action.ATTACK;
    }

    @SideOnly(value=Side.CLIENT)
    public CPacketUseEntity(Entity p_i46878_1_, EnumHand p_i46878_2_) {
        this.entityId = p_i46878_1_.getEntityId();
        this.action = Action.INTERACT;
        this.hand = p_i46878_2_;
    }

    @SideOnly(value=Side.CLIENT)
    public CPacketUseEntity(Entity p_i47098_1_, EnumHand p_i47098_2_, Vec3d p_i47098_3_) {
        this.entityId = p_i47098_1_.getEntityId();
        this.action = Action.INTERACT_AT;
        this.hand = p_i47098_2_;
        this.hitVec = p_i47098_3_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityId = p_readPacketData_1_.readVarInt();
        this.action = p_readPacketData_1_.readEnumValue(Action.class);
        if (this.action == Action.INTERACT_AT) {
            this.hitVec = new Vec3d(p_readPacketData_1_.readFloat(), p_readPacketData_1_.readFloat(), p_readPacketData_1_.readFloat());
        }
        if (this.action == Action.INTERACT || this.action == Action.INTERACT_AT) {
            this.hand = p_readPacketData_1_.readEnumValue(EnumHand.class);
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityId);
        p_writePacketData_1_.writeEnumValue(this.action);
        if (this.action == Action.INTERACT_AT) {
            p_writePacketData_1_.writeFloat((float)this.hitVec.xCoord);
            p_writePacketData_1_.writeFloat((float)this.hitVec.yCoord);
            p_writePacketData_1_.writeFloat((float)this.hitVec.zCoord);
        }
        if (this.action == Action.INTERACT || this.action == Action.INTERACT_AT) {
            p_writePacketData_1_.writeEnumValue(this.hand);
        }
    }

    @Override
    public void processPacket(INetHandlerPlayServer p_processPacket_1_) {
        p_processPacket_1_.processUseEntity(this);
    }

    @Nullable
    public Entity getEntityFromWorld(World p_getEntityFromWorld_1_) {
        return p_getEntityFromWorld_1_.getEntityByID(this.entityId);
    }

    public Action getAction() {
        return this.action;
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public Vec3d getHitVec() {
        return this.hitVec;
    }

    public static enum Action {
        INTERACT,
        ATTACK,
        INTERACT_AT;

    }
}

