/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketBlockAction
implements Packet<INetHandlerPlayClient> {
    private BlockPos blockPosition;
    private int instrument;
    private int pitch;
    private Block block;

    public SPacketBlockAction() {
    }

    public SPacketBlockAction(BlockPos p_i46966_1_, Block p_i46966_2_, int p_i46966_3_, int p_i46966_4_) {
        this.blockPosition = p_i46966_1_;
        this.instrument = p_i46966_3_;
        this.pitch = p_i46966_4_;
        this.block = p_i46966_2_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.blockPosition = p_readPacketData_1_.readBlockPos();
        this.instrument = p_readPacketData_1_.readUnsignedByte();
        this.pitch = p_readPacketData_1_.readUnsignedByte();
        this.block = Block.getBlockById(p_readPacketData_1_.readVarInt() & 0xFFF);
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeBlockPos(this.blockPosition);
        p_writePacketData_1_.writeByte(this.instrument);
        p_writePacketData_1_.writeByte(this.pitch);
        p_writePacketData_1_.writeVarInt(Block.getIdFromBlock(this.block) & 0xFFF);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleBlockAction(this);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getBlockPosition() {
        return this.blockPosition;
    }

    @SideOnly(value=Side.CLIENT)
    public int getData1() {
        return this.instrument;
    }

    @SideOnly(value=Side.CLIENT)
    public int getData2() {
        return this.pitch;
    }

    @SideOnly(value=Side.CLIENT)
    public Block getBlockType() {
        return this.block;
    }
}

