/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketBlockChange
implements Packet<INetHandlerPlayClient> {
    private BlockPos blockPosition;
    public IBlockState blockState;

    public SPacketBlockChange() {
    }

    public SPacketBlockChange(World p_i46965_1_, BlockPos p_i46965_2_) {
        this.blockPosition = p_i46965_2_;
        this.blockState = p_i46965_1_.getBlockState(p_i46965_2_);
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.blockPosition = p_readPacketData_1_.readBlockPos();
        this.blockState = Block.BLOCK_STATE_IDS.getByValue(p_readPacketData_1_.readVarInt());
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeBlockPos(this.blockPosition);
        p_writePacketData_1_.writeVarInt(Block.BLOCK_STATE_IDS.get(this.blockState));
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleBlockChange(this);
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getBlockState() {
        return this.blockState;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getBlockPosition() {
        return this.blockPosition;
    }
}

