/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketChunkData
implements Packet<INetHandlerPlayClient> {
    private int chunkX;
    private int chunkZ;
    private int availableSections;
    private byte[] buffer;
    private List<NBTTagCompound> tileEntityTags;
    private boolean loadChunk;

    public SPacketChunkData() {
    }

    public SPacketChunkData(Chunk p_i47124_1_, int p_i47124_2_) {
        this.chunkX = p_i47124_1_.xPosition;
        this.chunkZ = p_i47124_1_.zPosition;
        this.loadChunk = p_i47124_2_ == 65535;
        boolean lvt_3_1_ = p_i47124_1_.getWorld().provider.hasSkyLight();
        this.buffer = new byte[this.calculateChunkSize(p_i47124_1_, lvt_3_1_, p_i47124_2_)];
        this.availableSections = this.extractChunkData(new PacketBuffer(this.getWriteBuffer()), p_i47124_1_, lvt_3_1_, p_i47124_2_);
        this.tileEntityTags = Lists.newArrayList();
        for (Map.Entry<BlockPos, TileEntity> lvt_5_1_ : p_i47124_1_.getTileEntityMap().entrySet()) {
            BlockPos lvt_6_1_ = lvt_5_1_.getKey();
            TileEntity lvt_7_1_ = lvt_5_1_.getValue();
            int lvt_8_1_ = lvt_6_1_.getY() >> 4;
            if (!this.doChunkLoad() && (p_i47124_2_ & 1 << lvt_8_1_) == 0) continue;
            NBTTagCompound lvt_9_1_ = lvt_7_1_.getUpdateTag();
            this.tileEntityTags.add(lvt_9_1_);
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.chunkX = p_readPacketData_1_.readInt();
        this.chunkZ = p_readPacketData_1_.readInt();
        this.loadChunk = p_readPacketData_1_.readBoolean();
        this.availableSections = p_readPacketData_1_.readVarInt();
        int lvt_2_1_ = p_readPacketData_1_.readVarInt();
        if (lvt_2_1_ > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.buffer = new byte[lvt_2_1_];
        p_readPacketData_1_.readBytes(this.buffer);
        int lvt_3_1_ = p_readPacketData_1_.readVarInt();
        this.tileEntityTags = Lists.newArrayList();
        for (int lvt_4_1_ = 0; lvt_4_1_ < lvt_3_1_; ++lvt_4_1_) {
            this.tileEntityTags.add(p_readPacketData_1_.readCompoundTag());
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeInt(this.chunkX);
        p_writePacketData_1_.writeInt(this.chunkZ);
        p_writePacketData_1_.writeBoolean(this.loadChunk);
        p_writePacketData_1_.writeVarInt(this.availableSections);
        p_writePacketData_1_.writeVarInt(this.buffer.length);
        p_writePacketData_1_.writeBytes(this.buffer);
        p_writePacketData_1_.writeVarInt(this.tileEntityTags.size());
        for (NBTTagCompound lvt_3_1_ : this.tileEntityTags) {
            p_writePacketData_1_.writeCompoundTag(lvt_3_1_);
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleChunkData(this);
    }

    @SideOnly(value=Side.CLIENT)
    public PacketBuffer getReadBuffer() {
        return new PacketBuffer(Unpooled.wrappedBuffer((byte[])this.buffer));
    }

    private ByteBuf getWriteBuffer() {
        ByteBuf lvt_1_1_ = Unpooled.wrappedBuffer((byte[])this.buffer);
        lvt_1_1_.writerIndex(0);
        return lvt_1_1_;
    }

    public int extractChunkData(PacketBuffer p_extractChunkData_1_, Chunk p_extractChunkData_2_, boolean p_extractChunkData_3_, int p_extractChunkData_4_) {
        int lvt_5_1_ = 0;
        ExtendedBlockStorage[] lvt_6_1_ = p_extractChunkData_2_.getBlockStorageArray();
        int lvt_8_1_ = lvt_6_1_.length;
        for (int lvt_7_1_ = 0; lvt_7_1_ < lvt_8_1_; ++lvt_7_1_) {
            ExtendedBlockStorage lvt_9_1_ = lvt_6_1_[lvt_7_1_];
            if (lvt_9_1_ == Chunk.NULL_BLOCK_STORAGE || this.doChunkLoad() && lvt_9_1_.isEmpty() || (p_extractChunkData_4_ & 1 << lvt_7_1_) == 0) continue;
            lvt_5_1_ |= 1 << lvt_7_1_;
            lvt_9_1_.getData().write(p_extractChunkData_1_);
            p_extractChunkData_1_.writeBytes(lvt_9_1_.getBlocklightArray().getData());
            if (!p_extractChunkData_3_) continue;
            p_extractChunkData_1_.writeBytes(lvt_9_1_.getSkylightArray().getData());
        }
        if (this.doChunkLoad()) {
            p_extractChunkData_1_.writeBytes(p_extractChunkData_2_.getBiomeArray());
        }
        return lvt_5_1_;
    }

    protected int calculateChunkSize(Chunk p_calculateChunkSize_1_, boolean p_calculateChunkSize_2_, int p_calculateChunkSize_3_) {
        int lvt_4_1_ = 0;
        ExtendedBlockStorage[] lvt_5_1_ = p_calculateChunkSize_1_.getBlockStorageArray();
        int lvt_7_1_ = lvt_5_1_.length;
        for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_7_1_; ++lvt_6_1_) {
            ExtendedBlockStorage lvt_8_1_ = lvt_5_1_[lvt_6_1_];
            if (lvt_8_1_ == Chunk.NULL_BLOCK_STORAGE || this.doChunkLoad() && lvt_8_1_.isEmpty() || (p_calculateChunkSize_3_ & 1 << lvt_6_1_) == 0) continue;
            lvt_4_1_ += lvt_8_1_.getData().getSerializedSize();
            lvt_4_1_ += lvt_8_1_.getBlocklightArray().getData().length;
            if (!p_calculateChunkSize_2_) continue;
            lvt_4_1_ += lvt_8_1_.getSkylightArray().getData().length;
        }
        if (this.doChunkLoad()) {
            lvt_4_1_ += p_calculateChunkSize_1_.getBiomeArray().length;
        }
        return lvt_4_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public int getChunkX() {
        return this.chunkX;
    }

    @SideOnly(value=Side.CLIENT)
    public int getChunkZ() {
        return this.chunkZ;
    }

    @SideOnly(value=Side.CLIENT)
    public int getExtractedSize() {
        return this.availableSections;
    }

    public boolean doChunkLoad() {
        return this.loadChunk;
    }

    @SideOnly(value=Side.CLIENT)
    public List<NBTTagCompound> getTileEntityTags() {
        return this.tileEntityTags;
    }
}

