/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class SPacketCombatEvent
implements Packet<INetHandlerPlayClient> {
    public Event eventType;
    public int playerId;
    public int entityId;
    public int duration;
    public ITextComponent deathMessage;

    public SPacketCombatEvent() {
    }

    public SPacketCombatEvent(CombatTracker p_i46931_1_, Event p_i46931_2_) {
        this(p_i46931_1_, p_i46931_2_, true);
    }

    public SPacketCombatEvent(CombatTracker p_i46932_1_, Event p_i46932_2_, boolean p_i46932_3_) {
        this.eventType = p_i46932_2_;
        EntityLivingBase lvt_4_1_ = p_i46932_1_.getBestAttacker();
        switch (p_i46932_2_) {
            case END_COMBAT: {
                this.duration = p_i46932_1_.getCombatDuration();
                this.entityId = lvt_4_1_ == null ? -1 : lvt_4_1_.getEntityId();
                break;
            }
            case ENTITY_DIED: {
                this.playerId = p_i46932_1_.getFighter().getEntityId();
                this.entityId = lvt_4_1_ == null ? -1 : lvt_4_1_.getEntityId();
                this.deathMessage = p_i46932_3_ ? p_i46932_1_.getDeathMessage() : new TextComponentString("");
            }
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.eventType = p_readPacketData_1_.readEnumValue(Event.class);
        if (this.eventType == Event.END_COMBAT) {
            this.duration = p_readPacketData_1_.readVarInt();
            this.entityId = p_readPacketData_1_.readInt();
        } else if (this.eventType == Event.ENTITY_DIED) {
            this.playerId = p_readPacketData_1_.readVarInt();
            this.entityId = p_readPacketData_1_.readInt();
            this.deathMessage = p_readPacketData_1_.readTextComponent();
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeEnumValue(this.eventType);
        if (this.eventType == Event.END_COMBAT) {
            p_writePacketData_1_.writeVarInt(this.duration);
            p_writePacketData_1_.writeInt(this.entityId);
        } else if (this.eventType == Event.ENTITY_DIED) {
            p_writePacketData_1_.writeVarInt(this.playerId);
            p_writePacketData_1_.writeInt(this.entityId);
            p_writePacketData_1_.writeTextComponent(this.deathMessage);
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleCombatEvent(this);
    }

    public static enum Event {
        ENTER_COMBAT,
        END_COMBAT,
        ENTITY_DIED;

    }
}

