/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketCustomPayload
implements Packet<INetHandlerPlayClient> {
    private String channel;
    private PacketBuffer data;

    public SPacketCustomPayload() {
    }

    public SPacketCustomPayload(String p_i46949_1_, PacketBuffer p_i46949_2_) {
        this.channel = p_i46949_1_;
        this.data = p_i46949_2_;
        if (p_i46949_2_.writerIndex() > 0x100000) {
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.channel = p_readPacketData_1_.readString(20);
        int i = p_readPacketData_1_.readableBytes();
        if (i < 0 || i > 0x100000) {
            throw new IOException("Payload may not be larger than 1048576 bytes");
        }
        this.data = new PacketBuffer(p_readPacketData_1_.readBytes(i));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeString(this.channel);
        PacketBuffer packetBuffer = this.data;
        synchronized (packetBuffer) {
            this.data.markReaderIndex();
            p_writePacketData_1_.writeBytes(this.data);
            this.data.resetReaderIndex();
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleCustomPayload(this);
    }

    @SideOnly(value=Side.CLIENT)
    public String getChannelName() {
        return this.channel;
    }

    @SideOnly(value=Side.CLIENT)
    public PacketBuffer getBufferData() {
        return this.data;
    }
}

